/*
 * Decompiled with CFR 0.152.
 */
package com.iptech.pivot;

import com.iptech.pivot.Contact;
import com.iptech.pivot.ContactAccessListener;
import com.iptech.pivot.ContactSubmitRequestListener;
import com.iptech.pivot.ContactUpdateListener;
import com.iptech.pivot.model.ContactModel;
import com.iptech.pivot.model.RemoteContactModel;
import com.iptech.pivot.ui.EditContactWindow;
import com.iptech.pivot.ui.TableContactsWindow;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Display;

public class Contacts
implements Application,
ContactAccessListener,
ContactUpdateListener,
ContactSubmitRequestListener {
    TableContactsWindow tcw;
    ContactModel model;

    public static void main(String[] args) {
        DesktopApplicationContext.main(Contacts.class, (String[])args);
    }

    public void startup(Display display, Map<String, String> arg1) throws Exception {
        this.tcw = new TableContactsWindow(this);
        this.model = new RemoteContactModel(this);
        this.model.retrieveAllContacts();
        this.tcw.getWindow().open(display);
    }

    @Override
    public void editContactRequest(Contact contact, TableContactsWindow source) {
        EditContactWindow ecw = new EditContactWindow(this, source);
        ecw.setContact(contact);
        ecw.show();
    }

    @Override
    public void addContactRequest(TableContactsWindow source) {
        Contact newContact = new Contact(null, "", "", "", "");
        EditContactWindow ecw = new EditContactWindow(this, source);
        ecw.setContact(newContact);
        ecw.show();
    }

    @Override
    public void contactSubmit(Contact contact, EditContactWindow source) {
        this.model.saveContact(contact);
    }

    @Override
    public void contactsRetrieved(List<Contact> contacts) {
        this.tcw.setContacts(contacts);
    }

    @Override
    public void contactSaved() {
        this.model.retrieveAllContacts();
    }

    public void resume() throws Exception {
    }

    public void suspend() throws Exception {
    }

    public boolean shutdown(boolean arg0) throws Exception {
        return false;
    }
}

