/*
 * Decompiled with CFR 0.152.
 */
package com.iptech.pivot.model;

import com.iptech.pivot.Contact;
import com.iptech.pivot.ContactAccessListener;
import com.iptech.pivot.model.ContactModel;
import com.iptech.pivot.serializer.SerializerFactory;
import java.net.URL;
import org.apache.pivot.collections.List;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.web.GetQuery;
import org.apache.pivot.web.PostQuery;

public class RemoteContactModel
implements ContactModel {
    private static final int PORT = 8080;
    private static final String HOST = "localhost";
    private static final String APP_NAME = "Contacts";
    private ContactAccessListener controller;

    public RemoteContactModel(ContactAccessListener controller) {
        this.controller = controller;
    }

    @Override
    public void retrieveAllContacts() {
        GetQuery getQuery = new GetQuery(HOST, 8080, "/Contacts/Contact", false);
        getQuery.setSerializer(SerializerFactory.getContactSerializer());
        getQuery.execute((TaskListener)new TaskListener<Object>(){

            public void taskExecuted(Task<Object> task) {
                RemoteContactModel.this.controller.contactsRetrieved((List<Contact>)((List)task.getResult()));
            }

            public void executeFailed(Task<Object> task) {
            }
        });
    }

    @Override
    public void saveContact(Contact contact) {
        PostQuery post = new PostQuery(HOST, 8080, "/Contacts/Contact", false);
        post.setSerializer(SerializerFactory.getContactSerializer());
        post.setValue((Object)contact);
        post.execute((TaskListener)new TaskListener<URL>(){

            public void executeFailed(Task<URL> arg0) {
            }

            public void taskExecuted(Task<URL> arg0) {
                RemoteContactModel.this.controller.contactSaved();
            }
        });
    }
}

