/*
 * Decompiled with CFR 0.152.
 */
package com.iptech.pivot.ui;

import com.iptech.pivot.Contact;
import com.iptech.pivot.ContactUpdateListener;
import java.io.IOException;
import org.apache.pivot.collections.List;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtkx.WTKXSerializer;

public class TableContactsWindow {
    private Window window = null;
    private TableView table;
    private ContactUpdateListener controller;

    public TableContactsWindow(ContactUpdateListener c) {
        this.controller = c;
        WTKXSerializer wtkxSerializer = new WTKXSerializer();
        try {
            this.window = (Window)wtkxSerializer.readObject((Object)this, "table.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        this.table = (TableView)wtkxSerializer.get("tableView");
        this.table.getComponentMouseButtonListeners().add((Object)new ComponentMouseButtonListener.Adapter(){

            public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
                List contacts = TableContactsWindow.this.table.getTableData();
                int index = TableContactsWindow.this.table.getRowAt(y);
                TableContactsWindow.this.controller.editContactRequest((Contact)contacts.get(index), TableContactsWindow.this);
                return false;
            }
        });
        PushButton addButton = (PushButton)wtkxSerializer.get("addButton");
        addButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                TableContactsWindow.this.controller.addContactRequest(TableContactsWindow.this);
            }
        });
    }

    public void setContacts(List<Contact> result) {
        this.table.setTableData(result);
    }

    public Window getWindow() {
        return this.window;
    }

    public void setWindow(Window window) {
        this.window = window;
    }

    public TableView getTable() {
        return this.table;
    }

    public void setTable(TableView table) {
        this.table = table;
    }
}

