/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.tools.wtk;

import java.awt.Color;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.tools.wtk.ComponentInspector;
import org.apache.pivot.tools.wtk.ComponentInspectorListener;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonStateListener;
import org.apache.pivot.wtk.CalendarButton;
import org.apache.pivot.wtk.CalendarButtonSelectionListener;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.ColorChooserButton;
import org.apache.pivot.wtk.ColorChooserButtonSelectionListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.CornerRadii;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.FlowPane;
import org.apache.pivot.wtk.Form;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Limits;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Prompt;
import org.apache.pivot.wtk.ScrollBar;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.text.validation.DoubleValidator;
import org.apache.pivot.wtk.text.validation.FloatValidator;
import org.apache.pivot.wtk.text.validation.IntValidator;
import org.apache.pivot.wtk.text.validation.Validator;

abstract class ComponentInspectorSkin
extends ContainerSkin
implements ComponentInspectorListener {
    protected Form form = new Form();
    private HashMap<String, Component> controls = new HashMap();

    public ComponentInspectorSkin() {
        this.form.getStyles().put("rightAlignLabels", (Object)true);
    }

    public void install(Component component) {
        super.install(component);
        ComponentInspector componentInspector = (ComponentInspector)component;
        componentInspector.getComponentInspectorListeners().add((Object)this);
        componentInspector.add((Component)this.form);
        this.sourceChanged(componentInspector, null);
    }

    public int getPreferredWidth(int n) {
        return this.form.getPreferredWidth(n);
    }

    public int getPreferredHeight(int n) {
        return this.form.getPreferredHeight(n);
    }

    public Dimensions getPreferredSize() {
        return this.form.getPreferredSize();
    }

    public void layout() {
        this.form.setLocation(0, 0);
        this.form.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void sourceChanged(ComponentInspector componentInspector, Component component) {
    }

    protected void addControl(Dictionary<String, Object> dictionary, String string, Class<?> clazz, Form.Section section) {
        if (section.getForm() != this.form) {
            throw new IllegalArgumentException("section does not belong to form.");
        }
        Component component = null;
        if (clazz == Boolean.TYPE) {
            component = this.addBooleanControl(dictionary, string, section);
        } else if (clazz == Integer.TYPE) {
            component = this.addIntControl(dictionary, string, section);
        } else if (clazz == Float.TYPE) {
            component = this.addFloatControl(dictionary, string, section);
        } else if (clazz == Double.TYPE) {
            component = this.addDoubleControl(dictionary, string, section);
        } else if (clazz == String.class) {
            component = this.addStringControl(dictionary, string, section);
        } else if (clazz.isEnum()) {
            component = this.addEnumControl(dictionary, string, clazz, section);
        } else if (clazz == Point.class) {
            component = this.addPointControl(dictionary, string, section);
        } else if (clazz == Dimensions.class) {
            component = this.addDimensionsControl(dictionary, string, section);
        } else if (clazz == Limits.class) {
            component = this.addLimitsControl(dictionary, string, section);
        } else if (clazz == Insets.class) {
            component = this.addInsetsControl(dictionary, string, section);
        } else if (clazz == Span.class) {
            component = this.addSpanControl(dictionary, string, section);
        } else if (clazz == CornerRadii.class) {
            component = this.addCornerRadiiControl(dictionary, string, section);
        } else if (clazz == ScrollBar.Scope.class) {
            component = this.addScopeControl(dictionary, string, section);
        } else if (clazz == Color.class) {
            component = this.addColorControl(dictionary, string, section);
        } else if (clazz == CalendarDate.class) {
            component = this.addCalendarDateControl(dictionary, string, section);
        }
        if (component != null) {
            this.controls.put((Object)string, (Object)component);
        }
    }

    protected void clearControls() {
        for (Form.Section section : this.form.getSections()) {
            section.remove(0, section.getLength());
        }
        this.controls.clear();
    }

    protected void updateControl(Dictionary<String, Object> dictionary, String string, Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            this.updateBooleanControl(dictionary, string);
        } else if (clazz == Integer.TYPE) {
            this.updateIntControl(dictionary, string);
        } else if (clazz == Float.TYPE) {
            this.updateFloatControl(dictionary, string);
        } else if (clazz == Double.TYPE) {
            this.updateDoubleControl(dictionary, string);
        } else if (clazz == String.class) {
            this.updateStringControl(dictionary, string);
        } else if (clazz.isEnum()) {
            this.updateEnumControl(dictionary, string);
        } else if (clazz == Point.class) {
            this.updatePointControl(dictionary, string);
        } else if (clazz == Dimensions.class) {
            this.updateDimensionsControl(dictionary, string);
        } else if (clazz == Limits.class) {
            this.updateLimitsControl(dictionary, string);
        } else if (clazz == Span.class) {
            this.updateSpanControl(dictionary, string);
        } else if (clazz == ScrollBar.Scope.class) {
            this.updateScopeControl(dictionary, string);
        } else if (clazz == Color.class) {
            this.updateColorControl(dictionary, string);
        } else if (clazz == CalendarDate.class) {
            this.updateCalendarDateControl(dictionary, string);
        }
    }

    private Component addBooleanControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        boolean bl = (Boolean)dictionary.get((Object)string);
        Checkbox checkbox = new Checkbox();
        checkbox.setSelected(bl);
        section.add((Component)checkbox);
        Form.setLabel((Component)checkbox, (String)string);
        checkbox.getButtonStateListeners().add((Object)new ButtonStateListener(){
            private boolean updating = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(Button button, Button.State state) {
                if (!this.updating) {
                    this.updating = true;
                    try {
                        dictionary.put((Object)string, (Object)button.isSelected());
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, button.getWindow());
                        button.setState(state);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        });
        return checkbox;
    }

    private void updateBooleanControl(Dictionary<String, Object> dictionary, String string) {
        Checkbox checkbox = (Checkbox)this.controls.get((Object)string);
        if (checkbox != null) {
            boolean bl = (Boolean)dictionary.get((Object)string);
            checkbox.setSelected(bl);
        }
    }

    private Component addIntControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        int n = (Integer)dictionary.get((Object)string);
        TextInput textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setMaximumLength(10);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(n));
        section.add((Component)textInput);
        Form.setLabel((Component)textInput, (String)string);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    try {
                        dictionary.put((Object)string, (Object)Integer.parseInt(textInput.getText()));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        int n = (Integer)dictionary.get((Object)string);
                        textInput.setText(String.valueOf(n));
                    }
                }
            }
        });
        return textInput;
    }

    private void updateIntControl(Dictionary<String, Object> dictionary, String string) {
        TextInput textInput = (TextInput)this.controls.get((Object)string);
        if (textInput != null) {
            int n = (Integer)dictionary.get((Object)string);
            textInput.setText(String.valueOf(n));
        }
    }

    private Component addFloatControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        float f = ((Float)dictionary.get((Object)string)).floatValue();
        TextInput textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setValidator((Validator)new FloatValidator());
        textInput.setText(String.valueOf(f));
        section.add((Component)textInput);
        Form.setLabel((Component)textInput, (String)string);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    try {
                        dictionary.put((Object)string, (Object)Float.valueOf(Float.parseFloat(textInput.getText())));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        float f = ((Float)dictionary.get((Object)string)).floatValue();
                        textInput.setText(String.valueOf(f));
                    }
                }
            }
        });
        return textInput;
    }

    private void updateFloatControl(Dictionary<String, Object> dictionary, String string) {
        TextInput textInput = (TextInput)this.controls.get((Object)string);
        if (textInput != null) {
            float f = ((Float)dictionary.get((Object)string)).floatValue();
            textInput.setText(String.valueOf(f));
        }
    }

    private Component addDoubleControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        double d = (Double)dictionary.get((Object)string);
        TextInput textInput = new TextInput();
        textInput.setTextSize(14);
        textInput.setValidator((Validator)new DoubleValidator());
        textInput.setText(String.valueOf(d));
        section.add((Component)textInput);
        Form.setLabel((Component)textInput, (String)string);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    try {
                        dictionary.put((Object)string, (Object)Double.parseDouble(textInput.getText()));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        double d = (Double)dictionary.get((Object)string);
                        textInput.setText(String.valueOf(d));
                    }
                }
            }
        });
        return textInput;
    }

    private void updateDoubleControl(Dictionary<String, Object> dictionary, String string) {
        TextInput textInput = (TextInput)this.controls.get((Object)string);
        if (textInput != null) {
            double d = (Double)dictionary.get((Object)string);
            textInput.setText(String.valueOf(d));
        }
    }

    private Component addStringControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        String string2 = (String)dictionary.get((Object)string);
        TextInput textInput = new TextInput();
        textInput.setText(string2 == null ? "" : string2);
        section.add((Component)textInput);
        Form.setLabel((Component)textInput, (String)string);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    try {
                        dictionary.put((Object)string, (Object)textInput.getText());
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        String string2 = (String)dictionary.get((Object)string);
                        textInput.setText(string2 == null ? "" : string2);
                    }
                }
            }
        });
        return textInput;
    }

    private void updateStringControl(Dictionary<String, Object> dictionary, String string) {
        TextInput textInput = (TextInput)this.controls.get((Object)string);
        if (textInput != null) {
            String string2 = (String)dictionary.get((Object)string);
            textInput.setText(string2 == null ? "" : string2);
        }
    }

    private Component addEnumControl(final Dictionary<String, Object> dictionary, final String string, Class<? extends Enum<?>> clazz, Form.Section section) {
        Enum enum_ = (Enum)dictionary.get((Object)string);
        ArrayList arrayList = new ArrayList();
        arrayList.add(null);
        Enum<?>[] enumArray = clazz.getEnumConstants();
        for (int i = 0; i < enumArray.length; ++i) {
            arrayList.add(enumArray[i]);
        }
        ListButton listButton = new ListButton();
        listButton.setListData((List)arrayList);
        listButton.setSelectedItem((Object)enum_);
        section.add((Component)listButton);
        Form.setLabel((Component)listButton, (String)string);
        listButton.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){
            private boolean updating = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void selectedIndexChanged(ListButton listButton, int n) {
                if (!this.updating) {
                    this.updating = true;
                    try {
                        dictionary.put((Object)string, listButton.getSelectedItem());
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, listButton.getWindow());
                        listButton.setSelectedIndex(n);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        });
        return listButton;
    }

    private void updateEnumControl(Dictionary<String, Object> dictionary, String string) {
        ListButton listButton = (ListButton)this.controls.get((Object)string);
        if (listButton != null) {
            Enum enum_ = (Enum)dictionary.get((Object)string);
            listButton.setSelectedItem((Object)enum_);
        }
    }

    private Component addPointControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        Point point = (Point)dictionary.get((Object)string);
        BoxPane boxPane = new BoxPane(Orientation.VERTICAL);
        section.add((Component)boxPane);
        Form.setLabel((Component)boxPane, (String)string);
        FlowPane flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        TextInput textInput = new TextInput();
        textInput.setTextSize(3);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(point.x));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Point point = (Point)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Point(n, point.y));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(point.x));
                    }
                }
            }
        });
        Label label = new Label("x");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(3);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(point.y));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Point point = (Point)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Point(point.x, n));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(point.y));
                    }
                }
            }
        });
        label = new Label("y");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        return boxPane;
    }

    private void updatePointControl(Dictionary<String, Object> dictionary, String string) {
        BoxPane boxPane = (BoxPane)this.controls.get((Object)string);
        if (boxPane != null) {
            Point point = (Point)dictionary.get((Object)string);
            TextInput textInput = (TextInput)((FlowPane)boxPane.get(0)).get(0);
            TextInput textInput2 = (TextInput)((FlowPane)boxPane.get(1)).get(0);
            textInput.setText(String.valueOf(point.x));
            textInput2.setText(String.valueOf(point.y));
        }
    }

    private Component addDimensionsControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        Dimensions dimensions = (Dimensions)dictionary.get((Object)string);
        BoxPane boxPane = new BoxPane(Orientation.VERTICAL);
        section.add((Component)boxPane);
        Form.setLabel((Component)boxPane, (String)string);
        FlowPane flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        TextInput textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(5);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(dimensions.width));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Dimensions dimensions = (Dimensions)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Dimensions(n, dimensions.height));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(dimensions.width));
                    }
                }
            }
        });
        Label label = new Label("width");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(5);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(dimensions.height));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Dimensions dimensions = (Dimensions)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Dimensions(dimensions.width, n));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(dimensions.height));
                    }
                }
            }
        });
        label = new Label("height");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        return boxPane;
    }

    private void updateDimensionsControl(Dictionary<String, Object> dictionary, String string) {
        BoxPane boxPane = (BoxPane)this.controls.get((Object)string);
        if (boxPane != null) {
            Dimensions dimensions = (Dimensions)dictionary.get((Object)string);
            TextInput textInput = (TextInput)((FlowPane)boxPane.get(0)).get(0);
            TextInput textInput2 = (TextInput)((FlowPane)boxPane.get(1)).get(0);
            textInput.setText(String.valueOf(dimensions.width));
            textInput2.setText(String.valueOf(dimensions.height));
        }
    }

    private Component addLimitsControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        Limits limits = (Limits)dictionary.get((Object)string);
        BoxPane boxPane = new BoxPane(Orientation.VERTICAL);
        section.add((Component)boxPane);
        Form.setLabel((Component)boxPane, (String)string);
        FlowPane flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        TextInput textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setMaximumLength(10);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(limits.min));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Limits limits = (Limits)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Limits(n, limits.max));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(limits.min));
                    }
                }
            }
        });
        Label label = new Label("min");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setMaximumLength(10);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(limits.max));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Limits limits = (Limits)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Limits(limits.min, n));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(limits.max));
                    }
                }
            }
        });
        label = new Label("max");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        return boxPane;
    }

    private void updateLimitsControl(Dictionary<String, Object> dictionary, String string) {
        BoxPane boxPane = (BoxPane)this.controls.get((Object)string);
        if (boxPane != null) {
            Limits limits = (Limits)dictionary.get((Object)string);
            TextInput textInput = (TextInput)((FlowPane)boxPane.get(0)).get(0);
            TextInput textInput2 = (TextInput)((FlowPane)boxPane.get(1)).get(0);
            textInput.setText(String.valueOf(limits.min));
            textInput2.setText(String.valueOf(limits.max));
        }
    }

    private Component addInsetsControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        Insets insets = (Insets)dictionary.get((Object)string);
        BoxPane boxPane = new BoxPane(Orientation.VERTICAL);
        section.add((Component)boxPane);
        Form.setLabel((Component)boxPane, (String)string);
        FlowPane flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        TextInput textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(insets.top));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Insets insets = (Insets)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Insets(n, insets.left, insets.bottom, insets.right));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(insets.top));
                    }
                }
            }
        });
        Label label = new Label("top");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(insets.left));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Insets insets = (Insets)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Insets(insets.top, n, insets.bottom, insets.right));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(insets.left));
                    }
                }
            }
        });
        label = new Label("left");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(insets.bottom));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Insets insets = (Insets)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Insets(insets.top, insets.left, n, insets.right));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(insets.bottom));
                    }
                }
            }
        });
        label = new Label("bottom");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(insets.right));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Insets insets = (Insets)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Insets(insets.top, insets.left, insets.bottom, n));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(insets.right));
                    }
                }
            }
        });
        label = new Label("right");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        return boxPane;
    }

    private Component addSpanControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        Span span = (Span)dictionary.get((Object)string);
        BoxPane boxPane = new BoxPane(Orientation.VERTICAL);
        section.add((Component)boxPane);
        Form.setLabel((Component)boxPane, (String)string);
        FlowPane flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        TextInput textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setMaximumLength(10);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(span == null ? "" : String.valueOf(span.start));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Span span = (Span)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Span(n, span == null ? n : span.end));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(span == null ? "" : String.valueOf(span.start));
                    }
                }
            }
        });
        Label label = new Label("start");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setMaximumLength(10);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(span == null ? "" : String.valueOf(span.end));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    Span span = (Span)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new Span(span == null ? n : span.start, n));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(span == null ? "" : String.valueOf(span.end));
                    }
                }
            }
        });
        label = new Label("end");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        return boxPane;
    }

    private void updateSpanControl(Dictionary<String, Object> dictionary, String string) {
        BoxPane boxPane = (BoxPane)this.controls.get((Object)string);
        if (boxPane != null) {
            Span span = (Span)dictionary.get((Object)string);
            TextInput textInput = (TextInput)((FlowPane)boxPane.get(0)).get(0);
            TextInput textInput2 = (TextInput)((FlowPane)boxPane.get(1)).get(0);
            textInput.setText(span == null ? "" : String.valueOf(span.start));
            textInput2.setText(span == null ? "" : String.valueOf(span.end));
        }
    }

    private Component addCornerRadiiControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        CornerRadii cornerRadii = (CornerRadii)dictionary.get((Object)string);
        BoxPane boxPane = new BoxPane(Orientation.VERTICAL);
        section.add((Component)boxPane);
        Form.setLabel((Component)boxPane, (String)string);
        FlowPane flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        TextInput textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(cornerRadii.topLeft));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    CornerRadii cornerRadii = (CornerRadii)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new CornerRadii(n, cornerRadii.topRight, cornerRadii.bottomLeft, cornerRadii.bottomRight));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(cornerRadii.topLeft));
                    }
                }
            }
        });
        Label label = new Label("topLeft");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(cornerRadii.topRight));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    CornerRadii cornerRadii = (CornerRadii)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new CornerRadii(cornerRadii.topLeft, n, cornerRadii.bottomLeft, cornerRadii.bottomRight));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(cornerRadii.topRight));
                    }
                }
            }
        });
        label = new Label("topRight");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(cornerRadii.bottomLeft));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    CornerRadii cornerRadii = (CornerRadii)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new CornerRadii(cornerRadii.topLeft, cornerRadii.topRight, n, cornerRadii.bottomRight));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(cornerRadii.bottomLeft));
                    }
                }
            }
        });
        label = new Label("bottomLeft");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(4);
        textInput.setMaximumLength(4);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(String.valueOf(cornerRadii.bottomRight));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    CornerRadii cornerRadii = (CornerRadii)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new CornerRadii(cornerRadii.topLeft, cornerRadii.topRight, cornerRadii.bottomLeft, n));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(String.valueOf(cornerRadii.bottomRight));
                    }
                }
            }
        });
        label = new Label("bottomRight");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        return boxPane;
    }

    private Component addScopeControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        ScrollBar.Scope scope = (ScrollBar.Scope)dictionary.get((Object)string);
        BoxPane boxPane = new BoxPane(Orientation.VERTICAL);
        section.add((Component)boxPane);
        Form.setLabel((Component)boxPane, (String)string);
        FlowPane flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        TextInput textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setMaximumLength(10);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(scope == null ? "" : String.valueOf(scope.start));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    ScrollBar.Scope scope = (ScrollBar.Scope)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new ScrollBar.Scope(n, scope == null ? n : scope.end, scope == null ? n : scope.extent));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(scope == null ? "" : String.valueOf(scope.start));
                    }
                }
            }
        });
        Label label = new Label("start");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setMaximumLength(10);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(scope == null ? "" : String.valueOf(scope.end));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    ScrollBar.Scope scope = (ScrollBar.Scope)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new ScrollBar.Scope(scope == null ? n : scope.start, n, scope == null ? n : scope.extent));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(scope == null ? "" : String.valueOf(scope.end));
                    }
                }
            }
        });
        label = new Label("end");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        flowPane = new FlowPane();
        flowPane.getStyles().put("alignToBaseline", (Object)true);
        flowPane.getStyles().put("horizontalSpacing", (Object)5);
        boxPane.add((Component)flowPane);
        textInput = new TextInput();
        textInput.setTextSize(10);
        textInput.setMaximumLength(10);
        textInput.setValidator((Validator)new IntValidator());
        textInput.setText(scope == null ? "" : String.valueOf(scope.extent));
        flowPane.add((Component)textInput);
        textInput.getComponentStateListeners().add((Object)new ComponentStateListener.Adapter(){

            public void focusedChanged(Component component, Component component2) {
                if (!component.isFocused()) {
                    TextInput textInput = (TextInput)component;
                    ScrollBar.Scope scope = (ScrollBar.Scope)dictionary.get((Object)string);
                    try {
                        int n = Integer.parseInt(textInput.getText());
                        dictionary.put((Object)string, (Object)new ScrollBar.Scope(scope == null ? n : scope.start, scope == null ? n : scope.end, n));
                    }
                    catch (Exception exception) {
                        ComponentInspectorSkin.this.displayErrorMessage(exception, component.getWindow());
                        textInput.setText(scope == null ? "" : String.valueOf(scope.extent));
                    }
                }
            }
        });
        label = new Label("extent");
        label.getStyles().put("font", (Object)"{italic:true}");
        flowPane.add((Component)label);
        return boxPane;
    }

    private void updateScopeControl(Dictionary<String, Object> dictionary, String string) {
        BoxPane boxPane = (BoxPane)this.controls.get((Object)string);
        if (boxPane != null) {
            ScrollBar.Scope scope = (ScrollBar.Scope)dictionary.get((Object)string);
            TextInput textInput = (TextInput)((FlowPane)boxPane.get(0)).get(0);
            TextInput textInput2 = (TextInput)((FlowPane)boxPane.get(1)).get(0);
            TextInput textInput3 = (TextInput)((FlowPane)boxPane.get(2)).get(0);
            textInput.setText(scope == null ? "" : String.valueOf(scope.start));
            textInput2.setText(scope == null ? "" : String.valueOf(scope.end));
            textInput3.setText(scope == null ? "" : String.valueOf(scope.extent));
        }
    }

    private Component addColorControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        Color color = (Color)dictionary.get((Object)string);
        ColorChooserButton colorChooserButton = new ColorChooserButton();
        colorChooserButton.setSelectedColor(color);
        section.add((Component)colorChooserButton);
        Form.setLabel((Component)colorChooserButton, (String)string);
        colorChooserButton.getColorChooserButtonSelectionListeners().add((Object)new ColorChooserButtonSelectionListener(){

            public void selectedColorChanged(ColorChooserButton colorChooserButton, Color color) {
                try {
                    dictionary.put((Object)string, (Object)colorChooserButton.getSelectedColor());
                }
                catch (Exception exception) {
                    ComponentInspectorSkin.this.displayErrorMessage(exception, colorChooserButton.getWindow());
                    dictionary.put((Object)string, (Object)color);
                }
            }
        });
        return colorChooserButton;
    }

    private void updateColorControl(Dictionary<String, Object> dictionary, String string) {
        ColorChooserButton colorChooserButton = (ColorChooserButton)this.controls.get((Object)string);
        if (colorChooserButton != null) {
            Color color = (Color)dictionary.get((Object)string);
            colorChooserButton.setSelectedColor(color);
        }
    }

    private Component addCalendarDateControl(final Dictionary<String, Object> dictionary, final String string, Form.Section section) {
        CalendarDate calendarDate = (CalendarDate)dictionary.get((Object)string);
        CalendarButton calendarButton = new CalendarButton();
        calendarButton.setMinimumPreferredWidth(75);
        calendarButton.setSelectedDate(calendarDate);
        section.add((Component)calendarButton);
        Form.setLabel((Component)calendarButton, (String)string);
        calendarButton.getCalendarButtonSelectionListeners().add((Object)new CalendarButtonSelectionListener(){

            public void selectedDateChanged(CalendarButton calendarButton, CalendarDate calendarDate) {
                try {
                    dictionary.put((Object)string, (Object)calendarButton.getSelectedDate());
                }
                catch (Exception exception) {
                    ComponentInspectorSkin.this.displayErrorMessage(exception, calendarButton.getWindow());
                    dictionary.put((Object)string, (Object)calendarDate);
                }
            }
        });
        return calendarButton;
    }

    private void updateCalendarDateControl(Dictionary<String, Object> dictionary, String string) {
        CalendarButton calendarButton = (CalendarButton)this.controls.get((Object)string);
        if (calendarButton != null) {
            CalendarDate calendarDate = (CalendarDate)dictionary.get((Object)string);
            calendarButton.setSelectedDate(calendarDate);
        }
    }

    private void displayErrorMessage(Exception exception, Window window) {
        String string = exception.getLocalizedMessage();
        if (string == null) {
            string = exception.getClass().getSimpleName();
        }
        Prompt.prompt((MessageType)MessageType.ERROR, (String)string, (Window)window);
    }
}

