/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.tools.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.io.FileList;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.CardPane;
import org.apache.pivot.wtk.Clipboard;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.DropAction;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Prompt;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.OverlayDecorator;
import org.apache.pivot.wtkx.WTKX;
import org.apache.pivot.wtkx.WTKXSerializer;
import org.apache.pivot.xml.Element;
import org.apache.pivot.xml.Node;
import org.apache.pivot.xml.TextNode;
import org.apache.pivot.xml.XMLSerializer;

public class XMLViewer
implements Application {
    private Window window = null;
    @WTKX
    private TreeView treeView = null;
    @WTKX
    private CardPane propertiesCardPane = null;
    @WTKX
    private TableView namespacesTableView = null;
    @WTKX
    private TableView attributesTableView = null;
    @WTKX
    private TextArea textArea = null;
    private OverlayDecorator promptDecorator = new OverlayDecorator();
    public static final String APPLICATION_KEY = "application";
    public static final String WINDOW_TITLE = "XML Viewer";

    public void startup(Display display, Map<String, String> map) throws Exception {
        WTKXSerializer wTKXSerializer = new WTKXSerializer();
        wTKXSerializer.put(APPLICATION_KEY, (Object)this);
        this.window = (Window)wTKXSerializer.readObject((Object)this, "xml_viewer.wtkx");
        wTKXSerializer.bind((Object)this);
        Label label = new Label("Drag or paste XML here");
        label.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
        label.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.promptDecorator.setOverlay((Component)label);
        this.treeView.getDecorators().add((Decorator)this.promptDecorator);
        this.window.setTitle(WINDOW_TITLE);
        this.window.open(display);
        this.window.requestFocus();
    }

    public boolean shutdown(boolean bl) {
        if (this.window != null) {
            this.window.close();
        }
        return false;
    }

    public void suspend() {
    }

    public void resume() {
    }

    public void paste() {
        Manifest manifest = Clipboard.getContent();
        if (manifest != null && manifest.containsText()) {
            String string = null;
            XMLSerializer xMLSerializer = new XMLSerializer();
            try {
                string = manifest.getText();
                this.setDocument(xMLSerializer.readObject((Reader)new StringReader(string)));
            }
            catch (Exception exception) {
                Prompt.prompt((String)exception.getMessage(), (Window)this.window);
            }
            this.window.setTitle(WINDOW_TITLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropAction drop(Manifest manifest) {
        DropAction dropAction;
        block10: {
            dropAction = null;
            try {
                FileList fileList = manifest.getFileList();
                if (fileList.getLength() == 1) {
                    File file = (File)fileList.get(0);
                    XMLSerializer xMLSerializer = new XMLSerializer();
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(file);
                            this.setDocument(xMLSerializer.readObject((InputStream)fileInputStream));
                        }
                        finally {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                    }
                    catch (Exception exception) {
                        Prompt.prompt((String)exception.getMessage(), (Window)this.window);
                    }
                    this.window.setTitle("XML Viewer - " + file.getName());
                    dropAction = DropAction.COPY;
                    break block10;
                }
                Prompt.prompt((String)"Multiple files not supported.", (Window)this.window);
            }
            catch (IOException iOException) {
                Prompt.prompt((String)iOException.getMessage(), (Window)this.window);
            }
        }
        return dropAction;
    }

    public void updateProperties() {
        Node node = (Node)this.treeView.getSelectedNode();
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            this.textArea.setText(textNode.getText());
            this.propertiesCardPane.setSelectedIndex(1);
        } else if (node instanceof Element) {
            Element.NamespaceDictionary namespaceDictionary;
            Element element = (Element)node;
            ArrayList arrayList = new ArrayList();
            String string = element.getDefaultNamespaceURI();
            if (string != null) {
                namespaceDictionary = new HashMap();
                namespaceDictionary.put((Object)"prefix", (Object)"(default)");
                namespaceDictionary.put((Object)"uri", (Object)string);
                arrayList.add((Object)namespaceDictionary);
            }
            namespaceDictionary = element.getNamespaces();
            for (Object object : namespaceDictionary) {
                HashMap hashMap = new HashMap();
                hashMap.put((Object)"prefix", object);
                hashMap.put((Object)"uri", (Object)namespaceDictionary.get((String)object));
                arrayList.add((Object)hashMap);
            }
            this.namespacesTableView.setTableData((List)arrayList);
            Iterator iterator = new ArrayList();
            for (HashMap hashMap : element.getAttributes()) {
                HashMap hashMap2 = new HashMap();
                String string2 = hashMap.getName();
                hashMap2.put((Object)"name", (Object)string2);
                hashMap2.put((Object)"value", (Object)element.get(string2));
                iterator.add(hashMap2);
            }
            this.attributesTableView.setTableData((List)iterator);
            this.propertiesCardPane.setSelectedIndex(0);
        } else {
            throw new IllegalStateException();
        }
    }

    private void setDocument(Element element) {
        if (this.promptDecorator != null) {
            this.treeView.getDecorators().remove((Decorator)this.promptDecorator);
            this.promptDecorator = null;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)element);
        this.treeView.setTreeData((List)arrayList);
        Sequence.Tree.Path path = new Sequence.Tree.Path(new Integer[]{0});
        this.treeView.expandBranch(path);
        this.treeView.setSelectedPath(path);
    }

    public static void main(String[] stringArray) {
        DesktopApplicationContext.main(XMLViewer.class, (String[])stringArray);
    }
}

