/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class ArrayList<T>
implements List<T>,
Serializable {
    private static final long serialVersionUID = 2123086211369612675L;
    private Object[] items;
    private int length = 0;
    private Comparator<T> comparator = null;
    private transient int modificationCount = 0;
    private transient List.ListListenerList<T> listListeners = null;
    public static final int DEFAULT_CAPACITY = 10;

    public ArrayList() {
        this.items = new Object[10];
    }

    public ArrayList(Comparator<T> comparator) {
        this();
        this.comparator = comparator;
    }

    public ArrayList(int n) {
        ArrayList.verifyNonNegative("capacity", n);
        this.items = new Object[n];
    }

    public ArrayList(T ... TArray) {
        this(TArray, 0, TArray.length);
    }

    public ArrayList(T[] TArray, int n, int n2) {
        ArrayList.verifyNotNull("items", TArray);
        ArrayList.verifyIndexBounds(n, n2, 0, TArray.length);
        this.items = new Object[n2];
        System.arraycopy(TArray, n, this.items, 0, n2);
        this.length = n2;
    }

    public ArrayList(Sequence<T> sequence) {
        this(sequence, 0, sequence.getLength());
    }

    public ArrayList(Sequence<T> sequence, int n, int n2) {
        ArrayList.verifyNotNull("items", sequence);
        ArrayList.verifyIndexBounds(n, n2, 0, sequence.getLength());
        this.items = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            this.items[i] = sequence.get(n + i);
        }
        this.length = n2;
    }

    public ArrayList(ArrayList<T> arrayList) {
        this(arrayList, 0, arrayList.length);
    }

    public ArrayList(ArrayList<T> arrayList, int n, int n2) {
        ArrayList.verifyNotNull("arrayList", arrayList);
        ArrayList.verifyIndexBounds(n, n2, 0, arrayList.length);
        this.items = new Object[n2];
        this.length = n2;
        System.arraycopy(arrayList.items, n, this.items, 0, n2);
        this.comparator = arrayList.comparator;
    }

    @Override
    public int add(T t) {
        int n = -1;
        if (this.comparator == null) {
            n = this.length;
            this.insert(t, n);
        } else {
            n = ArrayList.binarySearch(this, t, this.comparator);
            if (n < 0) {
                n = -(n + 1);
            }
            this.insert(t, n, false);
        }
        return n;
    }

    @Override
    public void insert(T t, int n) {
        this.insert(t, n, true);
    }

    private void insert(T t, int n, boolean bl) {
        ArrayList.verifyIndexBounds(n, 0, this.length);
        if (this.comparator != null && bl) {
            int n2 = ArrayList.binarySearch(this, t, this.comparator);
            if (n2 < 0) {
                n2 = -(n2 + 1);
            }
            if (n != n2) {
                throw new IllegalArgumentException("Illegal insertion point.");
            }
        }
        this.ensureCapacity(this.length + 1);
        System.arraycopy(this.items, n, this.items, n + 1, this.length - n);
        this.items[n] = t;
        ++this.length;
        ++this.modificationCount;
        if (this.listListeners != null) {
            this.listListeners.itemInserted(this, n);
        }
    }

    @Override
    public T update(int n, T t) {
        ArrayList.verifyIndexBounds(n, 0, this.length - 1);
        Object object = this.items[n];
        if (object != t) {
            if (this.comparator != null) {
                Object object2;
                Object object3 = n > 0 ? this.items[n - 1] : null;
                Object object4 = object2 = n < this.length - 1 ? this.items[n + 1] : null;
                if (object3 != null && this.comparator.compare(t, object3) == -1 || object2 != null && this.comparator.compare(t, object2) == 1) {
                    throw new IllegalArgumentException("Illegal item modification.");
                }
            }
            this.items[n] = t;
            ++this.modificationCount;
        }
        if (this.listListeners != null) {
            this.listListeners.itemUpdated(this, n, object);
        }
        return (T)object;
    }

    @Override
    public int remove(T t) {
        int n = this.indexOf(t);
        if (n >= 0) {
            this.remove(n, 1);
        }
        return n;
    }

    @Override
    public Sequence<T> remove(int n, int n2) {
        ArrayList.verifyIndexBounds(n, n2, 0, this.length);
        ArrayList<Object> arrayList = new ArrayList<Object>(this.items, n, n2);
        if (n2 > 0) {
            int n3 = n + n2;
            System.arraycopy(this.items, n + n2, this.items, n, this.length - n3);
            this.length -= n2;
            ++this.modificationCount;
            int n4 = this.length + n2;
            for (int i = this.length; i < n4; ++i) {
                this.items[i] = null;
            }
            if (this.listListeners != null) {
                this.listListeners.itemsRemoved(this, n, arrayList);
            }
        }
        return arrayList;
    }

    @Override
    public void clear() {
        if (this.length > 0) {
            this.items = new Object[this.items.length];
            this.length = 0;
            ++this.modificationCount;
            if (this.listListeners != null) {
                this.listListeners.listCleared(this);
            }
        }
    }

    @Override
    public T get(int n) {
        ArrayList.verifyIndexBounds(n, 0, this.length);
        return (T)this.items[n];
    }

    @Override
    public int indexOf(T t) {
        int n = -1;
        if (this.comparator == null) {
            for (n = 0; n < this.length && !(t == null ? this.items[n] == null : t.equals(this.items[n])); ++n) {
            }
            if (n == this.length) {
                n = -1;
            }
        } else {
            n = ArrayList.binarySearch(this, t, this.comparator);
            if (n < 0) {
                n = -1;
            }
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void trimToSize() {
        Object[] objectArray = new Object[this.length];
        System.arraycopy(this.items, 0, objectArray, 0, this.length);
        this.items = objectArray;
        this.length = objectArray.length;
    }

    public void ensureCapacity(int n) {
        if (n > this.items.length) {
            n = Math.max(this.items.length * 3 / 2, n);
            Object[] objectArray = new Object[n];
            System.arraycopy(this.items, 0, objectArray, 0, this.length);
            this.items = objectArray;
        }
    }

    public int getCapacity() {
        return this.items.length;
    }

    public T[] toArray(Class<? extends T[]> clazz) {
        return Arrays.copyOf(this.items, this.length, clazz);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.comparator;
        if (comparator != null) {
            ArrayList.sort(this, comparator);
        }
        this.comparator = comparator;
        if (this.listListeners != null) {
            this.listListeners.comparatorChanged(this, comparator2);
        }
    }

    @Override
    public List.ItemIterator<T> iterator() {
        return new ArrayListItemIterator();
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        if (this.listListeners == null) {
            this.listListeners = new List.ListListenerList();
        }
        return this.listListeners;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            if (arrayList.getLength() == this.length) {
                Iterator iterator = this.iterator();
                Iterator iterator2 = arrayList.iterator();
                for (bl = true; iterator.hasNext() && iterator2.hasNext() && bl; bl &= iterator.next().equals(iterator2.next())) {
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 1;
        for (Object e : this) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [");
        int n = 0;
        for (Object e : this) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(e);
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static <T> void sort(ArrayList<T> arrayList, Comparator<T> comparator) {
        ArrayList.sort(arrayList, 0, arrayList.getLength(), comparator);
    }

    public static <T> void sort(ArrayList<T> arrayList, int n, int n2, Comparator<T> comparator) {
        ArrayList.verifyNotNull("arrayList", arrayList);
        ArrayList.verifyNotNull("comparator", comparator);
        Arrays.sort(arrayList.items, n, n2, comparator);
        ++arrayList.modificationCount;
    }

    public static <T extends Comparable<? super T>> void sort(ArrayList<T> arrayList) {
        ArrayList.sort(arrayList, new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return t.compareTo(t2);
            }
        });
    }

    public static <T> int binarySearch(ArrayList<T> arrayList, T t, Comparator<T> comparator) {
        ArrayList.verifyNotNull("arrayList", arrayList);
        ArrayList.verifyNotNull("comparator", comparator);
        ArrayList.verifyNotNull("item", t);
        int n = Arrays.binarySearch(arrayList.items, 0, arrayList.length, t, comparator);
        return n;
    }

    public static <T extends Comparable<? super T>> int binarySearch(ArrayList<T> arrayList, T t) {
        return ArrayList.binarySearch(arrayList, t, new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return t.compareTo(t2);
            }
        });
    }

    private static void verifyNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(string + " cannot be null.");
        }
    }

    private static void verifyNonNegative(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException(string + " cannot be negative.");
        }
    }

    private static void verifyIndexBounds(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IndexOutOfBoundsException("index " + n + " out of bounds.");
        }
    }

    private static void verifyIndexBounds(int n, int n2, int n3, int n4) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n < n3) {
            throw new IndexOutOfBoundsException("index " + n + " out of bounds.");
        }
        if (n + n2 > n4) {
            throw new IndexOutOfBoundsException("index + count " + n + "," + n2 + " out of range.");
        }
    }

    private class ArrayListItemIterator
    implements List.ItemIterator<T> {
        private int index = 0;
        private int modificationCount;

        public ArrayListItemIterator() {
            this.modificationCount = ArrayList.this.modificationCount;
        }

        @Override
        public boolean hasNext() {
            if (this.modificationCount != ArrayList.this.modificationCount) {
                throw new ConcurrentModificationException();
            }
            return this.index < ArrayList.this.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ArrayList.this.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            if (this.modificationCount != ArrayList.this.modificationCount) {
                throw new ConcurrentModificationException();
            }
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return ArrayList.this.get(--this.index);
        }

        @Override
        public void toStart() {
            this.index = 0;
        }

        @Override
        public void toEnd() {
            this.index = ArrayList.this.length;
        }

        @Override
        public void insert(T t) {
            this.indexBoundsCheck();
            ArrayList.this.insert(t, this.index);
            ++this.modificationCount;
        }

        @Override
        public void update(T t) {
            this.indexBoundsCheck();
            ArrayList.this.update(this.index, t);
            ++this.modificationCount;
        }

        @Override
        public void remove() {
            this.indexBoundsCheck();
            ArrayList.this.remove(this.index, 1);
            ++this.modificationCount;
        }

        private void indexBoundsCheck() {
            if (this.index < 0 || this.index > ArrayList.this.length) {
                throw new IllegalStateException("index  " + this.index + " out of bounds");
            }
        }
    }
}

