/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Stack;
import org.apache.pivot.collections.StackListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class ArrayStack<T>
implements Stack<T>,
Serializable {
    private static final long serialVersionUID = 3175064065273930731L;
    private ArrayList<T> arrayList = new ArrayList();
    private transient Stack.StackListenerList<T> stackListeners = new Stack.StackListenerList();

    public ArrayStack() {
        this(null);
    }

    public ArrayStack(Comparator<T> comparator) {
        this.setComparator(comparator);
    }

    public ArrayStack(int n) {
        this.ensureCapacity(n);
    }

    @Override
    public void push(T t) {
        this.arrayList.add(t);
        this.stackListeners.itemPushed(this, t);
    }

    @Override
    public T pop() {
        int n = this.arrayList.getLength();
        if (n == 0) {
            throw new IllegalStateException("queue is empty");
        }
        T t = this.arrayList.remove(n - 1, 1).get(0);
        this.stackListeners.itemPopped(this, t);
        return t;
    }

    @Override
    public T peek() {
        T t = null;
        int n = this.arrayList.getLength();
        if (n > 0) {
            t = this.arrayList.get(n - 1);
        }
        return t;
    }

    @Override
    public void clear() {
        if (this.arrayList.getLength() > 0) {
            this.arrayList.clear();
            this.stackListeners.stackCleared(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.arrayList.getLength() == 0;
    }

    @Override
    public int getDepth() {
        return this.arrayList.getLength();
    }

    public void ensureCapacity(int n) {
        this.arrayList.ensureCapacity(n);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.arrayList.getComparator();
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.getComparator();
        this.arrayList.setComparator(comparator);
        this.stackListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.arrayList.iterator());
    }

    @Override
    public ListenerList<StackListener<T>> getStackListeners() {
        return this.stackListeners;
    }
}

