/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class EnumList<E extends Enum<E>>
implements List<E>,
Serializable {
    private static final long serialVersionUID = 5104856822133576300L;
    private Class<E> enumClass;
    private E[] items;
    private transient List.ListListenerList<E> listListeners = new List.ListListenerList();

    public EnumList(Class<E> clazz) {
        this.enumClass = clazz;
        this.items = (Enum[])clazz.getEnumConstants();
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public int add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(E e, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E update(int n, E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remove(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence<E> remove(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int n) {
        return this.items[n];
    }

    @Override
    public int indexOf(E e) {
        if (e == null) {
            throw new IllegalArgumentException("item cannot be null.");
        }
        return ((Enum)e).ordinal();
    }

    @Override
    public boolean isEmpty() {
        return this.items.length == 0;
    }

    @Override
    public int getLength() {
        return this.items.length;
    }

    public E[] toArray() {
        return (Enum[])Arrays.copyOf(this.items, this.items.length);
    }

    @Override
    public Comparator<E> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new ItemIterator();
    }

    @Override
    public ListenerList<ListListener<E>> getListListeners() {
        return this.listListeners;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" [");
        for (int i = 0; i < this.items.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.items[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        return object instanceof EnumList && ((EnumList)object).enumClass == this.enumClass;
    }

    public int hashCode() {
        return this.enumClass.hashCode();
    }

    private class ItemIterator
    implements Iterator<E> {
        private int i = 0;

        private ItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < EnumList.this.items.length;
        }

        @Override
        public E next() {
            if (this.i >= EnumList.this.items.length) {
                throw new NoSuchElementException();
            }
            return EnumList.this.items[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

