/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.EnumSet;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.ListenerList;

public class EnumMap<E extends Enum<E>, V>
implements Map<E, V>,
Serializable {
    private static final long serialVersionUID = -8446839779287452516L;
    private EnumSet<E> keySet;
    private Object[] values;
    private transient Map.MapListenerList<E, V> mapListeners = new Map.MapListenerList();

    public EnumMap(Class<E> clazz) {
        this.keySet = new EnumSet<E>(clazz);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        this.values = new Object[enumArray.length];
    }

    @Override
    public V get(E e) {
        EnumMap.verifyNotNull("key", e);
        return (V)this.values[((Enum)e).ordinal()];
    }

    @Override
    public V put(E e, V v) {
        EnumMap.verifyNotNull("key", e);
        int n = ((Enum)e).ordinal();
        Object object = this.values[n];
        this.values[n] = v;
        if (this.keySet.contains(e)) {
            this.mapListeners.valueUpdated(this, e, object);
        } else {
            this.keySet.add(e);
            this.mapListeners.valueAdded(this, e);
        }
        return (V)object;
    }

    @Override
    public V remove(E e) {
        EnumMap.verifyNotNull("key", e);
        Object object = null;
        if (this.keySet.contains(e)) {
            int n = ((Enum)e).ordinal();
            object = this.values[n];
            this.values[n] = null;
            this.keySet.remove(e);
            this.mapListeners.valueRemoved(this, e, object);
        }
        return (V)object;
    }

    @Override
    public void clear() {
        if (!this.keySet.isEmpty()) {
            this.values = new Object[this.values.length];
            this.keySet.clear();
            this.mapListeners.mapCleared(this);
        }
    }

    @Override
    public boolean containsKey(E e) {
        return this.keySet.contains(e);
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public int getCount() {
        return this.keySet.getCount();
    }

    @Override
    public Comparator<E> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return this.keySet.iterator();
    }

    @Override
    public ListenerList<MapListener<E, V>> getMapListeners() {
        return this.mapListeners;
    }

    private static void verifyNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(string + " cannot be null.");
        }
    }
}

