/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.EmptyIterator;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class HashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -7079717428744528670L;
    private ArrayList<LinkedList<Dictionary.Pair<K, V>>> buckets;
    private float loadFactor;
    private int count = 0;
    private ArrayList<K> keys = null;
    private transient Map.MapListenerList<K, V> mapListeners = null;
    public static final int DEFAULT_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public HashMap() {
        this(16, 0.75f);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(int n, float f) {
        this.loadFactor = f;
        this.rehash(n);
    }

    public HashMap(Dictionary.Pair<K, V> ... pairArray) {
        this(Math.max((int)((float)pairArray.length / 0.75f) + 1, 16));
        for (int i = 0; i < pairArray.length; ++i) {
            Dictionary.Pair<K, V> pair = pairArray[i];
            this.put(pair.key, pair.value);
        }
    }

    public HashMap(Map<K, V> map) {
        this(Math.max((int)((float)map.getCount() / 0.75f) + 1, 16));
        for (Object t : map) {
            this.put(t, map.get(t));
        }
    }

    public HashMap(Comparator<K> comparator) {
        this();
        this.setComparator(comparator);
    }

    @Override
    public V get(K k) {
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        V v = null;
        LinkedList<Dictionary.Pair<K, V>> linkedList = this.getBucket(k);
        for (Dictionary.Pair pair : linkedList) {
            if (!pair.key.equals(k)) continue;
            v = pair.value;
            break;
        }
        return v;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object v2 = null;
        LinkedList<Dictionary.Pair<K, V>> linkedList = this.getBucket(k);
        int n = 0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Dictionary.Pair pair = (Dictionary.Pair)iterator.next();
            if (pair.key.equals(k)) {
                v2 = pair.value;
                iterator.update(new Dictionary.Pair<K, V>(k, v));
                if (this.mapListeners == null) break;
                this.mapListeners.valueUpdated(this, k, v2);
                break;
            }
            ++n;
        }
        if (n == linkedList.getLength()) {
            linkedList.add(new Dictionary.Pair<K, V>(k, v));
            if (this.keys != null) {
                this.keys.add(k);
            }
            ++this.count;
            int n2 = this.getCapacity();
            if (this.count > (int)((float)n2 * this.loadFactor)) {
                this.rehash(n2 * 2);
            }
            if (this.mapListeners != null) {
                this.mapListeners.valueAdded(this, k);
            }
        }
        return v2;
    }

    @Override
    public V remove(K k) {
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object v = null;
        LinkedList<Dictionary.Pair<K, V>> linkedList = this.getBucket(k);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Dictionary.Pair pair = (Dictionary.Pair)iterator.next();
            if (!pair.key.equals(k)) continue;
            v = pair.value;
            iterator.remove();
            if (this.keys != null) {
                this.keys.remove(k);
            }
            --this.count;
            if (this.mapListeners == null) break;
            this.mapListeners.valueRemoved(this, k, v);
            break;
        }
        return v;
    }

    @Override
    public void clear() {
        if (this.count > 0) {
            for (LinkedList linkedList : this.buckets) {
                if (linkedList == null) continue;
                linkedList.clear();
            }
            if (this.keys != null) {
                this.keys.clear();
            }
            this.count = 0;
            if (this.mapListeners != null) {
                this.mapListeners.mapCleared(this);
            }
        }
    }

    @Override
    public boolean containsKey(K k) {
        if (k == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        LinkedList<Dictionary.Pair<K, V>> linkedList = this.getBucket(k);
        int n = 0;
        for (Dictionary.Pair pair : linkedList) {
            if (pair.key.equals(k)) break;
            ++n;
        }
        return n < linkedList.getLength();
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public int getCapacity() {
        return this.buckets.getLength();
    }

    private void rehash(int n) {
        ArrayList<LinkedList<Dictionary.Pair<K, V>>> arrayList = this.buckets;
        this.buckets = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.buckets.add(null);
        }
        if (arrayList != null) {
            for (LinkedList linkedList : arrayList) {
                if (linkedList == null) continue;
                for (Dictionary.Pair pair : linkedList) {
                    this.put(pair.key, pair.value);
                }
            }
        }
    }

    private LinkedList<Dictionary.Pair<K, V>> getBucket(K k) {
        int n = k.hashCode();
        int n2 = Math.abs(n % this.getCapacity());
        LinkedList<Dictionary.Pair<K, V>> linkedList = this.buckets.get(n2);
        if (linkedList == null) {
            linkedList = new LinkedList();
            this.buckets.update(n2, linkedList);
        }
        return linkedList;
    }

    @Override
    public Comparator<K> getComparator() {
        return this.keys == null ? null : this.keys.getComparator();
    }

    @Override
    public void setComparator(Comparator<K> comparator) {
        Comparator<K> comparator2 = this.getComparator();
        if (comparator == null) {
            this.keys = null;
        } else {
            if (this.keys == null) {
                ArrayList<K> arrayList = new ArrayList<K>((int)((float)this.getCapacity() * this.loadFactor));
                for (K k : this) {
                    arrayList.add(k);
                }
                this.keys = arrayList;
            }
            this.keys.setComparator(comparator);
        }
        if (this.mapListeners != null) {
            this.mapListeners.comparatorChanged(this, comparator2);
        }
    }

    @Override
    public Iterator<K> iterator() {
        return this.keys == null ? new KeyIterator() : new ImmutableIterator(this.keys.iterator());
    }

    @Override
    public ListenerList<MapListener<K, V>> getMapListeners() {
        if (this.mapListeners == null) {
            this.mapListeners = new Map.MapListenerList();
        }
        return this.mapListeners;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" {");
        int n = 0;
        for (K k : this) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(k + ":" + this.get(k));
            ++n;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private class KeyIterator
    implements Iterator<K> {
        private int bucketIndex = 0;
        private Iterator<Dictionary.Pair<K, V>> entryIterator = this.getBucketIterator(this.bucketIndex);
        private int count;

        public KeyIterator() {
            this.count = HashMap.this.count;
        }

        @Override
        public boolean hasNext() {
            if (this.count != HashMap.this.count) {
                throw new ConcurrentModificationException();
            }
            while (this.entryIterator != null && !this.entryIterator.hasNext()) {
                this.entryIterator = ++this.bucketIndex < HashMap.this.buckets.getLength() ? this.getBucketIterator(this.bucketIndex) : null;
            }
            return this.entryIterator != null;
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Dictionary.Pair pair = this.entryIterator.next();
            return pair.key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Iterator<Dictionary.Pair<K, V>> getBucketIterator(int n) {
            LinkedList linkedList = (LinkedList)HashMap.this.buckets.get(n);
            return linkedList == null ? new EmptyIterator() : linkedList.iterator();
        }
    }
}

