/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Set;
import org.apache.pivot.collections.SetListener;
import org.apache.pivot.util.ListenerList;

public class HashSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 4095129319373194969L;
    protected HashMap<E, Void> hashMap = new HashMap();
    private transient Set.SetListenerList<E> setListeners = null;

    public HashSet() {
    }

    public HashSet(Set<E> set) {
        for (Object t : set) {
            this.add(t);
        }
    }

    public HashSet(E ... EArray) {
        for (int i = 0; i < EArray.length; ++i) {
            E e = EArray[i];
            this.add(e);
        }
    }

    public HashSet(Comparator<E> comparator) {
        this.setComparator(comparator);
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        if (!this.hashMap.containsKey(e)) {
            this.hashMap.put(e, null);
            bl = true;
            if (this.setListeners != null) {
                this.setListeners.elementAdded(this, e);
            }
        }
        return bl;
    }

    @Override
    public boolean remove(E e) {
        boolean bl = false;
        if (this.hashMap.containsKey(e)) {
            this.hashMap.remove(e);
            bl = true;
            if (this.setListeners != null) {
                this.setListeners.elementRemoved(this, e);
            }
        }
        return bl;
    }

    @Override
    public void clear() {
        if (!this.hashMap.isEmpty()) {
            this.hashMap.clear();
            if (this.setListeners != null) {
                this.setListeners.setCleared(this);
            }
        }
    }

    @Override
    public boolean contains(E e) {
        return this.hashMap.containsKey(e);
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    @Override
    public int getCount() {
        return this.hashMap.getCount();
    }

    @Override
    public Comparator<E> getComparator() {
        return this.hashMap.getComparator();
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        Comparator<E> comparator2 = this.getComparator();
        this.hashMap.setComparator(comparator);
        if (this.setListeners != null) {
            this.setListeners.comparatorChanged(this, comparator2);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.hashMap.iterator();
    }

    @Override
    public ListenerList<SetListener<E>> getSetListeners() {
        if (this.setListeners == null) {
            this.setListeners = new Set.SetListenerList();
        }
        return this.setListeners;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(" (");
        int n = 0;
        for (E e : this) {
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(e);
            ++n;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

