/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Stack;
import org.apache.pivot.collections.StackListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class LinkedStack<T>
implements Stack<T>,
Serializable {
    private static final long serialVersionUID = -6276454328308188689L;
    private LinkedList<T> linkedList = new LinkedList();
    private transient Stack.StackListenerList<T> stackListeners = new Stack.StackListenerList();

    public LinkedStack() {
        this(null);
    }

    public LinkedStack(Comparator<T> comparator) {
        this.setComparator(comparator);
    }

    @Override
    public void push(T t) {
        this.linkedList.add(t);
        this.stackListeners.itemPushed(this, t);
    }

    @Override
    public T pop() {
        int n = this.linkedList.getLength();
        if (n == 0) {
            throw new IllegalStateException("queue is empty");
        }
        T t = this.linkedList.remove(n - 1, 1).get(0);
        this.stackListeners.itemPopped(this, t);
        return t;
    }

    @Override
    public T peek() {
        T t = null;
        int n = this.linkedList.getLength();
        if (n > 0) {
            t = this.linkedList.get(n - 1);
        }
        return t;
    }

    @Override
    public void clear() {
        if (this.linkedList.getLength() > 0) {
            this.linkedList.clear();
            this.stackListeners.stackCleared(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.linkedList.getLength() == 0;
    }

    @Override
    public int getDepth() {
        return this.linkedList.getLength();
    }

    @Override
    public Comparator<T> getComparator() {
        return this.linkedList.getComparator();
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.getComparator();
        this.linkedList.setComparator(comparator);
        this.stackListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.linkedList.iterator());
    }

    @Override
    public ListenerList<StackListener<T>> getStackListeners() {
        return this.stackListeners;
    }
}

