/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.util.Comparator;
import org.apache.pivot.collections.Collection;
import org.apache.pivot.collections.StackListener;
import org.apache.pivot.util.ListenerList;

public interface Stack<T>
extends Collection<T> {
    public void push(T var1);

    public T pop();

    public T peek();

    @Override
    public boolean isEmpty();

    public int getDepth();

    public ListenerList<StackListener<T>> getStackListeners();

    public static class StackListenerList<T>
    extends ListenerList<StackListener<T>>
    implements StackListener<T> {
        @Override
        public void itemPushed(Stack<T> stack, T t) {
            for (StackListener stackListener : this) {
                stackListener.itemPushed(stack, t);
            }
        }

        @Override
        public void itemPopped(Stack<T> stack, T t) {
            for (StackListener stackListener : this) {
                stackListener.itemPopped(stack, t);
            }
        }

        @Override
        public void stackCleared(Stack<T> stack) {
            for (StackListener stackListener : this) {
                stackListener.stackCleared(stack);
            }
        }

        @Override
        public void comparatorChanged(Stack<T> stack, Comparator<T> comparator) {
            for (StackListener stackListener : this) {
                stackListener.comparatorChanged(stack, comparator);
            }
        }
    }
}

