/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.adapter;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.pivot.collections.Set;
import org.apache.pivot.collections.SetListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SetAdapter<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = -816891924416727900L;
    private java.util.Set<E> set = null;
    private transient Set.SetListenerList<E> setListeners = new Set.SetListenerList();

    public SetAdapter(java.util.Set<E> set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null.");
        }
        this.set = set;
    }

    public java.util.Set<E> getSet() {
        return this.set;
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        if (!this.contains(e)) {
            this.set.add(e);
            bl = true;
            this.setListeners.elementAdded(this, e);
        }
        return bl;
    }

    @Override
    public boolean remove(E e) {
        boolean bl = false;
        if (this.contains(e)) {
            this.set.remove(e);
            bl = false;
            this.setListeners.elementRemoved(this, e);
        }
        return bl;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.set.clear();
            this.setListeners.setCleared(this);
        }
    }

    @Override
    public boolean contains(E e) {
        return this.set.contains(e);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public int getCount() {
        return this.set.size();
    }

    @Override
    public Comparator<E> getComparator() {
        if (this.set instanceof SortedSet) {
            return ((SortedSet)this.set).comparator();
        }
        return null;
    }

    @Override
    public void setComparator(Comparator<E> comparator) {
        Comparator<E> comparator2 = this.getComparator();
        if (this.set instanceof SortedSet) {
            try {
                Constructor<?> constructor = this.set.getClass().getConstructor(Comparator.class);
                if (constructor != null) {
                    SortedSet sortedSet = (SortedSet)constructor.newInstance(comparator);
                    sortedSet.addAll(this.set);
                    this.set = sortedSet;
                }
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        this.setListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<E> iterator() {
        return new ImmutableIterator<E>(this.set.iterator());
    }

    @Override
    public ListenerList<SetListener<E>> getSetListeners() {
        return this.setListeners;
    }

    public String toString() {
        return this.set.toString();
    }
}

