/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedList<T>
implements List<T> {
    private List<T> list;
    private SynchronizedListListenerList<T> listListeners = new SynchronizedListListenerList();

    public SynchronizedList(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("list cannot be null.");
        }
        this.list = list;
    }

    @Override
    public synchronized int add(T t) {
        int n = this.list.add(t);
        this.listListeners.itemInserted(this, n);
        return n;
    }

    @Override
    public synchronized void insert(T t, int n) {
        this.list.insert(t, n);
        this.listListeners.itemInserted(this, n);
    }

    @Override
    public synchronized T update(int n, T t) {
        T t2 = this.list.update(n, t);
        if (t2 != t) {
            this.listListeners.itemUpdated(this, n, t2);
        }
        return t2;
    }

    @Override
    public synchronized int remove(T t) {
        int n = this.indexOf(t);
        if (n == -1) {
            throw new IllegalArgumentException("item not in list");
        }
        this.remove(n, 1);
        return n;
    }

    @Override
    public synchronized Sequence<T> remove(int n, int n2) {
        Sequence<T> sequence = this.list.remove(n, n2);
        if (n2 > 0) {
            this.listListeners.itemsRemoved(this, n, sequence);
        }
        return sequence;
    }

    @Override
    public synchronized void clear() {
        if (this.list.getLength() > 0) {
            this.list.clear();
            this.listListeners.listCleared(this);
        }
    }

    @Override
    public synchronized T get(int n) {
        return this.list.get(n);
    }

    @Override
    public synchronized int indexOf(T t) {
        return this.list.indexOf(t);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public synchronized int getLength() {
        return this.list.getLength();
    }

    @Override
    public synchronized Comparator<T> getComparator() {
        return this.list.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.getComparator();
        this.list.setComparator(comparator);
        this.listListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.list.iterator());
    }

    @Override
    public ListenerList<ListListener<T>> getListListeners() {
        return this.listListeners;
    }

    private static class SynchronizedListListenerList<T>
    extends List.ListListenerList<T> {
        private SynchronizedListListenerList() {
        }

        @Override
        public synchronized void add(ListListener<T> listListener) {
            super.add(listListener);
        }

        @Override
        public synchronized void remove(ListListener<T> listListener) {
            super.remove(listListener);
        }

        @Override
        public synchronized void itemInserted(List<T> list, int n) {
            super.itemInserted(list, n);
        }

        @Override
        public synchronized void itemsRemoved(List<T> list, int n, Sequence<T> sequence) {
            super.itemsRemoved(list, n, sequence);
        }

        @Override
        public synchronized void itemUpdated(List<T> list, int n, T t) {
            super.itemUpdated(list, n, t);
        }

        @Override
        public synchronized void listCleared(List<T> list) {
            super.listCleared(list);
        }

        @Override
        public synchronized void comparatorChanged(List<T> list, Comparator<T> comparator) {
            super.comparatorChanged(list, comparator);
        }
    }
}

