/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.MapListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;
    private SynchronizedMapListenerList<K, V> mapListeners = new SynchronizedMapListenerList();

    public SynchronizedMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("map cannot be null.");
        }
        this.map = map;
    }

    @Override
    public synchronized V get(K k) {
        return this.map.get(k);
    }

    @Override
    public synchronized V put(K k, V v) {
        boolean bl = this.containsKey(k);
        V v2 = this.map.put(k, v);
        if (bl) {
            this.mapListeners.valueUpdated(this, k, v2);
        } else {
            this.mapListeners.valueAdded(this, k);
        }
        return v2;
    }

    @Override
    public synchronized V remove(K k) {
        Object v = null;
        if (this.containsKey(k)) {
            v = this.map.remove(k);
            this.mapListeners.valueRemoved(this, k, v);
        }
        return v;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized void clear() {
        if (!this.map.isEmpty()) {
            this.map.clear();
            this.mapListeners.mapCleared(this);
        }
    }

    @Override
    public synchronized boolean containsKey(K k) {
        return this.map.containsKey(k);
    }

    @Override
    public synchronized int getCount() {
        return this.map.getCount();
    }

    @Override
    public synchronized Comparator<K> getComparator() {
        return this.map.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<K> comparator) {
        Comparator<K> comparator2 = this.getComparator();
        this.map.setComparator(comparator);
        this.mapListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<K> iterator() {
        return new ImmutableIterator(this.map.iterator());
    }

    @Override
    public ListenerList<MapListener<K, V>> getMapListeners() {
        return this.mapListeners;
    }

    private static class SynchronizedMapListenerList<K, V>
    extends Map.MapListenerList<K, V> {
        private SynchronizedMapListenerList() {
        }

        @Override
        public synchronized void add(MapListener<K, V> mapListener) {
            super.add(mapListener);
        }

        @Override
        public synchronized void remove(MapListener<K, V> mapListener) {
            super.remove(mapListener);
        }

        @Override
        public synchronized void valueAdded(Map<K, V> map, K k) {
            super.valueAdded(map, k);
        }

        @Override
        public synchronized void valueRemoved(Map<K, V> map, K k, V v) {
            super.valueRemoved(map, k, v);
        }

        @Override
        public synchronized void valueUpdated(Map<K, V> map, K k, V v) {
            super.valueUpdated(map, k, v);
        }

        @Override
        public synchronized void mapCleared(Map<K, V> map) {
            super.mapCleared(map);
        }

        @Override
        public synchronized void comparatorChanged(Map<K, V> map, Comparator<K> comparator) {
            super.comparatorChanged(map, comparator);
        }
    }
}

