/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections.concurrent;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.Queue;
import org.apache.pivot.collections.QueueListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class SynchronizedQueue<T>
implements Queue<T> {
    private Queue<T> queue;
    private SynchronizedQueueListenerList<T> queueListeners = new SynchronizedQueueListenerList();

    public SynchronizedQueue(Queue<T> queue) {
        if (queue == null) {
            throw new IllegalArgumentException("queue cannot be null.");
        }
        this.queue = queue;
    }

    @Override
    public synchronized void enqueue(T t) {
        this.queue.enqueue(t);
        this.queueListeners.itemEnqueued(this, t);
        this.notify();
    }

    @Override
    public synchronized T dequeue() {
        Object t = null;
        try {
            while (this.isEmpty()) {
                this.wait();
            }
            t = this.queue.dequeue();
            this.queueListeners.itemDequeued(this, t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return t;
    }

    @Override
    public synchronized T peek() {
        return this.queue.peek();
    }

    @Override
    public synchronized void clear() {
        if (!this.queue.isEmpty()) {
            this.queue.clear();
            this.queueListeners.queueCleared(this);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int getLength() {
        return this.queue.getLength();
    }

    @Override
    public synchronized Comparator<T> getComparator() {
        return this.queue.getComparator();
    }

    @Override
    public synchronized void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.getComparator();
        this.queue.setComparator(comparator);
        this.queueListeners.comparatorChanged(this, comparator2);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.queue.iterator());
    }

    @Override
    public ListenerList<QueueListener<T>> getQueueListeners() {
        return this.queueListeners;
    }

    private static class SynchronizedQueueListenerList<T>
    extends Queue.QueueListenerList<T> {
        private SynchronizedQueueListenerList() {
        }

        @Override
        public synchronized void add(QueueListener<T> queueListener) {
            super.add(queueListener);
        }

        @Override
        public synchronized void remove(QueueListener<T> queueListener) {
            super.remove(queueListener);
        }

        @Override
        public synchronized void itemEnqueued(Queue<T> queue, T t) {
            super.itemEnqueued(queue, t);
        }

        @Override
        public synchronized void itemDequeued(Queue<T> queue, T t) {
            super.itemDequeued(queue, t);
        }
    }
}

