/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pivot.util.concurrent.AbortException;
import org.apache.pivot.util.concurrent.Dispatcher;
import org.apache.pivot.util.concurrent.Task;

public abstract class IOTask<V>
extends Task<V> {
    protected volatile long bytesSent = 0L;
    protected volatile long bytesReceived = 0L;

    public IOTask() {
    }

    public IOTask(Dispatcher dispatcher) {
        super(dispatcher);
    }

    protected class MonitoredOutputStream
    extends OutputStream {
        private OutputStream outputStream;

        public MonitoredOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        @Override
        public void flush() throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.outputStream.flush();
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.outputStream.write(byArray);
            IOTask.this.bytesSent += (long)byArray.length;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.outputStream.write(byArray, n, n2);
            IOTask.this.bytesSent += (long)n2;
        }

        @Override
        public void write(int n) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.outputStream.write(n);
            ++IOTask.this.bytesSent;
        }
    }

    protected class MonitoredInputStream
    extends InputStream {
        private InputStream inputStream;
        long mark = 0L;

        public MonitoredInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            int n = this.inputStream.read();
            if (n != -1) {
                ++IOTask.this.bytesReceived;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            int n = this.inputStream.read(byArray);
            if (n != -1) {
                IOTask.this.bytesReceived += (long)n;
            }
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            int n3 = this.inputStream.read(byArray, n, n2);
            if (n3 != -1) {
                IOTask.this.bytesReceived += (long)n3;
            }
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            long l2 = this.inputStream.skip(l);
            IOTask.this.bytesReceived += l2;
            return l2;
        }

        @Override
        public int available() throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public void mark(int n) {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.inputStream.mark(n);
            this.mark = IOTask.this.bytesReceived;
        }

        @Override
        public void reset() throws IOException {
            if (IOTask.this.abort) {
                throw new AbortException();
            }
            this.inputStream.reset();
            IOTask.this.bytesReceived = this.mark;
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }
}

