/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class BinarySerializer
implements Serializer<Object> {
    public static final String MIME_TYPE = "application/x-java-serialized-object";
    public static final String CLASS_PARAMETER = "class";

    @Override
    public Object readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException(classNotFoundException);
        }
        return object;
    }

    @Override
    public void writeObject(Object object, OutputStream outputStream) throws IOException, SerializationException {
        if (object == null) {
            throw new IllegalArgumentException("object is null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(object);
    }

    @Override
    public String getMIMEType(Object object) {
        String string = MIME_TYPE;
        if (object != null) {
            string = string + "; class=" + object.getClass().getName();
        }
        return string;
    }
}

