/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.serialization;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import org.apache.pivot.beans.BeanDictionary;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class CSVSerializer
implements Serializer<List<?>> {
    private Charset charset;
    int c = -1;
    private Class<?> itemClass = HashMap.class;
    private ArrayList<String> keys = new ArrayList();
    private KeySequence keySequence = new KeySequence();
    private LineNumberReader lineNumberReader = null;
    public static final String DEFAULT_CHARSET_NAME = "ISO-8859-1";
    public static final String MIME_TYPE = "text/csv";
    public static final int BUFFER_SIZE = 2048;

    public CSVSerializer() {
        this(DEFAULT_CHARSET_NAME);
    }

    public CSVSerializer(String string) {
        this(string == null ? Charset.defaultCharset() : Charset.forName(string));
    }

    public CSVSerializer(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public KeySequence getKeys() {
        return this.keySequence;
    }

    public Class<?> getItemClass() {
        return this.itemClass;
    }

    public void setItemClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("itemClass is null.");
        }
        this.itemClass = clazz;
    }

    @Override
    public List<?> readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.charset), 2048);
        return this.readObject(bufferedReader);
    }

    public List<?> readObject(Reader reader) throws IOException, SerializationException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null.");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.c = reader.read();
        this.lineNumberReader = new LineNumberReader(reader);
        try {
            while (this.c != -1) {
                Object object = this.readItem(this.lineNumberReader);
                while (object != null) {
                    arrayList.add(object);
                    while (this.c != -1 && (this.c == 13 || this.c == 10)) {
                        this.c = this.lineNumberReader.read();
                    }
                    object = this.readItem(this.lineNumberReader);
                }
            }
        }
        catch (IOException iOException) {
            this.logException(iOException);
            throw iOException;
        }
        catch (SerializationException serializationException) {
            this.logException(serializationException);
            throw serializationException;
        }
        catch (RuntimeException runtimeException) {
            this.logException(runtimeException);
            throw runtimeException;
        }
        this.lineNumberReader = null;
        return arrayList;
    }

    private void logException(Exception exception) {
        System.err.println("An error occurred while processing input at line number " + (this.lineNumberReader.getLineNumber() + 1));
    }

    public StreamIterator getStreamIterator(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.charset), 2048);
        return this.getStreamIterator(bufferedReader);
    }

    public StreamIterator getStreamIterator(Reader reader) throws IOException {
        return new StreamIterator(reader);
    }

    private Object readItem(Reader reader) throws IOException, SerializationException {
        Object var2_2 = null;
        if (this.c != -1) {
            Dictionary dictionary;
            try {
                var2_2 = this.itemClass.newInstance();
                dictionary = var2_2 instanceof Dictionary ? (Dictionary)var2_2 : new BeanDictionary(var2_2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SerializationException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new SerializationException(instantiationException);
            }
            int n = this.keys.getLength();
            for (int i = 0; i < n; ++i) {
                String string = this.keys.get(i);
                String string2 = this.readValue(reader);
                if (string2 == null) {
                    throw new SerializationException("Error reading value for " + string + " from input stream.");
                }
                dictionary.put(string, string2);
            }
        }
        return var2_2;
    }

    private String readValue(Reader reader) throws IOException, SerializationException {
        String string = null;
        if (this.c != -1 && this.c != 13 && this.c != 10) {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = bl = this.c == 34;
            if (bl) {
                this.c = reader.read();
            }
            while (this.c != -1 && (bl || this.c != 44 && this.c != 13 && this.c != 10)) {
                if (this.c == 34) {
                    if (!bl) {
                        throw new SerializationException("Dangling quote.");
                    }
                    this.c = reader.read();
                    if (this.c != 34 && this.c != 44 && this.c != 13 && this.c != 10 && this.c != -1) {
                        throw new SerializationException("Prematurely terminated quote.");
                    }
                    bl &= this.c == 34;
                }
                if (this.c == -1 || !bl && (this.c == 44 || this.c == 13 || this.c == 10)) continue;
                stringBuilder.append((char)this.c);
                this.c = reader.read();
            }
            if (bl) {
                throw new SerializationException("Unterminated string.");
            }
            string = stringBuilder.toString();
            this.c = reader.read();
        }
        return string;
    }

    @Override
    public void writeObject(List<?> list, OutputStream outputStream) throws IOException, SerializationException {
        if (list == null) {
            throw new IllegalArgumentException("items is null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset), 2048);
        this.writeObject(list, bufferedWriter);
    }

    public void writeObject(List<?> list, Writer writer) throws IOException {
        if (list == null) {
            throw new IllegalArgumentException("items is null.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer is null.");
        }
        for (Object t : list) {
            Dictionary dictionary = t instanceof Dictionary ? (Dictionary)t : new BeanDictionary(t);
            int n = this.keys.getLength();
            for (int i = 0; i < n; ++i) {
                Object v;
                String string = this.keys.get(i);
                if (i > 0) {
                    writer.append(",");
                }
                if ((v = dictionary.get(string)) == null) continue;
                String string2 = v.toString();
                if (string2.indexOf(44) >= 0 || string2.indexOf(34) >= 0 || string2.indexOf(13) >= 0 || string2.indexOf(10) >= 0) {
                    writer.append('\"');
                    if (string2.indexOf(34) == -1) {
                        writer.append(string2);
                    } else {
                        writer.append(string2.replace("\"", "\"\""));
                    }
                    writer.append('\"');
                    continue;
                }
                writer.append(string2);
            }
            writer.append("\r\n");
        }
        writer.flush();
    }

    @Override
    public String getMIMEType(List<?> list) {
        return "text/csv; charset=" + this.charset.name();
    }

    public class StreamIterator {
        private Reader reader;

        private StreamIterator(Reader reader) throws IOException {
            this.reader = reader;
            CSVSerializer.this.c = reader.read();
        }

        public boolean hasNext() {
            return CSVSerializer.this.c != -1;
        }

        public Object next() throws IOException, SerializationException {
            if (CSVSerializer.this.c == -1) {
                throw new NoSuchElementException();
            }
            Object object = CSVSerializer.this.readItem(this.reader);
            if (object != null) {
                while (CSVSerializer.this.c != -1 && (CSVSerializer.this.c == 13 || CSVSerializer.this.c == 10)) {
                    CSVSerializer.this.c = this.reader.read();
                }
            }
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class KeySequence
    implements Sequence<String> {
        @Override
        public int add(String string) {
            return CSVSerializer.this.keys.add(string);
        }

        @Override
        public void insert(String string, int n) {
            CSVSerializer.this.keys.insert(string, n);
        }

        @Override
        public String update(int n, String string) {
            return CSVSerializer.this.keys.update(n, string);
        }

        @Override
        public int remove(String string) {
            return CSVSerializer.this.keys.remove(string);
        }

        @Override
        public Sequence<String> remove(int n, int n2) {
            return CSVSerializer.this.keys.remove(n, n2);
        }

        @Override
        public String get(int n) {
            return (String)CSVSerializer.this.keys.get(n);
        }

        @Override
        public int indexOf(String string) {
            return CSVSerializer.this.keys.indexOf(string);
        }

        @Override
        public int getLength() {
            return CSVSerializer.this.keys.getLength();
        }
    }
}

