/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.serialization;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.pivot.beans.BeanDictionary;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Collection;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class JSONSerializer
implements Serializer<Object> {
    private Charset charset = null;
    private int c = -1;
    private boolean alwaysDelimitMapKeys = false;
    private LineNumberReader lineNumberReader = null;
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String MIME_TYPE = "application/json";
    public static final int BUFFER_SIZE = 2048;

    public JSONSerializer() {
        this(DEFAULT_CHARSET_NAME);
    }

    public JSONSerializer(String string) {
        this(string == null ? Charset.defaultCharset() : Charset.forName(string));
    }

    public JSONSerializer(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Object readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.charset), 2048);
        Object object = this.readObject(bufferedReader);
        return object;
    }

    public Object readObject(Reader reader) throws IOException, SerializationException {
        Object object;
        if (reader == null) {
            throw new IllegalArgumentException("reader is null.");
        }
        this.c = reader.read();
        this.lineNumberReader = new LineNumberReader(reader);
        try {
            object = this.readValue(this.lineNumberReader);
        }
        catch (IOException iOException) {
            this.logException(iOException);
            throw iOException;
        }
        catch (SerializationException serializationException) {
            this.logException(serializationException);
            throw serializationException;
        }
        catch (RuntimeException runtimeException) {
            this.logException(runtimeException);
            throw runtimeException;
        }
        this.lineNumberReader = null;
        return object;
    }

    private void logException(Exception exception) {
        System.err.println("An error occurred while processing input at line number " + this.lineNumberReader.getLineNumber() + 1);
    }

    private Object readValue(Reader reader) throws IOException, SerializationException {
        Collection<Object> collection = null;
        this.skipWhitespaceAndComments(reader);
        if (this.c == -1) {
            throw new SerializationException("Unexpected end of input stream.");
        }
        if (this.c == 110) {
            collection = this.readNull(reader);
        } else if (this.c == 34 || this.c == 39) {
            collection = this.readString(reader);
        } else if (this.c == 43 || this.c == 45 || Character.isDigit(this.c)) {
            collection = this.readNumber(reader);
        } else if (this.c == 116 || this.c == 102) {
            collection = this.readBoolean(reader);
        } else if (this.c == 91) {
            collection = this.readList(reader);
        } else if (this.c == 123) {
            collection = this.readMap(reader);
        } else {
            throw new SerializationException("Unexpected character in input stream.");
        }
        return collection;
    }

    private void skipWhitespaceAndComments(Reader reader) throws IOException, SerializationException {
        while (this.c != -1 && (Character.isWhitespace(this.c) || this.c == 47)) {
            boolean bl = this.c == 47;
            this.c = reader.read();
            if (!bl) continue;
            if (this.c == 47) {
                while (this.c != -1 && this.c != 10 && this.c != 13) {
                    this.c = reader.read();
                }
                continue;
            }
            if (this.c == 42) {
                boolean bl2 = false;
                while (this.c != -1 && !bl2) {
                    this.c = reader.read();
                    if (this.c != 42) continue;
                    this.c = reader.read();
                    bl2 = this.c == 47;
                }
                if (!bl2) {
                    throw new SerializationException("Unexpected end of input stream.");
                }
                if (this.c == -1) continue;
                this.c = reader.read();
                continue;
            }
            throw new SerializationException("Unexpected character in input stream.");
        }
    }

    private Object readNull(Reader reader) throws IOException, SerializationException {
        int n;
        String string = "null";
        int n2 = string.length();
        for (n = 0; this.c != -1 && n < n2; ++n) {
            if (string.charAt(n) != this.c) {
                throw new SerializationException("Unexpected character in input stream.");
            }
            this.c = reader.read();
        }
        if (n < n2) {
            throw new SerializationException("Incomplete null value in input stream.");
        }
        return null;
    }

    private String readString(Reader reader) throws IOException, SerializationException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.c;
        this.c = reader.read();
        while (this.c != -1 && this.c != n) {
            if (this.c == 92) {
                this.c = reader.read();
                if (this.c == 98) {
                    this.c = 8;
                } else if (this.c == 102) {
                    this.c = 12;
                } else if (this.c == 110) {
                    this.c = 10;
                } else if (this.c == 114) {
                    this.c = 13;
                } else if (this.c == 116) {
                    this.c = 9;
                } else if (this.c == 117) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    while (stringBuilder2.length() < 4) {
                        this.c = reader.read();
                        stringBuilder2.append((char)this.c);
                    }
                    String string = stringBuilder2.toString();
                    this.c = (char)Integer.parseInt(string, 16);
                } else if (this.c != 92 && this.c != 47 && this.c != 34 && this.c != 39 && this.c != n) {
                    throw new SerializationException("Unsupported escape sequence in input stream.");
                }
            }
            stringBuilder.append((char)this.c);
            this.c = reader.read();
        }
        if (this.c != n) {
            throw new SerializationException("Unterminated string in input stream.");
        }
        this.c = reader.read();
        return stringBuilder.toString();
    }

    private Number readNumber(Reader reader) throws IOException {
        long l;
        Number number = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = true;
        if (this.c == 43 || this.c == 45) {
            bl = this.c == 45;
            this.c = reader.read();
        }
        while (this.c != -1 && (Character.isDigit(this.c) || this.c == 46 || this.c == 101 || this.c == 69)) {
            stringBuilder.append((char)this.c);
            bl2 &= this.c != 46;
            this.c = reader.read();
        }
        number = bl2 ? (Number)((l = Long.parseLong(stringBuilder.toString()) * (long)(bl ? -1 : 1)) > Integer.MAX_VALUE || l < Integer.MIN_VALUE ? (Number)l : (Number)((int)l)) : (Number)(Double.parseDouble(stringBuilder.toString()) * (bl ? -1.0 : 1.0));
        return number;
    }

    private Boolean readBoolean(Reader reader) throws IOException, SerializationException {
        int n;
        String string = this.c == 116 ? "true" : "false";
        int n2 = string.length();
        for (n = 0; this.c != -1 && n < n2; ++n) {
            if (string.charAt(n) != this.c) {
                throw new SerializationException("Unexpected character in input stream.");
            }
            this.c = reader.read();
        }
        if (n < n2) {
            throw new SerializationException("Incomplete boolean value in input stream.");
        }
        return Boolean.parseBoolean(string);
    }

    private List<Object> readList(Reader reader) throws IOException, SerializationException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.c = reader.read();
        this.skipWhitespaceAndComments(reader);
        while (this.c != -1 && this.c != 93) {
            arrayList.add(this.readValue(reader));
            this.skipWhitespaceAndComments(reader);
            if (this.c == 44) {
                this.c = reader.read();
                this.skipWhitespaceAndComments(reader);
                continue;
            }
            if (this.c == -1) {
                throw new SerializationException("Unexpected end of input stream.");
            }
            if (this.c == 93) continue;
            throw new SerializationException("Unexpected character in input stream.");
        }
        this.c = reader.read();
        return arrayList;
    }

    private Map<String, Object> readMap(Reader reader) throws IOException, SerializationException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.c = reader.read();
        this.skipWhitespaceAndComments(reader);
        while (this.c != -1 && this.c != 125) {
            String string = null;
            if (this.c == 34 || this.c == 39) {
                string = this.readString(reader);
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                if (!Character.isJavaIdentifierStart(this.c)) {
                    throw new SerializationException("Illegal identifier start character.");
                }
                while (this.c != -1 && this.c != 58 && !Character.isWhitespace(this.c)) {
                    if (!Character.isJavaIdentifierPart(this.c)) {
                        throw new SerializationException("Illegal identifier character.");
                    }
                    stringBuilder.append((char)this.c);
                    this.c = reader.read();
                }
                if (this.c == -1) {
                    throw new SerializationException("Unexpected end of input stream.");
                }
                string = stringBuilder.toString();
            }
            if (string == null || string.length() == 0) {
                throw new SerializationException("\"" + string + "\" is not a valid key.");
            }
            this.skipWhitespaceAndComments(reader);
            if (this.c != 58) {
                throw new SerializationException("Unexpected character in input stream.");
            }
            this.c = reader.read();
            hashMap.put(string, this.readValue(reader));
            this.skipWhitespaceAndComments(reader);
            if (this.c == 44) {
                this.c = reader.read();
                this.skipWhitespaceAndComments(reader);
                continue;
            }
            if (this.c == -1) {
                throw new SerializationException("Unexpected end of input stream.");
            }
            if (this.c == 125) continue;
            throw new SerializationException("Unexpected character in input stream.");
        }
        this.c = reader.read();
        return hashMap;
    }

    @Override
    public void writeObject(Object object, OutputStream outputStream) throws IOException, SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset), 2048);
        this.writeObject(object, bufferedWriter);
    }

    public void writeObject(Object object, Writer writer) throws IOException, SerializationException {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null.");
        }
        if (object == null) {
            writer.append("null");
        } else if (object instanceof String) {
            String string = (String)object;
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.length();
            block5: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\t': {
                        stringBuilder.append("\\t");
                        continue block5;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        continue block5;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        stringBuilder.append("\\" + c);
                        continue block5;
                    }
                    default: {
                        if (this.charset.name().startsWith("UTF") || c <= '\u00ff') {
                            stringBuilder.append(c);
                            continue block5;
                        }
                        stringBuilder.append("\\u");
                        stringBuilder.append(String.format("%04x", (short)c));
                    }
                }
            }
            writer.append("\"" + stringBuilder.toString() + "\"");
        } else if (object instanceof Number) {
            writer.append(object.toString());
        } else if (object instanceof Boolean) {
            writer.append(object.toString());
        } else if (object instanceof List) {
            List list = (List)object;
            writer.append("[");
            int n = 0;
            for (Object t : list) {
                if (n > 0) {
                    writer.append(", ");
                }
                this.writeObject(t, writer);
                ++n;
            }
            writer.append("]");
        } else if (object instanceof Map) {
            Map map = (Map)object;
            writer.append("{");
            int n = 0;
            for (String string : map) {
                Object v = map.get(string);
                boolean bl = true;
                StringBuilder stringBuilder = new StringBuilder();
                int n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(i);
                    bl &= Character.isJavaIdentifierPart(c);
                    if (c == '\"') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                }
                string = stringBuilder.toString();
                if (n > 0) {
                    writer.append(", ");
                }
                if (!bl || this.alwaysDelimitMapKeys) {
                    writer.append('\"');
                }
                writer.append(string);
                if (!bl || this.alwaysDelimitMapKeys) {
                    writer.append('\"');
                }
                writer.append(": ");
                this.writeObject(v, writer);
                ++n;
            }
            writer.append("}");
        } else {
            throw new IllegalArgumentException(object.getClass() + " is not a supported type.");
        }
        writer.flush();
    }

    @Override
    public String getMIMEType(Object object) {
        return "application/json; charset=" + this.charset.name();
    }

    public boolean getAlwaysDelimitMapKeys() {
        return this.alwaysDelimitMapKeys;
    }

    public void setAlwaysDelimitMapKeys(boolean bl) {
        this.alwaysDelimitMapKeys = bl;
    }

    public static Object get(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("root is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("path is null.");
        }
        return JSONSerializer.get(object, JSONSerializer.split(string));
    }

    private static Object get(Object object, Sequence<String> sequence) {
        Object object2 = object;
        int n = sequence.getLength();
        for (int i = 0; i < n; ++i) {
            Object object3;
            String string = sequence.get(i);
            if (object2 instanceof Sequence) {
                object3 = (Sequence)object2;
                object2 = object3.get(Integer.parseInt(string));
                continue;
            }
            if (object2 instanceof Dictionary) {
                object3 = (Dictionary)object2;
                object2 = object3.get(string);
            } else {
                object3 = new BeanDictionary(object2);
            }
            if (object3.containsKey(string)) {
                object2 = object3.get(string);
                continue;
            }
            object2 = null;
            break;
        }
        return object2;
    }

    public static String getString(Object object, String string) {
        return (String)JSONSerializer.get(object, string);
    }

    public static Number getNumber(Object object, String string) {
        return (Number)JSONSerializer.get(object, string);
    }

    public static Short getShort(Object object, String string) {
        return JSONSerializer.getNumber(object, string).shortValue();
    }

    public static Integer getInteger(Object object, String string) {
        return JSONSerializer.getNumber(object, string).intValue();
    }

    public static Long getLong(Object object, String string) {
        return JSONSerializer.getNumber(object, string).longValue();
    }

    public static Float getFloat(Object object, String string) {
        return Float.valueOf(JSONSerializer.getNumber(object, string).floatValue());
    }

    public static Double getDouble(Object object, String string) {
        return JSONSerializer.getNumber(object, string).doubleValue();
    }

    public static Boolean getBoolean(Object object, String string) {
        return (Boolean)JSONSerializer.get(object, string);
    }

    public static List<?> getList(Object object, String string) {
        return (List)JSONSerializer.get(object, string);
    }

    public static Map<String, ?> getMap(Object object, String string) {
        return (Map)JSONSerializer.get(object, string);
    }

    public static Object put(Object object, String string, Object object2) {
        Object object3;
        if (object == null) {
            throw new IllegalArgumentException("root is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("path is null.");
        }
        Sequence<String> sequence = JSONSerializer.split(string);
        if (sequence.getLength() == 0) {
            throw new IllegalArgumentException("Bad path.");
        }
        String string2 = sequence.remove(sequence.getLength() - 1, 1).get(0);
        Object object4 = JSONSerializer.get(object, sequence);
        if (object4 instanceof Sequence) {
            Sequence sequence2 = (Sequence)object4;
            object3 = sequence2.update(Integer.parseInt(string2), object2);
        } else {
            Dictionary dictionary = object4 instanceof Dictionary ? (Dictionary)object4 : new BeanDictionary(object4);
            object3 = dictionary.put(string2, object2);
        }
        return object3;
    }

    public static Object remove(Object object, String string) {
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException("root is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("path is null.");
        }
        Sequence<String> sequence = JSONSerializer.split(string);
        if (sequence.getLength() == 0) {
            throw new IllegalArgumentException("Bad path.");
        }
        String string2 = sequence.remove(sequence.getLength() - 1, 1).get(0);
        Object object3 = JSONSerializer.get(object, sequence);
        if (object3 instanceof Sequence) {
            Sequence sequence2 = (Sequence)object3;
            object2 = sequence2.remove(Integer.parseInt(string2), 1).get(0);
        } else {
            Dictionary dictionary = object3 instanceof Dictionary ? (Dictionary)object3 : new BeanDictionary(object3);
            object2 = dictionary.remove(string2);
        }
        return object2;
    }

    public static boolean containsKey(Object object, String string) {
        boolean bl;
        if (object == null) {
            throw new IllegalArgumentException("root is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("path is null.");
        }
        Sequence<String> sequence = JSONSerializer.split(string);
        if (sequence.getLength() == 0) {
            throw new IllegalArgumentException("Bad path.");
        }
        String string2 = sequence.remove(sequence.getLength() - 1, 1).get(0);
        Object object2 = JSONSerializer.get(object, sequence);
        if (object2 instanceof Sequence) {
            Sequence sequence2 = (Sequence)object2;
            bl = sequence2.getLength() > Integer.parseInt(string2);
        } else {
            Dictionary dictionary = object2 instanceof Dictionary ? (Dictionary)object2 : new BeanDictionary(object2);
            bl = dictionary.containsKey(string2);
        }
        return bl;
    }

    private static Sequence<String> split(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            boolean bl;
            char c = string.charAt(n++);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = bl = c == '[';
            if (bl && n < n2) {
                boolean bl3;
                c = string.charAt(n++);
                char c2 = '\u0000';
                boolean bl4 = bl3 = c == '\"' || c == '\'';
                if (bl3 && n < n2) {
                    c2 = c;
                    c = string.charAt(n++);
                }
                while (n <= n2 && bl) {
                    bl = bl3 || c != ']';
                    if (!bl) continue;
                    if (c == c2 && n < n2) {
                        boolean bl5 = bl3 = (c = string.charAt(n++)) == c2;
                    }
                    if (!bl3 && c == ']') continue;
                    if (Character.isISOControl(c)) {
                        throw new IllegalArgumentException("Illegal identifier character.");
                    }
                    stringBuilder.append(c);
                    if (n >= n2) continue;
                    c = string.charAt(n++);
                }
                if (bl3) {
                    throw new IllegalArgumentException("Unterminated quoted identifier.");
                }
                if (bl) {
                    throw new IllegalArgumentException("Unterminated bracketed identifier.");
                }
                if (n < n2 && (c = string.charAt(n)) == '.') {
                    ++n;
                }
            } else {
                while (n <= n2 && c != '.' && c != '[') {
                    if (!Character.isJavaIdentifierPart(c)) {
                        throw new IllegalArgumentException("Illegal identifier character.");
                    }
                    stringBuilder.append(c);
                    if (n < n2) {
                        c = string.charAt(n);
                    }
                    ++n;
                }
                if (c == '[') {
                    --n;
                }
            }
            if (c == '.' && n == n2) {
                throw new IllegalArgumentException("Path cannot end with a '.' character.");
            }
            if (stringBuilder.length() == 0) {
                throw new IllegalArgumentException("Missing identifier.");
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static Object parse(String string) throws SerializationException {
        Object object;
        JSONSerializer jSONSerializer = new JSONSerializer();
        try {
            object = jSONSerializer.readObject(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return object;
    }

    public static String parseString(String string) throws SerializationException {
        return (String)JSONSerializer.parse(string);
    }

    public static Number parseNumber(String string) throws SerializationException {
        return (Number)JSONSerializer.parse(string);
    }

    public static Short parseShort(String string) throws SerializationException {
        return (Short)JSONSerializer.parse(string);
    }

    public static Integer parseInteger(String string) throws SerializationException {
        return (Integer)JSONSerializer.parse(string);
    }

    public static Long parseLong(String string) throws SerializationException {
        return (Long)JSONSerializer.parse(string);
    }

    public static Float parseFloat(String string) throws SerializationException {
        return (Float)JSONSerializer.parse(string);
    }

    public static Double parseDouble(String string) throws SerializationException {
        return (Double)JSONSerializer.parse(string);
    }

    public static Boolean parseBoolean(String string) throws SerializationException {
        return (Boolean)JSONSerializer.parse(string);
    }

    public static List<?> parseList(String string) throws SerializationException {
        return (List)JSONSerializer.parse(string);
    }

    public static Map<String, ?> parseMap(String string) throws SerializationException {
        return (Map)JSONSerializer.parse(string);
    }

    public static String toString(Object object) throws SerializationException {
        JSONSerializer jSONSerializer = new JSONSerializer();
        StringWriter stringWriter = new StringWriter();
        try {
            jSONSerializer.writeObject(object, stringWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringWriter.toString();
    }

    public static String toString(String string) {
        try {
            return JSONSerializer.toString((Object)string);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
    }

    public static String toString(Number number) {
        try {
            return JSONSerializer.toString((Object)number);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
    }

    public static String toString(Boolean bl) {
        try {
            return JSONSerializer.toString((Object)bl);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
    }

    public static String toString(List<?> list) {
        try {
            return JSONSerializer.toString(list);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
    }

    public static String toString(Map<String, ?> map) {
        try {
            return JSONSerializer.toString(map);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
    }
}

