/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.adapter.MapAdapter;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class PropertiesSerializer
implements Serializer<Map<?, ?>> {
    public static final String MIME_TYPE = "text/plain";

    @Override
    public Map<?, ?> readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        return new MapAdapter<Object, Object>(properties);
    }

    @Override
    public void writeObject(Map<?, ?> map, OutputStream outputStream) throws IOException, SerializationException {
        if (map == null) {
            throw new IllegalArgumentException("object is null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        Map<?, ?> map2 = map;
        Properties properties = new Properties();
        for (Object t : map2) {
            Object object = map2.get(t);
            if (object != null) {
                object = object.toString();
            }
            properties.put(t, object);
        }
        properties.store(outputStream, null);
    }

    @Override
    public String getMIMEType(Map<?, ?> map) {
        return MIME_TYPE;
    }
}

