/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

public final class Base64 {
    private static final char[] lookup;
    private static final byte[] reverseLookup;

    private Base64() {
    }

    public static String encode(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(4 * (byArray.length / 3 + 1));
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            byte by = byArray[n++];
            byte by2 = n++ < n2 ? byArray[n - 1] : (byte)0;
            byte by3 = n++ < n2 ? byArray[n - 1] : (byte)0;
            stringBuilder.append(lookup[by >> 2]);
            stringBuilder.append(lookup[(by << 4 | by2 >> 4) & 0x3F]);
            stringBuilder.append(lookup[(by2 << 2 | by3 >> 6) & 0x3F]);
            stringBuilder.append(lookup[by3 & 0x3F]);
            if (n <= n2) continue;
            int n3 = stringBuilder.length();
            for (int i = n3 - (n - n2); i < n3; ++i) {
                stringBuilder.setCharAt(i, '=');
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] decode(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (string.charAt(n2) == '=') {
            ++n;
            --n2;
        }
        n2 = string.length() * 6 / 8 - n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = string.length();
        for (int i = 0; i < n4; i += 4) {
            int n5 = reverseLookup[string.charAt(i)] << 18;
            n5 += reverseLookup[string.charAt(i + 1)] << 12;
            n5 += reverseLookup[string.charAt(i + 2)] << 6;
            n5 += reverseLookup[string.charAt(i + 3)];
            for (int j = 0; j < 3 && n3 + j < n2; ++j) {
                byArray[n3 + j] = (byte)(n5 >> 8 * (2 - j));
            }
            n3 += 3;
        }
        return byArray;
    }

    static {
        int n;
        lookup = new char[64];
        reverseLookup = new byte[256];
        for (n = 0; n < 26; ++n) {
            Base64.lookup[n] = (char)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n < 52) {
            Base64.lookup[n] = (char)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n < 62) {
            Base64.lookup[n] = (char)(48 + n2);
            ++n;
            ++n2;
        }
        Base64.lookup[62] = 43;
        Base64.lookup[63] = 47;
        for (n = 0; n < 256; ++n) {
            Base64.reverseLookup[n] = -1;
        }
        for (n = 90; n >= 65; --n) {
            Base64.reverseLookup[n] = (byte)(n - 65);
        }
        for (n = 122; n >= 97; --n) {
            Base64.reverseLookup[n] = (byte)(n - 97 + 26);
        }
        for (n = 57; n >= 48; --n) {
            Base64.reverseLookup[n] = (byte)(n - 48 + 52);
        }
        Base64.reverseLookup[43] = 62;
        Base64.reverseLookup[47] = 63;
        Base64.reverseLookup[61] = 0;
    }
}

