/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Time;

public final class CalendarDate
implements Comparable<CalendarDate>,
Serializable {
    private static final long serialVersionUID = 3974393986540543704L;
    public final int year;
    public final int month;
    public final int day;
    private static final int[] MONTH_LENGTHS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int GREGORIAN_CUTOVER_YEAR = 1582;

    public CalendarDate() {
        this(new GregorianCalendar());
    }

    public CalendarDate(GregorianCalendar gregorianCalendar) {
        this(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5) - 1);
    }

    public CalendarDate(int n, int n2, int n3) {
        boolean bl;
        if (n <= 1582 || n > 9999) {
            throw new IllegalArgumentException("Invalid year: " + n);
        }
        if (n2 < 0 || n2 > 11) {
            throw new IllegalArgumentException("Invalid month: " + n2);
        }
        int n4 = MONTH_LENGTHS[n2];
        boolean bl2 = bl = (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
        if (bl && n2 == 1) {
            ++n4;
        }
        if (n3 < 0 || n3 >= n4) {
            throw new IllegalArgumentException("Invalid day: " + n3);
        }
        this.year = n;
        this.month = n2;
        this.day = n3;
    }

    public CalendarDate add(int n) {
        GregorianCalendar gregorianCalendar = this.toCalendar();
        gregorianCalendar.add(6, n);
        return new CalendarDate(gregorianCalendar);
    }

    public int subtract(CalendarDate calendarDate) {
        GregorianCalendar gregorianCalendar = this.toCalendar();
        GregorianCalendar gregorianCalendar2 = calendarDate.toCalendar();
        long l = gregorianCalendar.getTimeInMillis();
        long l2 = gregorianCalendar2.getTimeInMillis();
        return (int)((l - l2) / 86400000L);
    }

    public GregorianCalendar toCalendar() {
        return this.toCalendar(new Time(0, 0, 0));
    }

    public GregorianCalendar toCalendar(Time time) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.year, this.month, this.day + 1, time.hour, time.minute, time.second);
        gregorianCalendar.set(14, time.millisecond);
        return gregorianCalendar;
    }

    @Override
    public int compareTo(CalendarDate calendarDate) {
        int n = this.year - calendarDate.year;
        if (n == 0 && (n = this.month - calendarDate.month) == 0) {
            n = this.day - calendarDate.day;
        }
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof CalendarDate && ((CalendarDate)object).year == this.year && ((CalendarDate)object).month == this.month && ((CalendarDate)object).day == this.day;
    }

    public int hashCode() {
        Integer n = this.year + this.month + this.day;
        return n.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(4);
        stringBuilder.append(numberFormat.format(this.year));
        stringBuilder.append("-");
        numberFormat.setMinimumIntegerDigits(2);
        stringBuilder.append(numberFormat.format(this.month + 1));
        stringBuilder.append("-");
        stringBuilder.append(numberFormat.format(this.day + 1));
        return stringBuilder.toString();
    }

    public static CalendarDate decode(String string) {
        Pattern pattern = Pattern.compile("^(\\d{4})-(\\d{2})-(\\d{2})$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid date format: " + string);
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2)) - 1;
        int n3 = Integer.parseInt(matcher.group(3)) - 1;
        return new CalendarDate(n, n2, n3);
    }

    public static final class Range {
        public static final String START_KEY = "start";
        public static final String END_KEY = "end";
        public final CalendarDate start;
        public final CalendarDate end;

        public Range(CalendarDate calendarDate) {
            this(calendarDate, calendarDate);
        }

        public Range(CalendarDate calendarDate, CalendarDate calendarDate2) {
            this.start = calendarDate;
            this.end = calendarDate2;
        }

        public Range(String string, String string2) {
            this.start = CalendarDate.decode(string);
            this.end = CalendarDate.decode(string2);
        }

        public Range(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            this.start = range.start;
            this.end = range.end;
        }

        public Range(Dictionary<String, ?> dictionary) {
            if (dictionary == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Object obj = dictionary.get(START_KEY);
            Object obj2 = dictionary.get(END_KEY);
            if (obj == null) {
                throw new IllegalArgumentException("start is required.");
            }
            if (obj2 == null) {
                throw new IllegalArgumentException("end is required.");
            }
            this.start = obj instanceof String ? CalendarDate.decode((String)obj) : (CalendarDate)obj;
            this.end = obj2 instanceof String ? CalendarDate.decode((String)obj2) : (CalendarDate)obj2;
        }

        public int getLength() {
            return Math.abs(this.start.subtract(this.end)) + 1;
        }

        public boolean contains(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Range range2 = range.normalize();
            boolean bl = this.start.compareTo(this.end) < 0 ? this.start.compareTo(range2.start) <= 0 && this.end.compareTo(range2.end) >= 0 : this.end.compareTo(range2.start) <= 0 && this.start.compareTo(range2.end) >= 0;
            return bl;
        }

        public boolean contains(CalendarDate calendarDate) {
            if (calendarDate == null) {
                throw new IllegalArgumentException("calendarDate is null.");
            }
            boolean bl = this.start.compareTo(this.end) < 0 ? this.start.compareTo(calendarDate) <= 0 && this.end.compareTo(calendarDate) >= 0 : this.end.compareTo(calendarDate) <= 0 && this.start.compareTo(calendarDate) >= 0;
            return bl;
        }

        public boolean intersects(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Range range2 = range.normalize();
            boolean bl = this.start.compareTo(this.end) < 0 ? this.start.compareTo(range2.end) <= 0 && this.end.compareTo(range2.start) >= 0 : this.end.compareTo(range2.end) <= 0 && this.start.compareTo(range2.start) >= 0;
            return bl;
        }

        public Range normalize() {
            CalendarDate calendarDate = this.start.compareTo(this.end) < 0 ? this.start : this.end;
            CalendarDate calendarDate2 = calendarDate == this.start ? this.end : this.start;
            return new Range(calendarDate, calendarDate2);
        }

        public static Range decode(String string) {
            Range range;
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (string.startsWith("{")) {
                try {
                    range = new Range(JSONSerializer.parseMap(string));
                }
                catch (SerializationException serializationException) {
                    throw new IllegalArgumentException(serializationException);
                }
            } else {
                range = new Range(CalendarDate.decode(string));
            }
            return range;
        }
    }
}

