/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;

public class Resources
implements Dictionary<String, Object>,
Iterable<String> {
    private final Resources parent;
    private final String baseName;
    private final Locale locale;
    private final Charset charset;
    private Map<String, Object> resourceMap = null;

    public Resources(String string) throws IOException, SerializationException {
        this(null, string, Locale.getDefault(), Charset.defaultCharset());
    }

    public Resources(Resources resources, String string) throws IOException, SerializationException {
        this(resources, string, Locale.getDefault(), Charset.defaultCharset());
    }

    public Resources(String string, Locale locale) throws IOException, SerializationException {
        this(null, string, locale, Charset.defaultCharset());
    }

    public Resources(Resources resources, String string, Locale locale) throws IOException, SerializationException {
        this(resources, string, locale, Charset.defaultCharset());
    }

    public Resources(String string, String string2) throws IOException, SerializationException {
        this(string, Locale.getDefault(), string2);
    }

    public Resources(Resources resources, String string, String string2) throws IOException, SerializationException {
        this(resources, string, Locale.getDefault(), string2);
    }

    public Resources(String string, Charset charset) throws IOException, SerializationException {
        this(null, string, Locale.getDefault(), charset);
    }

    public Resources(Resources resources, String string, Charset charset) throws IOException, SerializationException {
        this(resources, string, Locale.getDefault(), charset);
    }

    public Resources(String string, Locale locale, String string2) throws IOException, SerializationException {
        this(null, string, locale, Charset.forName(string2));
    }

    public Resources(Resources resources, String string, Locale locale, String string2) throws IOException, SerializationException {
        this(resources, string, locale, Charset.forName(string2));
    }

    public Resources(Resources resources, String string, Locale locale, Charset charset) throws IOException, SerializationException {
        if (string == null) {
            throw new IllegalArgumentException("baseName is null");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale is null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset is null.");
        }
        this.parent = resources;
        this.baseName = string;
        this.locale = locale;
        this.charset = charset;
        String string2 = string.replace('.', '/');
        this.resourceMap = this.readJSONResource(string2 + ".json");
        Map<String, Object> map = this.readJSONResource(string2 + "_" + locale.getLanguage() + ".json");
        if (map != null) {
            if (this.resourceMap == null) {
                this.resourceMap = map;
            } else {
                this.applyOverrides(this.resourceMap, map);
            }
        }
        if ((map = this.readJSONResource(string2 + "_" + locale.toString() + ".json")) != null) {
            if (this.resourceMap == null) {
                this.resourceMap = map;
            } else {
                this.applyOverrides(this.resourceMap, map);
            }
        }
        if (this.resourceMap == null) {
            throw new MissingResourceException("Can't find resource for base name " + string + ", locale " + locale, string, "");
        }
    }

    public Resources getParent() {
        return this.parent;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public Object get(String string) {
        Object object = JSONSerializer.get(this.resourceMap, string);
        if (object == null && this.parent != null) {
            return this.parent.get(string);
        }
        return object;
    }

    public String getString(String string) {
        String string2 = JSONSerializer.getString(this.resourceMap, string);
        if (string2 == null && this.parent != null) {
            return this.parent.getString(string);
        }
        return string2;
    }

    public String getString(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(this.getString(string));
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = '{' + String.valueOf(i) + '}';
            String string3 = stringArray[i];
            int n = string2.length();
            int n2 = string3.length();
            int n3 = stringBuilder.indexOf(string2, 0);
            while (n3 != -1) {
                stringBuilder.replace(n3, n3 + n, string3);
                n3 += n2;
                n3 = stringBuilder.indexOf(string2, n3);
            }
        }
        return stringBuilder.toString();
    }

    public Number getNumber(String string) {
        Number number = JSONSerializer.getNumber(this.resourceMap, string);
        if (number == null && this.parent != null) {
            return this.parent.getNumber(string);
        }
        return number;
    }

    public Short getShort(String string) {
        Short s = JSONSerializer.getShort(this.resourceMap, string);
        if (s == null && this.parent != null) {
            return this.parent.getShort(string);
        }
        return s;
    }

    public Integer getInteger(String string) {
        Integer n = JSONSerializer.getInteger(this.resourceMap, string);
        if (n == null && this.parent != null) {
            return this.parent.getInteger(string);
        }
        return n;
    }

    public Long getLong(String string) {
        Long l = JSONSerializer.getLong(this.resourceMap, string);
        if (l == null && this.parent != null) {
            return this.parent.getLong(string);
        }
        return l;
    }

    public Float getFloat(String string) {
        Float f = JSONSerializer.getFloat(this.resourceMap, string);
        if (f == null && this.parent != null) {
            return this.parent.getFloat(string);
        }
        return f;
    }

    public Double getDouble(String string) {
        Double d = JSONSerializer.getDouble(this.resourceMap, string);
        if (d == null && this.parent != null) {
            return this.parent.getDouble(string);
        }
        return d;
    }

    public Boolean getBoolean(String string) {
        Boolean bl = JSONSerializer.getBoolean(this.resourceMap, string);
        if (bl == null && this.parent != null) {
            return this.parent.getBoolean(string);
        }
        return bl;
    }

    public List<?> getList(String string) {
        List<?> list = JSONSerializer.getList(this.resourceMap, string);
        if (list == null && this.parent != null) {
            return this.parent.getList(string);
        }
        return list;
    }

    public Map<String, ?> getMap(String string) {
        Map<String, ?> map = JSONSerializer.getMap(this.resourceMap, string);
        if (map == null && this.parent != null) {
            return this.parent.getMap(string);
        }
        return map;
    }

    @Override
    public Object put(String string, Object object) {
        throw new UnsupportedOperationException("Resources instances are immutable");
    }

    @Override
    public Object remove(String string) {
        throw new UnsupportedOperationException("Resources instances are immutable");
    }

    @Override
    public boolean containsKey(String string) {
        boolean bl = this.resourceMap.containsKey(string);
        if (!bl && this.parent != null) {
            return this.parent.containsKey(string);
        }
        return bl;
    }

    @Override
    public Iterator<String> iterator() {
        return new ImmutableIterator<String>(this.resourceMap.iterator());
    }

    private void applyOverrides(Map<String, Object> map, Map<String, Object> map2) {
        for (String string : map2) {
            if (!map.containsKey(string)) continue;
            Object v = map.get(string);
            Object v2 = map2.get(string);
            if (v instanceof Map && v2 instanceof Map) {
                this.applyOverrides((Map)v, (Map)v2);
                continue;
            }
            map.put(string, map2.get(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> readJSONResource(String string) throws IOException, SerializationException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        JSONSerializer jSONSerializer = new JSONSerializer(this.charset);
        Map map = null;
        try {
            map = (Map)jSONSerializer.readObject(inputStream);
        }
        finally {
            inputStream.close();
        }
        return map;
    }
}

