/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Time
implements Comparable<Time>,
Serializable {
    private static final long serialVersionUID = -2813485511869915193L;
    public final int hour;
    public final int minute;
    public final int second;
    public final int millisecond;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;

    public Time() {
        this(new GregorianCalendar());
    }

    public Time(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException();
        }
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.millisecond = calendar.get(14);
    }

    public Time(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    public Time(int n, int n2, int n3, int n4) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Invalid hour.");
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Invalid minute.");
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("Invalid second.");
        }
        if (n4 < 0 || n4 > 999) {
            throw new IllegalArgumentException("Invalid millisecond.");
        }
        this.hour = n;
        this.minute = n2;
        this.second = n3;
        this.millisecond = n4;
    }

    public Time(int n) {
        n %= 86400000;
        n = (n + 86400000) % 86400000;
        this.hour = n / 3600000;
        this.minute = (n %= 3600000) / 60000;
        this.second = (n %= 60000) / 1000;
        this.millisecond = n %= 1000;
    }

    public Time add(int n) {
        return new Time(this.toMilliseconds() + n);
    }

    public int subtract(Time time) {
        if (time == null) {
            throw new IllegalArgumentException();
        }
        return this.toMilliseconds() - time.toMilliseconds();
    }

    public int toMilliseconds() {
        return this.hour * 3600000 + this.minute * 60000 + this.second * 1000 + this.millisecond;
    }

    @Override
    public int compareTo(Time time) {
        int n = this.hour - time.hour;
        if (n == 0 && (n = this.minute - time.minute) == 0 && (n = this.second - time.second) == 0) {
            n = this.millisecond - time.millisecond;
        }
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof Time && ((Time)object).hour == this.hour && ((Time)object).minute == this.minute && ((Time)object).second == this.second && ((Time)object).millisecond == this.millisecond;
    }

    public int hashCode() {
        Integer n = this.hour + this.minute + this.second + this.millisecond;
        return n.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        stringBuilder.append(numberFormat.format(this.hour));
        stringBuilder.append(":");
        stringBuilder.append(numberFormat.format(this.minute));
        stringBuilder.append(":");
        stringBuilder.append(numberFormat.format(this.second));
        if (this.millisecond > 0) {
            stringBuilder.append(".");
            numberFormat.setMinimumIntegerDigits(3);
            stringBuilder.append(numberFormat.format(this.millisecond));
        }
        return stringBuilder.toString();
    }

    public static Time decode(String string) {
        Pattern pattern = Pattern.compile("^(\\d{2}):(\\d{2}):(\\d{2})(\\.(\\d{3}))?$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid time format: " + string);
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2));
        int n3 = Integer.parseInt(matcher.group(3));
        int n4 = matcher.groupCount() == 5 ? Integer.parseInt(matcher.group(4).substring(1)) : 0;
        return new Time(n, n2, n3, n4);
    }

    public static final class Range {
        public static final String START_KEY = "start";
        public static final String END_KEY = "end";
        public final Time start;
        public final Time end;

        public Range(Time time) {
            this(time, time);
        }

        public Range(Time time, Time time2) {
            this.start = time;
            this.end = time2;
        }

        public Range(String string, String string2) {
            this.start = Time.decode(string);
            this.end = Time.decode(string2);
        }

        public Range(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            this.start = range.start;
            this.end = range.end;
        }

        public Range(Dictionary<String, ?> dictionary) {
            if (dictionary == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Object obj = dictionary.get(START_KEY);
            Object obj2 = dictionary.get(END_KEY);
            if (obj == null) {
                throw new IllegalArgumentException("start is required.");
            }
            if (obj2 == null) {
                throw new IllegalArgumentException("end is required.");
            }
            this.start = obj instanceof String ? Time.decode((String)obj) : (Time)obj;
            this.end = obj2 instanceof String ? Time.decode((String)obj2) : (Time)obj2;
        }

        public int getLength() {
            return Math.abs(this.start.subtract(this.end)) + 1;
        }

        public boolean contains(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Range range2 = range.normalize();
            boolean bl = this.start.compareTo(this.end) < 0 ? this.start.compareTo(range2.start) <= 0 && this.end.compareTo(range2.end) >= 0 : this.end.compareTo(range2.start) <= 0 && this.start.compareTo(range2.end) >= 0;
            return bl;
        }

        public boolean contains(Time time) {
            if (time == null) {
                throw new IllegalArgumentException("time is null.");
            }
            boolean bl = this.start.compareTo(this.end) < 0 ? this.start.compareTo(time) <= 0 && this.end.compareTo(time) >= 0 : this.end.compareTo(time) <= 0 && this.start.compareTo(time) >= 0;
            return bl;
        }

        public boolean intersects(Range range) {
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            Range range2 = range.normalize();
            boolean bl = this.start.compareTo(this.end) < 0 ? this.start.compareTo(range2.end) <= 0 && this.end.compareTo(range2.start) >= 0 : this.end.compareTo(range2.end) <= 0 && this.start.compareTo(range2.start) >= 0;
            return bl;
        }

        public Range normalize() {
            Time time = this.start.compareTo(this.end) < 0 ? this.start : this.end;
            Time time2 = time == this.start ? this.end : this.start;
            return new Range(time, time2);
        }

        public static Range decode(String string) {
            Range range;
            if (string == null) {
                throw new IllegalArgumentException();
            }
            if (string.startsWith("{")) {
                try {
                    range = new Range(JSONSerializer.parseMap(string));
                }
                catch (SerializationException serializationException) {
                    throw new IllegalArgumentException(serializationException);
                }
            } else {
                range = new Range(Time.decode(string));
            }
            return range;
        }
    }
}

