/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util.concurrent;

import org.apache.pivot.util.concurrent.Dispatcher;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;

public abstract class Task<V> {
    private Dispatcher dispatcher = null;
    private V result = null;
    private Exception fault = null;
    private TaskListener<V> taskListener = null;
    protected volatile long timeout = Long.MAX_VALUE;
    protected volatile boolean abort = false;
    private ExecuteCallback executeCallback = null;
    private static Dispatcher DEFAULT_DISPATCHER = new Dispatcher();

    public Task() {
        this(DEFAULT_DISPATCHER);
    }

    public Task(Dispatcher dispatcher) {
        if (dispatcher == null) {
            throw new IllegalArgumentException("dispatcher is null.");
        }
        this.dispatcher = dispatcher;
    }

    public abstract V execute() throws TaskExecutionException;

    public synchronized void execute(TaskListener<V> taskListener) {
        if (taskListener == null) {
            throw new IllegalArgumentException("taskListener is null.");
        }
        if (this.taskListener != null) {
            throw new IllegalThreadStateException("Task is already pending.");
        }
        this.taskListener = taskListener;
        this.result = null;
        this.fault = null;
        this.abort = false;
        this.executeCallback = new ExecuteCallback();
        this.dispatcher.getPendingQueue().enqueue(this.executeCallback);
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public synchronized V getResult() {
        return this.result;
    }

    public synchronized Exception getFault() {
        return this.fault;
    }

    public synchronized boolean isPending() {
        return this.taskListener != null;
    }

    public synchronized long getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(long l) {
        this.timeout = l;
    }

    public synchronized void abort() {
        if (this.taskListener == null) {
            throw new IllegalStateException("Task is not currently pending.");
        }
        this.abort = true;
    }

    private class ExecuteCallback
    implements Runnable {
        private ExecuteCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskListener taskListener;
            Object var1_1 = null;
            Exception exception = null;
            try {
                var1_1 = Task.this.execute();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            Task task = Task.this;
            synchronized (task) {
                Task.this.result = var1_1;
                Task.this.fault = exception;
                Task.this.abort = false;
                taskListener = Task.this.taskListener;
                Task.this.taskListener = null;
            }
            if (exception == null) {
                taskListener.taskExecuted(Task.this);
            } else {
                taskListener.executeFailed(Task.this);
            }
        }
    }
}

