/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util.concurrent;

import java.util.Iterator;
import org.apache.pivot.collections.Group;
import org.apache.pivot.collections.HashSet;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.concurrent.Dispatcher;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;

public class TaskGroup
extends Task<Void>
implements Group<Task<?>>,
Iterable<Task<?>> {
    private HashSet<Task<?>> tasks = new HashSet();
    private int count = 0;
    private int complete = 0;

    public TaskGroup() {
    }

    public TaskGroup(Dispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public synchronized Void execute() throws TaskExecutionException {
        TaskListener<Object> taskListener = new TaskListener<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void taskExecuted(Task<Object> task) {
                TaskGroup taskGroup = TaskGroup.this;
                synchronized (taskGroup) {
                    TaskGroup.this.complete++;
                    TaskGroup.this.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeFailed(Task<Object> task) {
                TaskGroup taskGroup = TaskGroup.this;
                synchronized (taskGroup) {
                    TaskGroup.this.complete++;
                    TaskGroup.this.notify();
                }
            }
        };
        this.complete = 0;
        for (Task<?> task : this.tasks) {
            task.execute(taskListener);
        }
        while (this.complete < this.count) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new TaskExecutionException(interruptedException);
            }
        }
        return null;
    }

    @Override
    public boolean add(Task<?> task) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        boolean bl = this.tasks.add(task);
        if (bl) {
            ++this.count;
        }
        return bl;
    }

    @Override
    public boolean remove(Task<?> task) {
        if (this.isPending()) {
            throw new IllegalStateException();
        }
        boolean bl = this.tasks.remove(task);
        if (bl) {
            --this.count;
        }
        return bl;
    }

    @Override
    public boolean contains(Task<?> task) {
        return this.tasks.contains(task);
    }

    @Override
    public Iterator<Task<?>> iterator() {
        return new ImmutableIterator(this.tasks.iterator());
    }
}

