/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.xml;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.xml.ElementListener;
import org.apache.pivot.xml.Node;
import org.apache.pivot.xml.TextNode;

public class Element
extends Node
implements List<Node>,
Dictionary<String, String> {
    private String namespacePrefix;
    private String localName;
    private String defaultNamespaceURI = null;
    private HashMap<String, String> namespaces = new HashMap();
    private NamespaceDictionary namespaceDictionary = new NamespaceDictionary();
    private ArrayList<Attribute> attributes = new ArrayList();
    private AttributeSequence attributeSequence = new AttributeSequence();
    private HashMap<String, Attribute> attributeMap = new HashMap();
    private ArrayList<Node> nodes = new ArrayList();
    private List.ListListenerList<Node> listListeners = new List.ListListenerList();
    private ElementListenerList elementListeners = new ElementListenerList();

    public Element(String string) {
        this(null, string);
    }

    public Element(String string, String string2) {
        Element.validateName(string, string2);
        this.namespacePrefix = string;
        this.localName = string2;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getName() {
        String string = this.namespacePrefix == null ? this.localName : this.namespacePrefix + ":" + this.localName;
        return string;
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    public void setDefaultNamespaceURI(String string) {
        String string2 = this.defaultNamespaceURI;
        if (string2 != string) {
            this.defaultNamespaceURI = string;
            this.elementListeners.defaultNamespaceURIChanged(this, string2);
        }
    }

    public NamespaceDictionary getNamespaces() {
        return this.namespaceDictionary;
    }

    public String getNamespaceURI(String string) {
        Element element = this.getParent();
        String string2 = string == null ? (this.defaultNamespaceURI == null ? element.getDefaultNamespaceURI() : this.defaultNamespaceURI) : (this.namespaces.containsKey(string) ? this.namespaces.get(string) : element.getNamespaceURI(string));
        return string2;
    }

    public AttributeSequence getAttributes() {
        return this.attributeSequence;
    }

    @Override
    public int add(Node node) {
        if (node.getParent() != null) {
            throw new IllegalArgumentException();
        }
        int n = this.getLength();
        this.insert(node, n);
        return n;
    }

    @Override
    public void insert(Node node, int n) {
        if (node.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.nodes.insert(node, n);
        node.setParent(this);
        this.listListeners.itemInserted(this, n);
    }

    @Override
    public Node update(int n, Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remove(Node node) {
        int n = this.indexOf(node);
        if (n != -1) {
            this.remove(n, 1);
        }
        return n;
    }

    @Override
    public Sequence<Node> remove(int n, int n2) {
        Sequence<Node> sequence = this.nodes.remove(n, n2);
        if (n2 > 0) {
            int n3 = sequence.getLength();
            for (int i = 0; i < n3; ++i) {
                Node node = sequence.get(i);
                node.setParent(null);
            }
            this.listListeners.itemsRemoved(this, n, sequence);
        }
        return sequence;
    }

    @Override
    public void clear() {
        if (this.getLength() > 0) {
            int n = this.nodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = this.nodes.get(i);
                node.setParent(null);
            }
            this.nodes.clear();
            this.listListeners.listCleared(this);
        }
    }

    @Override
    public Node get(int n) {
        return this.nodes.get(n);
    }

    @Override
    public int indexOf(Node node) {
        return this.nodes.indexOf(node);
    }

    @Override
    public int getLength() {
        return this.nodes.getLength();
    }

    @Override
    public Comparator<Node> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<Node> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Node> iterator() {
        return new ImmutableIterator<Node>(this.nodes.iterator());
    }

    @Override
    public String get(String string) {
        Attribute attribute = this.attributeMap.get(string);
        return attribute == null ? null : attribute.getValue();
    }

    @Override
    public String put(String string, String string2) {
        String string3;
        Attribute attribute = this.attributeMap.get(string);
        if (attribute == null) {
            String string4;
            String string5;
            string3 = null;
            int n = string.indexOf(58);
            if (n == -1) {
                string5 = null;
                string4 = string;
            } else {
                string5 = string.substring(0, n);
                string4 = string.substring(n + 1);
            }
            this.attributeSequence.add(new Attribute(string5, string4, string2));
        } else {
            string3 = attribute.getValue();
            attribute.setValue(string2);
        }
        return string3;
    }

    @Override
    public String remove(String string) {
        Attribute attribute = this.attributeMap.get(string);
        if (attribute != null) {
            this.attributeSequence.remove(attribute);
        }
        return attribute == null ? null : attribute.getValue();
    }

    @Override
    public boolean containsKey(String string) {
        return this.attributeMap.containsKey(string);
    }

    @Override
    public boolean isEmpty() {
        return this.attributeMap.isEmpty();
    }

    public List<Element> getElements(String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            Element element;
            Node node = this.get(i);
            if (!(node instanceof Element) || !(element = (Element)node).getName().equals(string)) continue;
            arrayList.add(element);
        }
        return arrayList;
    }

    public String getText() {
        Node node;
        String string = null;
        if (this.getLength() == 1 && (node = this.get(0)) instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            string = textNode.getText();
        }
        return string;
    }

    @Override
    public ListenerList<ListListener<Node>> getListListeners() {
        return this.listListeners;
    }

    public ListenerList<ElementListener> getElementListeners() {
        return this.elementListeners;
    }

    private static void validateName(String string, String string2) {
        int n;
        int n2;
        char c;
        if (string != null) {
            if (string.length() == 0) {
                throw new IllegalArgumentException("Namespace prefix is empty.");
            }
            c = string.charAt(0);
            if (!Character.isLetter(c)) {
                throw new IllegalArgumentException("'" + c + "' is not a valid start" + " character for a namespace prefix.");
            }
            n2 = string.length();
            for (n = 1; n < n2; ++n) {
                c = string.charAt(n);
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') continue;
                throw new IllegalArgumentException("'" + c + "' is not a valid character" + " for a namespace prefix.");
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("Local name is empty.");
        }
        c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            throw new IllegalArgumentException("'" + c + "' is not a valid start" + " character for a local name.");
        }
        n2 = string2.length();
        for (n = 1; n < n2; ++n) {
            c = string2.charAt(n);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.') continue;
            throw new IllegalArgumentException("'" + c + "' is not a valid character" + " for a local name.");
        }
    }

    private static class ElementListenerList
    extends ListenerList<ElementListener>
    implements ElementListener {
        private ElementListenerList() {
        }

        @Override
        public void defaultNamespaceURIChanged(Element element, String string) {
            for (ElementListener elementListener : this) {
                elementListener.defaultNamespaceURIChanged(element, string);
            }
        }

        @Override
        public void namespaceAdded(Element element, String string) {
            for (ElementListener elementListener : this) {
                elementListener.namespaceAdded(element, string);
            }
        }

        @Override
        public void namespaceUpdated(Element element, String string, String string2) {
            for (ElementListener elementListener : this) {
                elementListener.namespaceUpdated(element, string, string2);
            }
        }

        @Override
        public void namespaceRemoved(Element element, String string, String string2) {
            for (ElementListener elementListener : this) {
                elementListener.namespaceRemoved(element, string, string2);
            }
        }

        @Override
        public void attributeInserted(Element element, int n) {
            for (ElementListener elementListener : this) {
                elementListener.attributeInserted(element, n);
            }
        }

        @Override
        public void attributesRemoved(Element element, int n, Sequence<Attribute> sequence) {
            for (ElementListener elementListener : this) {
                elementListener.attributesRemoved(element, n, sequence);
            }
        }

        @Override
        public void attributeValueChanged(Attribute attribute, String string) {
            for (ElementListener elementListener : this) {
                elementListener.attributeValueChanged(attribute, string);
            }
        }
    }

    public class NamespaceDictionary
    implements Dictionary<String, String>,
    Iterable<String> {
        private NamespaceDictionary() {
        }

        @Override
        public String get(String string) {
            return (String)Element.this.namespaces.get(string);
        }

        @Override
        public String put(String string, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("uri is null.");
            }
            boolean bl = this.containsKey(string);
            String string3 = Element.this.namespaces.put(string, string2);
            if (bl) {
                Element.this.elementListeners.namespaceUpdated(Element.this, string, string3);
            } else {
                Element.this.elementListeners.namespaceAdded(Element.this, string);
            }
            return string3;
        }

        @Override
        public String remove(String string) {
            String string2 = null;
            if (this.containsKey(string)) {
                string2 = (String)Element.this.namespaces.remove(string);
                Element.this.elementListeners.namespaceRemoved(Element.this, string, string2);
            }
            return string2;
        }

        @Override
        public boolean containsKey(String string) {
            return Element.this.namespaces.containsKey(string);
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator<String>(Element.this.namespaces.iterator());
        }
    }

    public class AttributeSequence
    implements Sequence<Attribute>,
    Iterable<Attribute> {
        private AttributeSequence() {
        }

        @Override
        public int add(Attribute attribute) {
            int n = this.getLength();
            this.insert(attribute, n);
            return n;
        }

        @Override
        public void insert(Attribute attribute, int n) {
            if (attribute == null) {
                throw new IllegalArgumentException();
            }
            if (attribute.getElement() != null) {
                throw new IllegalArgumentException();
            }
            String string = attribute.getName();
            if (Element.this.attributeMap.containsKey(string)) {
                throw new IllegalArgumentException("Attribute \"" + string + "\" already exists.");
            }
            Element.this.attributes.insert(attribute, n);
            Element.this.attributeMap.put(string, attribute);
            attribute.setElement(Element.this);
            Element.this.elementListeners.attributeInserted(Element.this, n);
        }

        @Override
        public Attribute update(int n, Attribute attribute) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Attribute attribute) {
            int n = this.indexOf(attribute);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        @Override
        public Sequence<Attribute> remove(int n, int n2) {
            Sequence<Attribute> sequence = Element.this.attributes.remove(n, n2);
            if (n2 > 0) {
                int n3 = sequence.getLength();
                for (int i = 0; i < n3; ++i) {
                    Attribute attribute = sequence.get(i);
                    String string = attribute.getName();
                    Element.this.attributeMap.remove(string);
                    attribute.setElement(null);
                }
                Element.this.elementListeners.attributesRemoved(Element.this, n, sequence);
            }
            return sequence;
        }

        @Override
        public Attribute get(int n) {
            return (Attribute)Element.this.attributes.get(n);
        }

        @Override
        public int indexOf(Attribute attribute) {
            return Element.this.attributes.indexOf(attribute);
        }

        @Override
        public int getLength() {
            return Element.this.attributes.getLength();
        }

        @Override
        public Iterator<Attribute> iterator() {
            return new ImmutableIterator<Attribute>(Element.this.attributes.iterator());
        }
    }

    public static class Attribute {
        private Element element = null;
        private String namespacePrefix;
        private String localName;
        private String value;

        public Attribute(String string, String string2) {
            this(null, string, string2);
        }

        public Attribute(String string, String string2, String string3) {
            Element.validateName(string, string2);
            this.namespacePrefix = string;
            this.localName = string2;
            this.setValue(string3);
        }

        public Element getElement() {
            return this.element;
        }

        private void setElement(Element element) {
            this.element = element;
        }

        public String getNamespacePrefix() {
            return this.namespacePrefix;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getName() {
            String string = this.namespacePrefix == null ? this.localName : this.namespacePrefix + ":" + this.localName;
            return string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            String string2 = this.value;
            if (string2 != string) {
                this.value = string;
                if (this.element != null) {
                    this.element.elementListeners.attributeValueChanged(this, string2);
                }
            }
        }
    }
}

