/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.pivot.io.IOTask;
import org.apache.pivot.serialization.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.concurrent.Dispatcher;
import org.apache.pivot.web.QueryDictionary;
import org.apache.pivot.web.QueryException;
import org.apache.pivot.web.QueryListener;

public abstract class Query<V>
extends IOTask<V> {
    private URL locationContext = null;
    private HostnameVerifier hostnameVerifier = null;
    private Proxy proxy = null;
    private QueryDictionary parameters = new QueryDictionary();
    private QueryDictionary requestHeaders = new QueryDictionary();
    private QueryDictionary responseHeaders = new QueryDictionary();
    private int status = 0;
    private volatile long bytesExpected = -1L;
    private Serializer<?> serializer = new JSONSerializer();
    private QueryListenerList<V> queryListeners = new QueryListenerList();
    public static final int DEFAULT_PORT = -1;
    public static final Dispatcher DEFAULT_DISPATCHER = new Dispatcher();
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String URL_ENCODING = "UTF-8";

    public Query(String string, int n, String string2, boolean bl) {
        super(DEFAULT_DISPATCHER);
        try {
            this.locationContext = new URL(bl ? HTTPS_PROTOCOL : HTTP_PROTOCOL, string, n, string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Unable to construct context URL.", malformedURLException);
        }
    }

    public abstract Method getMethod();

    public String getHostname() {
        return this.locationContext.getHost();
    }

    public String getPath() {
        return this.locationContext.getFile();
    }

    public int getPort() {
        return this.locationContext.getPort();
    }

    public boolean isSecure() {
        String string = this.locationContext.getProtocol();
        return string.equalsIgnoreCase(HTTPS_PROTOCOL);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public URL getLocation() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.parameters) {
            for (int i = 0; i < this.parameters.getLength(string); ++i) {
                try {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("&");
                    }
                    stringBuilder.append(URLEncoder.encode(string, URL_ENCODING) + "=" + URLEncoder.encode(this.parameters.get(string, i), URL_ENCODING));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException("Unable to construct query string.", unsupportedEncodingException);
                }
            }
        }
        Object object = null;
        try {
            String string;
            string = stringBuilder.length() > 0 ? "?" + stringBuilder.toString() : "";
            object = new URL(this.locationContext.getProtocol(), this.locationContext.getHost(), this.locationContext.getPort(), this.locationContext.getPath() + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("Unable to construct query URL.", malformedURLException);
        }
        return object;
    }

    public QueryDictionary getParameters() {
        return this.parameters;
    }

    public QueryDictionary getRequestHeaders() {
        return this.requestHeaders;
    }

    public QueryDictionary getResponseHeaders() {
        return this.responseHeaders;
    }

    public int getStatus() {
        return this.status;
    }

    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer is null.");
        }
        this.serializer = serializer;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getBytesExpected() {
        return this.bytesExpected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(Method method, Object object) throws QueryException {
        URL uRL = this.getLocation();
        HttpURLConnection httpURLConnection = null;
        Serializer<?> serializer = this.serializer;
        this.bytesSent = 0L;
        this.bytesReceived = 0L;
        this.bytesExpected = -1L;
        this.status = 0;
        String string = null;
        try {
            String string22;
            Object object2;
            this.responseHeaders.clear();
            httpURLConnection = this.proxy == null ? (HttpURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection(this.proxy);
            httpURLConnection.setRequestMethod(method.toString());
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setUseCaches(false);
            if (httpURLConnection instanceof HttpsURLConnection && this.hostnameVerifier != null) {
                object2 = (HttpsURLConnection)httpURLConnection;
                ((HttpsURLConnection)object2).setHostnameVerifier(this.hostnameVerifier);
            }
            if (method == Method.POST || method == Method.PUT) {
                httpURLConnection.setRequestProperty("Content-Type", serializer.getMIMEType(object));
            }
            for (String string22 : this.requestHeaders) {
                int n = this.requestHeaders.getLength(string22);
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        httpURLConnection.setRequestProperty(string22, this.requestHeaders.get(string22, i));
                        continue;
                    }
                    httpURLConnection.addRequestProperty(string22, this.requestHeaders.get(string22, i));
                }
            }
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(method == Method.POST || method == Method.PUT);
            httpURLConnection.connect();
            this.queryListeners.connected(this);
            if (method == Method.POST || method == Method.PUT) {
                object2 = null;
                try {
                    object2 = httpURLConnection.getOutputStream();
                    serializer.writeObject(object, (OutputStream)new IOTask.MonitoredOutputStream((IOTask)this, (OutputStream)object2));
                }
                finally {
                    if (object2 != null) {
                        ((OutputStream)object2).close();
                    }
                }
            }
            this.queryListeners.requestSent(this);
            this.status = httpURLConnection.getResponseCode();
            string = httpURLConnection.getResponseMessage();
            this.bytesExpected = httpURLConnection.getContentLength();
            int n = 1;
            string22 = httpURLConnection.getHeaderFieldKey(n);
            while (string22 != null) {
                this.responseHeaders.add(string22, httpURLConnection.getHeaderField(n));
                string22 = httpURLConnection.getHeaderFieldKey(++n);
            }
            int n2 = this.status / 100;
            if (n2 != 2) {
                throw new QueryException(this.status, string);
            }
            if (method == Method.GET) {
                InputStream inputStream = null;
                try {
                    inputStream = httpURLConnection.getInputStream();
                    object = serializer.readObject((InputStream)new IOTask.MonitoredInputStream((IOTask)this, inputStream));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            this.queryListeners.responseReceived(this);
        }
        catch (IOException iOException) {
            this.queryListeners.failed(this);
            throw new QueryException(iOException);
        }
        catch (SerializationException serializationException) {
            this.queryListeners.failed(this);
            throw new QueryException(serializationException);
        }
        catch (RuntimeException runtimeException) {
            this.queryListeners.failed(this);
            throw runtimeException;
        }
        return object;
    }

    public ListenerList<QueryListener<V>> getQueryListeners() {
        return this.queryListeners;
    }

    static {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class QueryListenerList<V>
    extends ListenerList<QueryListener<V>>
    implements QueryListener<V> {
        private QueryListenerList() {
        }

        public synchronized void add(QueryListener<V> queryListener) {
            super.add(queryListener);
        }

        public synchronized void remove(QueryListener<V> queryListener) {
            super.remove(queryListener);
        }

        @Override
        public synchronized void connected(Query<V> query) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                QueryListener queryListener = (QueryListener)iterator.next();
                queryListener.connected(query);
            }
        }

        @Override
        public synchronized void requestSent(Query<V> query) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                QueryListener queryListener = (QueryListener)iterator.next();
                queryListener.requestSent(query);
            }
        }

        @Override
        public synchronized void responseReceived(Query<V> query) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                QueryListener queryListener = (QueryListener)iterator.next();
                queryListener.responseReceived(query);
            }
        }

        @Override
        public synchronized void failed(Query<V> query) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                QueryListener queryListener = (QueryListener)iterator.next();
                queryListener.failed(query);
            }
        }
    }

    public static class Status {
        public static final int OK = 200;
        public static final int CREATED = 201;
        public static final int NO_CONTENT = 204;
        public static final int BAD_REQUEST = 400;
        public static final int UNAUTHORIZED = 401;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int METHOD_NOT_ALLOWED = 405;
        public static final int REQUEST_TIMEOUT = 408;
        public static final int CONFLICT = 409;
        public static final int LENGTH_REQUIRED = 411;
        public static final int PRECONDITION_FAILED = 412;
        public static final int REQUEST_ENTITY_TOO_LARGE = 413;
        public static final int REQUEST_URI_TOO_LONG = 414;
        public static final int UNSUPPORTED_MEDIA_TYPE = 415;
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int SERVICE_UNAVAILABLE = 503;
        public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

