/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.charts;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.charts.ChartViewCategoryListener;
import org.apache.pivot.charts.ChartViewListener;
import org.apache.pivot.charts.ChartViewSeriesListener;
import org.apache.pivot.charts.Provider;
import org.apache.pivot.charts.ProviderNotFoundException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Service;
import org.apache.pivot.wtk.Component;

public abstract class ChartView
extends Component {
    private List<?> chartData;
    private String seriesNameKey;
    private String title = null;
    private String horizontalAxisLabel = null;
    private String verticalAxisLabel = null;
    private boolean showLegend;
    private ArrayList<Category> categories = new ArrayList();
    private CategorySequence categorySequence = new CategorySequence();
    private ListHandler chartDataHandler = new ListHandler();
    private ChartViewListenerList chartViewListeners = new ChartViewListenerList();
    private ChartViewCategoryListenerList chartViewCategoryListeners = new ChartViewCategoryListenerList();
    private ChartViewSeriesListenerList chartViewSeriesListeners = new ChartViewSeriesListenerList();
    public static final String DEFAULT_SERIES_NAME_KEY = "name";
    public static final String PROVIDER_NAME = "org.apache.pivot.charts.Provider";
    private static Provider provider = null;

    public ChartView() {
        this(DEFAULT_SERIES_NAME_KEY, (List<?>)new ArrayList());
    }

    public ChartView(String string, List<?> list) {
        this.setSeriesNameKey(string);
        this.setTitle(this.title);
        this.setChartData(list);
        this.setShowLegend(this.showLegend);
    }

    protected final void installChartSkin(Class<? extends ChartView> clazz) {
        Class<? extends org.apache.pivot.wtk.Skin> clazz2 = provider.getSkinClass(clazz);
        try {
            this.setSkin(clazz2.newInstance());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
    }

    public CategorySequence getCategories() {
        return this.categorySequence;
    }

    public List<?> getChartData() {
        return this.chartData;
    }

    public void setChartData(List<?> list) {
        if (list == null) {
            throw new IllegalArgumentException("chartData is null.");
        }
        List<?> list2 = this.chartData;
        if (list2 != list) {
            if (list2 != null) {
                list2.getListListeners().remove((Object)this.chartDataHandler);
            }
            list.getListListeners().add((Object)this.chartDataHandler);
            this.chartData = list;
            this.chartViewListeners.chartDataChanged(this, list2);
        }
    }

    public String getSeriesNameKey() {
        return this.seriesNameKey;
    }

    public void setSeriesNameKey(String string) {
        if (string == null) {
            throw new IllegalArgumentException("seriesNameKey is null.");
        }
        String string2 = this.seriesNameKey;
        if (string2 != string) {
            this.seriesNameKey = string;
            this.chartViewListeners.seriesNameKeyChanged(this, string2);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        if (string2 != string) {
            this.title = string;
            this.chartViewListeners.titleChanged(this, string2);
        }
    }

    public String getHorizontalAxisLabel() {
        return this.horizontalAxisLabel;
    }

    public void setHorizontalAxisLabel(String string) {
        String string2 = this.horizontalAxisLabel;
        if (string2 != string) {
            this.horizontalAxisLabel = string;
            this.chartViewListeners.horizontalAxisLabelChanged(this, string2);
        }
    }

    public String getVerticalAxisLabel() {
        return this.verticalAxisLabel;
    }

    public void setVerticalAxisLabel(String string) {
        String string2 = this.verticalAxisLabel;
        if (string2 != string) {
            this.verticalAxisLabel = string;
            this.chartViewListeners.verticalAxisLabelChanged(this, string2);
        }
    }

    public boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean bl) {
        if (this.showLegend != bl) {
            this.showLegend = bl;
            this.chartViewListeners.showLegendChanged(this);
        }
    }

    public Element getElementAt(int n, int n2) {
        return ((Skin)this.getSkin()).getElementAt(n, n2);
    }

    public ListenerList<ChartViewListener> getChartViewListeners() {
        return this.chartViewListeners;
    }

    public ListenerList<ChartViewCategoryListener> getChartViewCategoryListeners() {
        return this.chartViewCategoryListeners;
    }

    public ListenerList<ChartViewSeriesListener> getChartViewSeriesListeners() {
        return this.chartViewSeriesListeners;
    }

    static {
        provider = (Provider)Service.getProvider((String)PROVIDER_NAME);
        if (provider == null) {
            throw new ProviderNotFoundException();
        }
    }

    private static class ChartViewSeriesListenerList
    extends ListenerList<ChartViewSeriesListener>
    implements ChartViewSeriesListener {
        private ChartViewSeriesListenerList() {
        }

        @Override
        public void seriesInserted(ChartView chartView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewSeriesListener chartViewSeriesListener = (ChartViewSeriesListener)iterator.next();
                chartViewSeriesListener.seriesInserted(chartView, n);
            }
        }

        @Override
        public void seriesRemoved(ChartView chartView, int n, int n2) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewSeriesListener chartViewSeriesListener = (ChartViewSeriesListener)iterator.next();
                chartViewSeriesListener.seriesRemoved(chartView, n, n2);
            }
        }

        @Override
        public void seriesUpdated(ChartView chartView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewSeriesListener chartViewSeriesListener = (ChartViewSeriesListener)iterator.next();
                chartViewSeriesListener.seriesUpdated(chartView, n);
            }
        }

        @Override
        public void seriesCleared(ChartView chartView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewSeriesListener chartViewSeriesListener = (ChartViewSeriesListener)iterator.next();
                chartViewSeriesListener.seriesCleared(chartView);
            }
        }

        @Override
        public void seriesSorted(ChartView chartView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewSeriesListener chartViewSeriesListener = (ChartViewSeriesListener)iterator.next();
                chartViewSeriesListener.seriesSorted(chartView);
            }
        }
    }

    private static class ChartViewCategoryListenerList
    extends ListenerList<ChartViewCategoryListener>
    implements ChartViewCategoryListener {
        private ChartViewCategoryListenerList() {
        }

        @Override
        public void categoryInserted(ChartView chartView, int n) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewCategoryListener chartViewCategoryListener = (ChartViewCategoryListener)iterator.next();
                chartViewCategoryListener.categoryInserted(chartView, n);
            }
        }

        @Override
        public void categoriesRemoved(ChartView chartView, int n, Sequence<Category> sequence) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewCategoryListener chartViewCategoryListener = (ChartViewCategoryListener)iterator.next();
                chartViewCategoryListener.categoriesRemoved(chartView, n, sequence);
            }
        }

        @Override
        public void categoryKeyChanged(ChartView chartView, int n, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewCategoryListener chartViewCategoryListener = (ChartViewCategoryListener)iterator.next();
                chartViewCategoryListener.categoryKeyChanged(chartView, n, string);
            }
        }

        @Override
        public void categoryLabelChanged(ChartView chartView, int n, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewCategoryListener chartViewCategoryListener = (ChartViewCategoryListener)iterator.next();
                chartViewCategoryListener.categoryLabelChanged(chartView, n, string);
            }
        }
    }

    private static class ChartViewListenerList
    extends ListenerList<ChartViewListener>
    implements ChartViewListener {
        private ChartViewListenerList() {
        }

        @Override
        public void chartDataChanged(ChartView chartView, List<?> list) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewListener chartViewListener = (ChartViewListener)iterator.next();
                chartViewListener.chartDataChanged(chartView, list);
            }
        }

        @Override
        public void seriesNameKeyChanged(ChartView chartView, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewListener chartViewListener = (ChartViewListener)iterator.next();
                chartViewListener.seriesNameKeyChanged(chartView, string);
            }
        }

        @Override
        public void titleChanged(ChartView chartView, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewListener chartViewListener = (ChartViewListener)iterator.next();
                chartViewListener.titleChanged(chartView, string);
            }
        }

        @Override
        public void horizontalAxisLabelChanged(ChartView chartView, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewListener chartViewListener = (ChartViewListener)iterator.next();
                chartViewListener.horizontalAxisLabelChanged(chartView, string);
            }
        }

        @Override
        public void verticalAxisLabelChanged(ChartView chartView, String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewListener chartViewListener = (ChartViewListener)iterator.next();
                chartViewListener.verticalAxisLabelChanged(chartView, string);
            }
        }

        @Override
        public void showLegendChanged(ChartView chartView) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ChartViewListener chartViewListener = (ChartViewListener)iterator.next();
                chartViewListener.showLegendChanged(chartView);
            }
        }
    }

    private class ListHandler
    implements ListListener<Object> {
        private ListHandler() {
        }

        public void itemInserted(List<Object> list, int n) {
            ChartView.this.chartViewSeriesListeners.seriesInserted(ChartView.this, n);
        }

        public void itemsRemoved(List<Object> list, int n, Sequence<Object> sequence) {
            int n2 = sequence.getLength();
            ChartView.this.chartViewSeriesListeners.seriesRemoved(ChartView.this, n, n2);
        }

        public void itemUpdated(List<Object> list, int n, Object object) {
            ChartView.this.chartViewSeriesListeners.seriesUpdated(ChartView.this, n);
        }

        public void listCleared(List<Object> list) {
            ChartView.this.chartViewSeriesListeners.seriesCleared(ChartView.this);
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> comparator) {
            if (list.getComparator() != null) {
                ChartView.this.chartViewSeriesListeners.seriesSorted(ChartView.this);
            }
        }
    }

    public final class CategorySequence
    implements Sequence<Category> {
        public int add(Category category) {
            int n = this.getLength();
            this.insert(category, n);
            return n;
        }

        public void insert(Category category, int n) {
            if (category == null) {
                throw new IllegalArgumentException("category is null.");
            }
            if (category.getChartView() != null) {
                throw new IllegalArgumentException("category is already in use by another chart view.");
            }
            ChartView.this.categories.insert((Object)category, n);
            category.setChartView(ChartView.this);
            ChartView.this.chartViewCategoryListeners.categoryInserted(ChartView.this, n);
        }

        public Category update(int n, Category category) {
            throw new UnsupportedOperationException();
        }

        public int remove(Category category) {
            int n = this.indexOf(category);
            if (n != -1) {
                this.remove(n, 1);
            }
            return n;
        }

        public Sequence<Category> remove(int n, int n2) {
            Sequence sequence = ChartView.this.categories.remove(n, n2);
            if (n2 > 0) {
                int n3 = sequence.getLength();
                for (int i = 0; i < n3; ++i) {
                    ((Category)sequence.get(i)).setChartView(null);
                }
                ChartView.this.chartViewCategoryListeners.categoriesRemoved(ChartView.this, n, (Sequence<Category>)sequence);
            }
            return sequence;
        }

        public Category get(int n) {
            return (Category)ChartView.this.categories.get(n);
        }

        public int indexOf(Category category) {
            return ChartView.this.categories.indexOf((Object)category);
        }

        public int getLength() {
            return ChartView.this.categories.getLength();
        }
    }

    public static interface Skin {
        public Element getElementAt(int var1, int var2);
    }

    public static class Element {
        private int seriesIndex;
        private int elementIndex;

        public Element(int n, int n2) {
            this.seriesIndex = n;
            this.elementIndex = n2;
        }

        public int getSeriesIndex() {
            return this.seriesIndex;
        }

        public int getElementIndex() {
            return this.elementIndex;
        }

        public String toString() {
            String string = this.getClass().getName() + this.seriesIndex + ", " + this.elementIndex;
            return string;
        }
    }

    public static class Category {
        private ChartView chartView = null;
        private String key;
        private String label;

        public Category() {
            this(null, null);
        }

        public Category(String string) {
            this(string, string);
        }

        public Category(String string, String string2) {
            this.key = string;
            this.label = string2;
        }

        public ChartView getChartView() {
            return this.chartView;
        }

        private void setChartView(ChartView chartView) {
            this.chartView = chartView;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String string) {
            if (string == null) {
                throw new IllegalArgumentException("key is null.");
            }
            String string2 = this.key;
            if (string2 != string) {
                this.key = string;
                if (this.chartView != null) {
                    this.chartView.chartViewCategoryListeners.categoryKeyChanged(this.chartView, this.chartView.categories.indexOf((Object)this), string2);
                }
            }
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            if (string == null) {
                throw new IllegalArgumentException("label is null.");
            }
            String string2 = this.label;
            if (string2 != string) {
                this.label = string;
                if (this.chartView != null) {
                    this.chartView.chartViewCategoryListeners.categoryLabelChanged(this.chartView, this.chartView.categories.indexOf((Object)this), string2);
                }
            }
        }
    }
}

