/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.ActivityIndicator;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ActivityIndicatorSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraActivityIndicatorSkin
extends ActivityIndicatorSkin {
    private Color[] colors;
    private Color backgroundColor;
    private int angle = 0;
    private ApplicationContext.ScheduledCallback updateCallback = null;

    public TerraActivityIndicatorSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColor(terraTheme.getColor(2));
        this.backgroundColor = null;
    }

    public int getPreferredWidth(int n) {
        return 128;
    }

    public int getPreferredHeight(int n) {
        return 128;
    }

    public void paint(Graphics2D graphics2D) {
        ActivityIndicator activityIndicator = (ActivityIndicator)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.backgroundColor != null) {
            graphics2D.setColor(this.backgroundColor);
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (activityIndicator.isActive()) {
            float f;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (n > n2) {
                graphics2D.translate((n - n2) / 2, 0);
                f = (float)n2 / 128.0f;
                graphics2D.scale(f, f);
            } else {
                graphics2D.translate(0, (n2 - n) / 2);
                f = (float)n / 128.0f;
                graphics2D.scale(f, f);
            }
            graphics2D.translate(64, 64);
            graphics2D.rotate(Math.PI / 180 * (double)this.angle);
            for (int i = 0; i < 12; ++i) {
                graphics2D.setColor(this.colors[i]);
                graphics2D.fillRoundRect(24, -4, 32, 8, 8, 8);
                graphics2D.rotate(0.5235987755982988);
            }
        }
    }

    public Color getColor() {
        return this.colors[0];
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.colors = new Color[12];
        for (int i = 0; i < 12; ++i) {
            float f = 255.0f * (float)i / 12.0f;
            this.colors[i] = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)f);
        }
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColor(terraTheme.getColor(n));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaintComponent();
    }

    public void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public void activeChanged(ActivityIndicator activityIndicator) {
        if (activityIndicator.isActive()) {
            this.updateCallback = ApplicationContext.scheduleRecurringCallback((Runnable)new Runnable(){

                @Override
                public void run() {
                    TerraActivityIndicatorSkin.this.angle = (TerraActivityIndicatorSkin.this.angle + 30) % 360;
                    TerraActivityIndicatorSkin.this.repaintComponent();
                }
            }, (long)100L);
        } else {
            this.updateCallback.cancel();
            this.updateCallback = null;
            this.repaintComponent();
        }
    }
}

