/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.ColorChooser;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.skin.ColorChooserSkin;
import org.apache.pivot.wtk.skin.ComponentSkin;

public class TerraColorChooserSkin
extends ColorChooserSkin {
    private TablePane tablePane = new TablePane();
    private SaturationValueChooser saturationValueChooser = new SaturationValueChooser();
    private HueChooser hueChooser = new HueChooser();
    private boolean updating = false;

    public TerraColorChooserSkin() {
        this.tablePane.getStyles().put("horizontalSpacing", (Object)6);
        this.tablePane.getColumns().add(new TablePane.Column(31, true));
        this.tablePane.getColumns().add(new TablePane.Column(4, true));
        TablePane.Row row = new TablePane.Row(1, true);
        this.tablePane.getRows().add(row);
        row.add((Component)this.saturationValueChooser);
        row.add((Component)this.hueChooser);
    }

    public void install(Component component) {
        super.install(component);
        ColorChooser colorChooser = (ColorChooser)component;
        colorChooser.add((Component)this.tablePane);
        this.selectedColorChanged(colorChooser, null);
    }

    public int getPreferredWidth(int n) {
        return this.tablePane.getPreferredWidth(n);
    }

    public int getPreferredHeight(int n) {
        return this.tablePane.getPreferredHeight(n);
    }

    public Dimensions getPreferredSize() {
        return this.tablePane.getPreferredSize();
    }

    public void layout() {
        this.tablePane.setSize(this.getWidth(), this.getHeight());
        this.tablePane.setLocation(0, 0);
    }

    public int getSpacing() {
        return (Integer)this.tablePane.getStyles().get("horizontalSpacing");
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.tablePane.getStyles().put("horizontalSpacing", (Object)n);
    }

    public final void setSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.tablePane.getStyles().put("horizontalSpacing", (Object)number);
    }

    public void selectedColorChanged(ColorChooser colorChooser, Color color) {
        if (!this.updating) {
            Color color2 = colorChooser.getSelectedColor();
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (color2 != null) {
                float[] fArray = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null);
                f = fArray[0];
                f2 = fArray[1];
                f3 = fArray[2];
            }
            this.hueChooser.setHue(f);
            this.saturationValueChooser.setSaturation(f2);
            this.saturationValueChooser.setValue(f3);
        }
        this.repaintComponent();
    }

    private class SaturationValueChooserSkin
    extends ComponentSkin {
        private boolean capture = false;

        private SaturationValueChooserSkin() {
        }

        public int getPreferredWidth(int n) {
            return 140;
        }

        public int getPreferredHeight(int n) {
            return 185;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    Color color = Color.getHSBColor(TerraColorChooserSkin.this.hueChooser.getHue(), 1.0f - (float)j / (float)n2, (float)i / (float)n);
                    graphics2D.setColor(color);
                    graphics2D.fillRect(i, j, 1, 1);
                }
            }
            float f = TerraColorChooserSkin.this.hueChooser.getHue();
            float f2 = TerraColorChooserSkin.this.saturationValueChooser.getSaturation();
            float f3 = TerraColorChooserSkin.this.saturationValueChooser.getValue();
            graphics2D.setXORMode(Color.getHSBColor(f, 0.0f, 0.0f));
            graphics2D.fillRect(0, Math.min((int)((float)n2 * (1.0f - f2)), n2 - 1), n, 1);
            graphics2D.fillRect(Math.min((int)((float)n * f3), n - 1), 0, 1, n2);
            graphics2D.setPaintMode();
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean mouseMove(Component component, int n, int n2) {
            boolean bl = super.mouseMove(component, n, n2);
            if (this.capture && Mouse.getCapturer() != component) {
                Mouse.capture((Component)component);
            }
            if (Mouse.getCapturer() == component) {
                this.setSelectedColor(n, n2);
            }
            return bl;
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            if (Mouse.getCapturer() != component) {
                this.capture = false;
            }
        }

        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseDown(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                this.setSelectedColor(n, n2);
                this.capture = true;
                bl = true;
            }
            return bl;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseUp(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                this.capture = false;
                if (Mouse.getCapturer() == component) {
                    Mouse.release();
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSelectedColor(int n, int n2) {
            ColorChooser colorChooser = (ColorChooser)TerraColorChooserSkin.this.getComponent();
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            float f = TerraColorChooserSkin.this.hueChooser.getHue();
            float f2 = 1.0f - (float)Math.min(Math.max(n2, 0), n4 - 1) / (float)n4;
            float f3 = (float)Math.min(Math.max(n, 0), n3 - 1) / (float)n3;
            TerraColorChooserSkin.this.saturationValueChooser.setSaturation(f2);
            TerraColorChooserSkin.this.saturationValueChooser.setValue(f3);
            TerraColorChooserSkin.this.updating = true;
            try {
                colorChooser.setSelectedColor(Color.getHSBColor(f, f2, f3));
            }
            finally {
                TerraColorChooserSkin.this.updating = false;
            }
        }
    }

    private class SaturationValueChooser
    extends Component {
        private float saturation = 0.0f;
        private float value = 0.0f;

        public SaturationValueChooser() {
            this.setSkin((Skin)new SaturationValueChooserSkin());
        }

        public float getSaturation() {
            return this.saturation;
        }

        public void setSaturation(float f) {
            this.saturation = f;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float f) {
            this.value = f;
        }
    }

    private class HueChooserSkin
    extends ComponentSkin {
        private boolean capture = false;

        private HueChooserSkin() {
        }

        public int getPreferredWidth(int n) {
            return 18;
        }

        public int getPreferredHeight(int n) {
            return 185;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            for (int i = 0; i < n2; ++i) {
                Color color = Color.getHSBColor(1.0f - (float)i / (float)n2, 1.0f, 1.0f);
                graphics2D.setColor(color);
                graphics2D.fillRect(0, i, n, 1);
            }
            float f = TerraColorChooserSkin.this.hueChooser.getHue();
            graphics2D.setXORMode(Color.getHSBColor(1.0f - f, 1.0f, 1.0f));
            graphics2D.fillRect(0, Math.min((int)((float)n2 * (1.0f - f)), n2 - 1), n, 1);
            graphics2D.setPaintMode();
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean mouseMove(Component component, int n, int n2) {
            boolean bl = super.mouseMove(component, n, n2);
            if (this.capture && Mouse.getCapturer() != component) {
                Mouse.capture((Component)component);
            }
            if (Mouse.getCapturer() == component) {
                this.setSelectedColor(n2);
            }
            return bl;
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            if (Mouse.getCapturer() != component) {
                this.capture = false;
            }
        }

        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseDown(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                this.setSelectedColor(n2);
                this.capture = true;
                bl = true;
            }
            return bl;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseUp(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                this.capture = false;
                if (Mouse.getCapturer() == component) {
                    Mouse.release();
                }
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSelectedColor(int n) {
            ColorChooser colorChooser = (ColorChooser)TerraColorChooserSkin.this.getComponent();
            int n2 = this.getHeight();
            float f = 1.0f - (float)Math.min(Math.max(n, 0), n2 - 1) / (float)n2;
            float f2 = TerraColorChooserSkin.this.saturationValueChooser.getSaturation();
            float f3 = TerraColorChooserSkin.this.saturationValueChooser.getValue();
            TerraColorChooserSkin.this.hueChooser.setHue(f);
            TerraColorChooserSkin.this.updating = true;
            try {
                colorChooser.setSelectedColor(Color.getHSBColor(f, f2, f3));
            }
            finally {
                TerraColorChooserSkin.this.updating = false;
            }
        }
    }

    private class HueChooser
    extends Component {
        private float hue = 0.0f;

        public HueChooser() {
            this.setSkin((Skin)new HueChooserSkin());
        }

        public float getHue() {
            return this.hue;
        }

        public void setHue(float f) {
            this.hue = f;
        }
    }
}

