/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Toolkit;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Dialog;
import org.apache.pivot.wtk.DialogStateListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.terra.TerraFrameSkin;

public class TerraDialogSkin
extends TerraFrameSkin
implements DialogStateListener {
    private ApplicationContext.QueuedCallback queuedCallback = null;
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseMove(Container container, int n, int n2) {
            return this.isMouseOverRelative(container, n, n2);
        }

        public boolean mouseDown(Container container, Mouse.Button button, int n, int n2) {
            boolean bl = false;
            if (this.isMouseOverRelative(container, n, n2)) {
                Dialog dialog = (Dialog)TerraDialogSkin.this.getComponent();
                Window window = dialog.getRootOwner();
                window.moveToFront();
                dialog.requestActive();
                bl = true;
                Toolkit.getDefaultToolkit().beep();
            }
            return bl;
        }

        public boolean mouseUp(Container container, Mouse.Button button, int n, int n2) {
            return this.isMouseOverRelative(container, n, n2);
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
            return this.isMouseOverRelative(container, n3, n4);
        }

        private boolean isMouseOverRelative(Container container, int n, int n2) {
            Window window;
            Component component;
            boolean bl = false;
            Dialog dialog = (Dialog)TerraDialogSkin.this.getComponent();
            if (dialog.isModal() && (component = container.getDescendantAt(n, n2)) != container && (window = component.getWindow()) != dialog) {
                int n3;
                ArrayList arrayList = new ArrayList();
                for (Dialog dialog2 = dialog; dialog2 != null; dialog2 = dialog2.getOwner()) {
                    arrayList.insert((Object)dialog2, 0);
                }
                ArrayList arrayList2 = new ArrayList();
                for (Window window2 = window; window2 != null; window2 = window2.getOwner()) {
                    arrayList2.insert((Object)window2, 0);
                }
                for (n3 = 0; n3 < arrayList.getLength() && n3 < arrayList2.getLength() && arrayList.get(n3) == arrayList2.get(n3); ++n3) {
                }
                bl = n3 > 0;
            }
            return bl;
        }
    };

    @Override
    public void install(Component component) {
        super.install(component);
        Dialog dialog = (Dialog)component;
        dialog.getDialogStateListeners().add((Object)this);
        this.setShowMaximizeButton(false);
        this.setShowMinimizeButton(false);
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        Dialog dialog = (Dialog)component;
        Window window = dialog.getRootOwner();
        window.moveToFront();
        return super.mouseDown(component, button, n, n2);
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = false;
        Dialog dialog = (Dialog)this.getComponent();
        if (n == 10) {
            dialog.close(true);
            bl = true;
        } else if (n == 27) {
            dialog.close(false);
            bl = true;
        } else {
            bl = super.keyPressed(component, n, keyLocation);
        }
        return bl;
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        display.reenterMouse();
        if (!window.requestFocus()) {
            Component.clearFocus();
        }
        this.queuedCallback = ApplicationContext.queueCallback((Runnable)new RepositionCallback());
    }

    public void windowClosed(Window window, Display display, Window window2) {
        super.windowClosed(window, display, window2);
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
        if (this.queuedCallback != null) {
            this.queuedCallback.cancel();
            this.queuedCallback = null;
        }
    }

    public Vote previewDialogClose(Dialog dialog, boolean bl) {
        return Vote.APPROVE;
    }

    public void dialogCloseVetoed(Dialog dialog, Vote vote) {
    }

    public void dialogClosed(Dialog dialog, boolean bl) {
    }

    private class RepositionCallback
    implements Runnable {
        private static final float GOLDEN_SECTION = 0.382f;

        private RepositionCallback() {
        }

        @Override
        public void run() {
            Dialog dialog = (Dialog)TerraDialogSkin.this.getComponent();
            Window window = dialog.getOwner();
            if (window == null) {
                window = dialog.getDisplay();
            }
            int n = window.getWidth() - TerraDialogSkin.this.getWidth();
            int n2 = window.getHeight() - TerraDialogSkin.this.getHeight();
            int n3 = Math.max(0, Math.round((float)window.getX() + 0.5f * (float)n));
            int n4 = Math.max(0, Math.round((float)window.getY() + 0.382f * (float)n2));
            dialog.setLocation(n3, n4);
            TerraDialogSkin.this.queuedCallback = null;
        }
    }
}

