/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.FilteredList;
import org.apache.pivot.collections.FilteredListListener;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.text.FileSizeFormat;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.Resources;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Direction;
import org.apache.pivot.wtk.FileBrowser;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewSelectionListener;
import org.apache.pivot.wtk.TableViewSortListener;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextInputTextListener;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.FileBrowserSkin;
import org.apache.pivot.wtkx.WTKX;
import org.apache.pivot.wtkx.WTKXSerializer;

public class TerraFileBrowserSkin
extends FileBrowserSkin {
    private Component content = null;
    @WTKX
    private ListButton driveListButton = null;
    @WTKX
    private ListButton pathListButton = null;
    @WTKX
    private PushButton goUpButton = null;
    @WTKX
    private PushButton newFolderButton = null;
    @WTKX
    private PushButton goHomeButton = null;
    @WTKX
    private TextInput searchTextInput = null;
    @WTKX
    private ScrollPane fileScrollPane = null;
    @WTKX
    private TableView fileTableView = null;
    private FilteredList<File> files = new FilteredList((Filter)new IncludeFileFilter());
    private boolean keyboardFolderTraversalEnabled = true;
    private boolean hideDisabledFiles = false;
    private boolean updatingSelection = false;
    private static final FileFilter HIDDEN_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isHidden();
        }
    };

    public void install(Component component) {
        Resources resources;
        super.install(component);
        final FileBrowser fileBrowser = (FileBrowser)component;
        try {
            resources = new Resources(((Object)((Object)this)).getClass().getName());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
        WTKXSerializer wTKXSerializer = new WTKXSerializer(resources);
        try {
            this.content = (Component)wTKXSerializer.readObject((Object)this, "terra_file_browser_skin.wtkx");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (SerializationException serializationException) {
            throw new RuntimeException(serializationException);
        }
        fileBrowser.add(this.content);
        wTKXSerializer.bind((Object)this, TerraFileBrowserSkin.class);
        this.driveListButton.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

            public void selectedIndexChanged(ListButton listButton, int n) {
                if (n != -1) {
                    File file = (File)listButton.getSelectedItem();
                    fileBrowser.setRootDirectory(file);
                }
            }
        });
        this.pathListButton.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

            public void selectedIndexChanged(ListButton listButton, int n) {
                File file = (File)listButton.getSelectedItem();
                if (file != null) {
                    fileBrowser.setRootDirectory(file);
                }
            }
        });
        this.goUpButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                File file = fileBrowser.getRootDirectory();
                File file2 = file.getParentFile();
                fileBrowser.setRootDirectory(file2);
            }
        });
        this.newFolderButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
            }
        });
        this.goHomeButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                fileBrowser.setRootDirectory(new File(System.getProperty("user.home")));
            }
        });
        this.searchTextInput.getComponentKeyListeners().add((Object)new ComponentKeyListener.Adapter(){

            public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
                boolean bl = super.keyPressed(component, n, keyLocation);
                if (n == 27) {
                    TerraFileBrowserSkin.this.searchTextInput.setText("");
                    bl = true;
                } else if (n == 40 && TerraFileBrowserSkin.this.files.getLength() > 0) {
                    TerraFileBrowserSkin.this.fileTableView.setSelectedIndex(0);
                    TerraFileBrowserSkin.this.fileTableView.requestFocus();
                }
                return bl;
            }
        });
        this.searchTextInput.getTextInputTextListeners().add((Object)new TextInputTextListener(){

            public void textChanged(TextInput textInput) {
                String string = textInput.getText().trim();
                if (string.length() == 0) {
                    string = null;
                }
                Filter filter = null;
                if (TerraFileBrowserSkin.this.hideDisabledFiles) {
                    filter = fileBrowser.getDisabledFileFilter();
                }
                TerraFileBrowserSkin.this.files.setFilter((Filter)new IncludeFileFilter(string, (Filter<File>)filter));
            }
        });
        this.fileTableView.getTableViewSelectionListeners().add((Object)new TableViewSelectionListener(){

            public void selectedRangeAdded(TableView tableView, int n, int n2) {
                TerraFileBrowserSkin.this.updatingSelection = true;
                for (int i = n; i <= n2; ++i) {
                    File file = (File)TerraFileBrowserSkin.this.files.get(i);
                    fileBrowser.addSelectedFile(file);
                }
                TerraFileBrowserSkin.this.updatingSelection = false;
            }

            public void selectedRangeRemoved(TableView tableView, int n, int n2) {
                TerraFileBrowserSkin.this.updatingSelection = true;
                for (int i = n; i <= n2; ++i) {
                    File file = (File)TerraFileBrowserSkin.this.files.get(i);
                    fileBrowser.removeSelectedFile(file);
                }
                TerraFileBrowserSkin.this.updatingSelection = false;
            }

            public void selectedRangesChanged(TableView tableView, Sequence<Span> sequence) {
                TerraFileBrowserSkin.this.updatingSelection = true;
                Sequence sequence2 = tableView.getSelectedRows();
                int n = sequence2.getLength();
                for (int i = 0; i < n; ++i) {
                    File file = (File)sequence2.get(i);
                    sequence2.update(i, (Object)file);
                }
                fileBrowser.setSelectedFiles(sequence2);
                TerraFileBrowserSkin.this.updatingSelection = false;
            }
        });
        this.fileTableView.getTableViewSortListeners().add((Object)new TableViewSortListener.Adapter(){

            public void sortChanged(TableView tableView) {
                TableView.SortDictionary sortDictionary = tableView.getSort();
                if (!sortDictionary.isEmpty()) {
                    Dictionary.Pair pair = tableView.getSort().get(0);
                    List list = tableView.getTableData();
                    list.setComparator((Comparator)new FileComparator((String)pair.key, (SortDirection)pair.value));
                }
            }
        });
        this.fileTableView.getComponentMouseButtonListeners().add((Object)new ComponentMouseButtonListener.Adapter(){
            private int index = -1;

            public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
                File file;
                int n4;
                boolean bl = super.mouseClick(component, button, n, n2, n3);
                if (n3 == 1) {
                    this.index = TerraFileBrowserSkin.this.fileTableView.getRowAt(n2);
                } else if (n3 == 2 && (n4 = TerraFileBrowserSkin.this.fileTableView.getRowAt(n2)) != -1 && n4 == this.index && TerraFileBrowserSkin.this.fileTableView.isRowSelected(n4) && (file = (File)TerraFileBrowserSkin.this.files.get(n4)).isDirectory()) {
                    fileBrowser.setRootDirectory(file);
                    bl = true;
                }
                return bl;
            }
        });
        this.files.getListListeners().add((Object)new ListListener.Adapter<File>(){

            public void comparatorChanged(List<File> list, Comparator<File> comparator) {
                fileBrowser.clearSelection();
            }
        });
        this.files.getFilteredListListeners().add((Object)new FilteredListListener.Adapter<File>(){

            public void filterChanged(FilteredList<File> filteredList, Filter<File> filter) {
                fileBrowser.clearSelection();
            }
        });
        this.fileTableView.setTableData(this.files);
        fileBrowser.setFocusTraversalPolicy((FocusTraversalPolicy)new ContainerSkin.IndexFocusTraversalPolicy(){

            public Component getNextComponent(Container container, Component component, Direction direction) {
                Object object = component == null ? TerraFileBrowserSkin.this.fileTableView : super.getNextComponent(container, component, direction);
                return object;
            }
        });
        this.fileTableView.setSort("name", SortDirection.ASCENDING);
        this.rootDirectoryChanged(fileBrowser, null);
        this.selectedFilesChanged(fileBrowser, null);
    }

    public int getPreferredWidth(int n) {
        return this.content.getPreferredWidth(n);
    }

    public int getPreferredHeight(int n) {
        return this.content.getPreferredHeight(n);
    }

    public Dimensions getPreferredSize() {
        return this.content.getPreferredSize();
    }

    public void layout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.content.setLocation(0, 0);
        this.content.setSize(n, n2);
    }

    public File getFileAt(int n, int n2) {
        File file = null;
        FileBrowser fileBrowser = (FileBrowser)this.getComponent();
        Component component = fileBrowser.getDescendantAt(n, n2);
        if (component == this.fileTableView) {
            Point point = this.fileTableView.mapPointFromAncestor((Container)fileBrowser, n, n2);
            int n3 = this.fileTableView.getRowAt(point.y);
            if (n3 != -1) {
                file = (File)this.files.get(n3);
            }
        }
        return file;
    }

    public boolean isKeyboardFolderTraversalEnabled() {
        return this.keyboardFolderTraversalEnabled;
    }

    public void setKeyboardFolderTraversalEnabled(boolean bl) {
        this.keyboardFolderTraversalEnabled = bl;
    }

    public boolean isHideDisabledFiles() {
        return this.hideDisabledFiles;
    }

    public void setHideDisabledFiles(boolean bl) {
        this.hideDisabledFiles = bl;
        String string = this.searchTextInput.getText().trim();
        if (string.length() == 0) {
            string = null;
        }
        Filter filter = null;
        if (bl) {
            FileBrowser fileBrowser = (FileBrowser)this.getComponent();
            filter = fileBrowser.getDisabledFileFilter();
        }
        this.files.setFilter((Filter)new IncludeFileFilter(string, (Filter<File>)filter));
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyPressed(component, n, keyLocation);
        FileBrowser fileBrowser = (FileBrowser)this.getComponent();
        if (n == 10 && this.keyboardFolderTraversalEnabled) {
            File file;
            Sequence sequence = fileBrowser.getSelectedFiles();
            if (sequence.getLength() == 1 && (file = (File)sequence.get(0)).isDirectory()) {
                fileBrowser.setRootDirectory(file);
                bl = true;
            }
        } else if (n == 127 || n == 8) {
            File file = fileBrowser.getRootDirectory();
            File file2 = file.getParentFile();
            if (file2 != null) {
                fileBrowser.setRootDirectory(file2);
                bl = true;
            }
        } else if (n == 116) {
            this.refreshFileList();
            bl = true;
        }
        return bl;
    }

    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyReleased(component, n, keyLocation);
        Keyboard.Modifier modifier = Platform.getCommandModifier();
        if (n == 70 && Keyboard.isPressed((Keyboard.Modifier)modifier)) {
            this.searchTextInput.requestFocus();
            bl = true;
        }
        return bl;
    }

    public void rootDirectoryChanged(FileBrowser fileBrowser, File file) {
        File file2;
        ArrayList arrayList = new ArrayList();
        File file3 = fileBrowser.getRootDirectory();
        for (File file4 = file3.getParentFile(); file4 != null; file4 = file4.getParentFile()) {
            arrayList.add((Object)file4);
        }
        File[] fileArray = File.listRoots();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < fileArray.length; ++i) {
            file2 = fileArray[i];
            if (!file2.isDirectory()) continue;
            arrayList2.add((Object)file2);
        }
        this.driveListButton.setListData((List)arrayList2);
        this.driveListButton.setVisible(arrayList2.getLength() > 1);
        File file5 = arrayList.getLength() == 0 ? file3 : (File)arrayList.get(arrayList.getLength() - 1);
        this.driveListButton.setSelectedItem((Object)file5);
        this.pathListButton.setListData((List)arrayList);
        this.pathListButton.setButtonData((Object)file3);
        this.pathListButton.setEnabled(file3.getParentFile() != null);
        this.goUpButton.setEnabled(this.pathListButton.isEnabled());
        file2 = new File(System.getProperty("user.home"));
        this.goHomeButton.setEnabled(!file3.equals(file2));
        this.searchTextInput.setText("");
        this.fileScrollPane.setScrollTop(0);
        this.fileScrollPane.setScrollLeft(0);
        this.refreshFileList();
        this.fileTableView.requestFocus();
    }

    public void selectedFileAdded(FileBrowser fileBrowser, File file) {
        int n;
        if (!this.updatingSelection && (n = this.files.indexOf((Object)file)) != -1) {
            this.fileTableView.addSelectedIndex(n);
        }
    }

    public void selectedFileRemoved(FileBrowser fileBrowser, File file) {
        int n;
        if (!this.updatingSelection && (n = this.files.indexOf((Object)file)) != -1) {
            this.fileTableView.removeSelectedIndex(n);
        }
    }

    public void selectedFilesChanged(FileBrowser fileBrowser, Sequence<File> sequence) {
        if (!this.updatingSelection) {
            Sequence sequence2 = fileBrowser.getSelectedFiles();
            ArrayList arrayList = new ArrayList();
            int n = sequence2.getLength();
            for (int i = 0; i < n; ++i) {
                File file = (File)sequence2.get(i);
                int n2 = this.files.indexOf((Object)file);
                if (n2 == -1) continue;
                arrayList.add((Object)new Span(n2, n2));
            }
            this.fileTableView.setSelectedRanges((Sequence)arrayList);
        }
    }

    public void multiSelectChanged(FileBrowser fileBrowser) {
        this.fileTableView.setSelectMode(fileBrowser.isMultiSelect() ? TableView.SelectMode.MULTI : TableView.SelectMode.SINGLE);
    }

    public void disabledFileFilterChanged(FileBrowser fileBrowser, Filter<File> filter) {
        Filter filter2 = fileBrowser.getDisabledFileFilter();
        this.fileTableView.setDisabledRowFilter(filter2);
        if (this.hideDisabledFiles) {
            String string = this.searchTextInput.getText().trim();
            if (string.length() == 0) {
                string = null;
            }
            this.files.setFilter((Filter)new IncludeFileFilter(string, (Filter<File>)filter2));
        }
    }

    private void refreshFileList() {
        FileBrowser fileBrowser = (FileBrowser)this.getComponent();
        File file = fileBrowser.getRootDirectory();
        this.files.setSource((List)new ArrayList((Object[])file.listFiles(HIDDEN_FILE_FILTER)));
    }

    public static class IncludeFileFilter
    implements Filter<File> {
        private String match;
        private Filter<File> excludeFileFilter;

        public IncludeFileFilter() {
            this(null, null);
        }

        public IncludeFileFilter(String string, Filter<File> filter) {
            this.match = string == null ? null : string.toLowerCase();
            this.excludeFileFilter = filter;
        }

        public boolean include(File file) {
            String string = file.getName();
            string = string.toLowerCase();
            boolean bl = true;
            if (this.match != null) {
                bl = this.match.startsWith("*") ? (this.match.length() == 1 ? true : string.contains(this.match.substring(1))) : string.startsWith(this.match);
            }
            if (bl && this.excludeFileFilter != null) {
                bl = !this.excludeFileFilter.include((Object)file);
            }
            return bl;
        }
    }

    public static class FileComparator
    implements Comparator<File> {
        private String columnName = null;
        private SortDirection sortDirection = null;

        public FileComparator(String string, SortDirection sortDirection) {
            this.columnName = string;
            this.sortDirection = sortDirection;
        }

        @Override
        public int compare(File file, File file2) {
            int n;
            if (this.columnName.equals("name")) {
                boolean bl = file.isDirectory();
                boolean bl2 = file2.isDirectory();
                n = bl && !bl2 ? -1 : (!bl && bl2 ? 1 : file.getName().compareToIgnoreCase(file2.getName()));
            } else if (this.columnName.equals("size")) {
                n = Long.signum(file.length() - file2.length());
            } else if (this.columnName.equals("lastModified")) {
                n = Long.signum(file.lastModified() - file2.lastModified());
            } else {
                throw new IllegalArgumentException();
            }
            return n *= this.sortDirection == SortDirection.ASCENDING ? 1 : -1;
        }
    }

    public static class ListViewDriveRenderer
    extends DriveRenderer
    implements ListView.ItemRenderer {
        public ListViewDriveRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
            this.getStyles().put("padding", (Object)new Insets(2, 3, 2, 3));
        }

        public void render(Object object, int n, ListView listView, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.label.getStyles().put("font", listView.getStyles().get("font"));
            Object object2 = null;
            object2 = listView.isEnabled() && !bl4 ? (bl ? (listView.isFocused() ? listView.getStyles().get("selectionColor") : listView.getStyles().get("inactiveSelectionColor")) : listView.getStyles().get("color")) : listView.getStyles().get("disabledColor");
            this.label.getStyles().put("color", object2);
            if (object != null) {
                File file = (File)object;
                this.imageView.setImage(DRIVE_IMAGE);
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(listView.isEnabled() && !bl4 ? 1.0f : 0.5f));
                this.label.setText(file.toString());
            }
        }
    }

    public static class ListButtonDriveRenderer
    extends DriveRenderer
    implements Button.DataRenderer {
        public ListButtonDriveRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        }

        public void render(Object object, Button button, boolean bl) {
            if (object != null) {
                File file = (File)object;
                this.imageView.setImage(DRIVE_IMAGE);
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
                this.label.setText(file.toString());
            }
        }
    }

    public static abstract class DriveRenderer
    extends BoxPane {
        protected ImageView imageView = new ImageView();
        protected Label label = new Label();
        public static final int ICON_WIDTH = 16;
        public static final int ICON_HEIGHT = 16;
        public static final Image DRIVE_IMAGE;

        public DriveRenderer() {
            this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
            this.add((Component)this.imageView);
            this.add((Component)this.label);
            this.imageView.setPreferredSize(16, 16);
            this.imageView.getStyles().put("backgroundColor", null);
        }

        public void setSize(int n, int n2) {
            super.setSize(n, n2);
            this.validate();
        }

        static {
            try {
                DRIVE_IMAGE = Image.load((URL)FileRenderer.class.getResource("drive.png"));
            }
            catch (TaskExecutionException taskExecutionException) {
                throw new RuntimeException(taskExecutionException);
            }
        }
    }

    public static class TableViewFileRenderer
    extends FileRenderer
    implements TableView.CellRenderer {
        public static final String NAME_KEY = "name";
        public static final String SIZE_KEY = "size";
        public static final String LAST_MODIFIED_KEY = "lastModified";

        public TableViewFileRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
            this.getStyles().put("padding", (Object)new Insets(2));
        }

        public void render(Object object, int n, int n2, TableView tableView, String string, boolean bl, boolean bl2, boolean bl3) {
            Object object2;
            Serializable serializable;
            if (object != null) {
                serializable = (File)object;
                object2 = null;
                Image image = null;
                if (string.equals(NAME_KEY)) {
                    object2 = ((File)serializable).getName();
                    image = TableViewFileRenderer.getIcon((File)serializable);
                    this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
                } else if (string.equals(SIZE_KEY)) {
                    long l = ((File)serializable).length();
                    object2 = FileSizeFormat.getInstance().format((Object)l);
                    this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
                } else if (string.equals(LAST_MODIFIED_KEY)) {
                    long l = ((File)serializable).lastModified();
                    Date date = new Date(l);
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                    object2 = dateFormat.format(date);
                    this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
                } else {
                    System.err.println("Unexpected column name in " + ((Object)((Object)this)).getClass().getName() + ": " + string);
                }
                this.label.setText((String)object2);
                this.imageView.setImage(image);
            }
            serializable = (Font)tableView.getStyles().get("font");
            this.label.getStyles().put("font", (Object)serializable);
            object2 = tableView.isEnabled() && !bl3 ? (bl ? (tableView.isFocused() ? (Color)tableView.getStyles().get("selectionColor") : (Color)tableView.getStyles().get("inactiveSelectionColor")) : (Color)tableView.getStyles().get("color")) : (Color)tableView.getStyles().get("disabledColor");
            this.label.getStyles().put("color", object2);
        }
    }

    public static class ListViewFileRenderer
    extends FileRenderer
    implements ListView.ItemRenderer {
        public ListViewFileRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
            this.getStyles().put("padding", (Object)new Insets(2, 3, 2, 3));
        }

        public void render(Object object, int n, ListView listView, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.label.getStyles().put("font", listView.getStyles().get("font"));
            Object object2 = null;
            object2 = listView.isEnabled() && !bl4 ? (bl ? (listView.isFocused() ? listView.getStyles().get("selectionColor") : listView.getStyles().get("inactiveSelectionColor")) : listView.getStyles().get("color")) : listView.getStyles().get("disabledColor");
            this.label.getStyles().put("color", object2);
            if (object != null) {
                File file = (File)object;
                this.imageView.setImage(ListViewFileRenderer.getIcon(file));
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(listView.isEnabled() && !bl4 ? 1.0f : 0.5f));
                String string = file.getName();
                if (string.length() == 0) {
                    string = System.getProperty("file.separator");
                }
                this.label.setText(string);
            }
        }
    }

    public static class ListButtonFileRenderer
    extends FileRenderer
    implements Button.DataRenderer {
        public ListButtonFileRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        }

        public void render(Object object, Button button, boolean bl) {
            if (object != null) {
                File file = (File)object;
                this.imageView.setImage(ListButtonFileRenderer.getIcon(file));
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
                String string = file.getName();
                if (string.length() == 0) {
                    string = System.getProperty("file.separator");
                }
                this.label.setText(string);
            }
        }
    }

    public static abstract class FileRenderer
    extends BoxPane {
        protected ImageView imageView = new ImageView();
        protected Label label = new Label();
        public static final int ICON_WIDTH = 16;
        public static final int ICON_HEIGHT = 16;
        public static final Image FOLDER_IMAGE;
        public static final Image HOME_FOLDER_IMAGE;
        public static final Image FILE_IMAGE;
        public static final File HOME_DIRECTORY;

        public FileRenderer() {
            this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
            this.add((Component)this.imageView);
            this.add((Component)this.label);
            this.imageView.setPreferredSize(16, 16);
            this.imageView.getStyles().put("backgroundColor", null);
        }

        public void setSize(int n, int n2) {
            super.setSize(n, n2);
            this.validate();
        }

        public static Image getIcon(File file) {
            Image image = file.isDirectory() ? (file.equals(HOME_DIRECTORY) ? HOME_FOLDER_IMAGE : FOLDER_IMAGE) : FILE_IMAGE;
            return image;
        }

        static {
            try {
                FOLDER_IMAGE = Image.load((URL)FileRenderer.class.getResource("folder.png"));
                HOME_FOLDER_IMAGE = Image.load((URL)FileRenderer.class.getResource("folder_home.png"));
                FILE_IMAGE = Image.load((URL)FileRenderer.class.getResource("page_white.png"));
                HOME_DIRECTORY = new File(System.getProperty("user.home"));
            }
            catch (TaskExecutionException taskExecutionException) {
                throw new RuntimeException(taskExecutionException);
            }
        }
    }
}

