/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Frame;
import org.apache.pivot.wtk.FrameListener;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.TerraPushButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraFrameSkin
extends WindowSkin
implements FrameListener {
    private Image minimizeImage = new MinimizeImage();
    private Image maximizeImage = new MaximizeImage();
    private Image restoreImage = new RestoreImage();
    private Image closeImage = new CloseImage();
    private Image resizeImage = new ResizeImage();
    private TablePane titleBarTablePane = new TablePane();
    private BoxPane titleBoxPane = new BoxPane();
    private BoxPane buttonBoxPane = new BoxPane();
    private ImageView iconImageView = new ImageView();
    private Label titleLabel = new Label();
    private FrameButton minimizeButton = null;
    private FrameButton maximizeButton = null;
    private FrameButton closeButton = null;
    private ImageView resizeHandle = new ImageView(this.resizeImage);
    private DropShadowDecorator dropShadowDecorator = null;
    private Point dragOffset = null;
    private Point resizeOffset = null;
    private Color titleBarColor;
    private Color titleBarBackgroundColor;
    private Color titleBarBorderColor;
    private Color inactiveTitleBarColor;
    private Color inactiveTitleBarBackgroundColor;
    private Color inactiveTitleBarBorderColor;
    private Color contentBorderColor;
    private Insets padding;
    private boolean resizable;
    private Color titleBarBevelColor;
    private Color inactiveTitleBarBevelColor;
    private Color contentBevelColor;
    private static final float INACTIVE_ICON_OPACITY = 0.5f;

    public TerraFrameSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(10));
        this.titleBarColor = terraTheme.getColor(4);
        this.titleBarBackgroundColor = terraTheme.getColor(16);
        this.titleBarBorderColor = terraTheme.getColor(13);
        this.inactiveTitleBarColor = terraTheme.getColor(7);
        this.inactiveTitleBarBackgroundColor = terraTheme.getColor(9);
        this.inactiveTitleBarBorderColor = terraTheme.getColor(7);
        this.contentBorderColor = terraTheme.getColor(7);
        this.padding = new Insets(8);
        this.resizable = true;
        this.titleBarBevelColor = TerraTheme.brighten(this.titleBarBackgroundColor);
        this.inactiveTitleBarBevelColor = TerraTheme.brighten(this.inactiveTitleBarBackgroundColor);
        this.titleBarTablePane.getColumns().add(new TablePane.Column(1, true));
        this.titleBarTablePane.getColumns().add(new TablePane.Column(-1));
        TablePane.Row row = new TablePane.Row(-1);
        this.titleBarTablePane.getRows().add(row);
        row.add((Component)this.titleBoxPane);
        row.add((Component)this.buttonBoxPane);
        this.titleBarTablePane.getStyles().put("padding", (Object)new Insets(2));
        this.titleBoxPane.add((Component)this.iconImageView);
        this.titleBoxPane.add((Component)this.titleLabel);
        this.titleBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.titleBoxPane.getStyles().put("padding", (Object)new Insets(0, 0, 0, 2));
        Font font = terraTheme.getFont().deriveFont(1);
        this.titleLabel.getStyles().put("font", (Object)font);
        this.iconImageView.setPreferredSize(16, 16);
        this.iconImageView.getStyles().put("fill", (Object)true);
        this.iconImageView.getStyles().put("backgroundColor", null);
        this.buttonBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
        this.buttonBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
    }

    public void install(Component component) {
        super.install(component);
        Frame frame = (Frame)this.getComponent();
        this.dropShadowDecorator = new DropShadowDecorator();
        frame.getDecorators().add((Decorator)this.dropShadowDecorator);
        frame.add((Component)this.titleBarTablePane);
        this.minimizeButton = new FrameButton(this.minimizeImage);
        this.maximizeButton = new FrameButton(this.maximizeImage);
        this.closeButton = new FrameButton(this.closeImage);
        this.buttonBoxPane.add((Component)this.minimizeButton);
        this.buttonBoxPane.add((Component)this.maximizeButton);
        this.buttonBoxPane.add((Component)this.closeButton);
        ButtonPressListener buttonPressListener = new ButtonPressListener(){

            public void buttonPressed(Button button) {
                Frame frame = (Frame)TerraFrameSkin.this.getComponent();
                if (button == TerraFrameSkin.this.minimizeButton) {
                    frame.setVisible(false);
                } else if (button == TerraFrameSkin.this.maximizeButton) {
                    frame.moveToFront();
                    frame.setMaximized(!frame.isMaximized());
                } else if (button == TerraFrameSkin.this.closeButton) {
                    frame.close();
                }
            }
        };
        this.minimizeButton.getButtonPressListeners().add((Object)buttonPressListener);
        this.maximizeButton.getButtonPressListeners().add((Object)buttonPressListener);
        this.closeButton.getButtonPressListeners().add((Object)buttonPressListener);
        frame.add((Component)this.resizeHandle);
        this.iconChanged((Window)frame, null);
        this.titleChanged((Window)frame, null);
        this.activeChanged((Window)frame, null);
        this.maximizedChanged((Window)frame);
        this.setShowMinimizeButton(false);
    }

    public int getPreferredWidth(int n) {
        Dimensions dimensions;
        MenuBar menuBar;
        int n2 = 0;
        Frame frame = (Frame)this.getComponent();
        Dimensions dimensions2 = this.titleBarTablePane.getPreferredSize();
        n2 = Math.max(dimensions2.width + 2, n2);
        if (n != -1) {
            n -= dimensions2.height + 2;
        }
        if ((menuBar = frame.getMenuBar()) != null) {
            dimensions = menuBar.getPreferredSize();
            n2 = Math.max(n2, dimensions.width);
            if (n != -1) {
                n -= dimensions.height;
            }
        }
        if ((dimensions = frame.getContent()) != null) {
            if (n != -1) {
                n -= this.padding.top + this.padding.bottom + 3;
                n = Math.max(n, 0);
            }
            n2 = Math.max(n2, dimensions.getPreferredWidth(n));
        }
        return n2 += this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int n) {
        Component component;
        int n2 = 0;
        Frame frame = (Frame)this.getComponent();
        n2 += this.titleBarTablePane.getPreferredHeight() + 2;
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar != null) {
            n2 += menuBar.getPreferredHeight();
        }
        if ((component = frame.getContent()) != null) {
            if (n != -1) {
                n -= this.padding.left + this.padding.right + 2;
                n = Math.max(n, 0);
            }
            n2 += component.getPreferredHeight(n);
        }
        return n2 += this.padding.top + this.padding.bottom + 3;
    }

    public Dimensions getPreferredSize() {
        Dimensions dimensions;
        int n = 0;
        int n2 = 0;
        Frame frame = (Frame)this.getComponent();
        Dimensions dimensions2 = this.titleBarTablePane.getPreferredSize();
        n = Math.max(n, dimensions2.width + 2);
        n2 += dimensions2.height + 2;
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar != null) {
            dimensions = menuBar.getPreferredSize();
            n = Math.max(n, dimensions.width);
            n2 += dimensions.height;
        }
        if ((dimensions = frame.getContent()) != null) {
            Dimensions dimensions3 = dimensions.getPreferredSize();
            n = Math.max(n, dimensions3.width);
            n2 += dimensions3.height;
        }
        return new Dimensions(n += this.padding.left + this.padding.right + 2, n2 += this.padding.top + this.padding.bottom + 3);
    }

    public void layout() {
        Frame frame = (Frame)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = frame.isMaximized();
        if (!bl || this.getShowWindowControls()) {
            Component component;
            int n3 = 1;
            int n4 = 1;
            int n5 = Math.max(n - 2, 0);
            int n6 = Math.max(n2 - 2, 0);
            this.titleBarTablePane.setLocation(n3, n4);
            this.titleBarTablePane.setSize(n5, this.titleBarTablePane.getPreferredHeight());
            this.titleBarTablePane.setVisible(true);
            n4 += this.titleBarTablePane.getHeight() + 3;
            this.resizeHandle.setSize(this.resizeHandle.getPreferredSize());
            this.resizeHandle.setLocation(n5 - this.resizeHandle.getWidth(), n6 - this.resizeHandle.getHeight());
            this.resizeHandle.setVisible(this.resizable && !bl && (frame.isPreferredWidthSet() || frame.isPreferredHeightSet()));
            MenuBar menuBar = frame.getMenuBar();
            if (menuBar != null && menuBar.isVisible()) {
                menuBar.setLocation(n3, n4);
                menuBar.setSize(n5, menuBar.getPreferredHeight());
                n4 += menuBar.getHeight();
            }
            if ((component = frame.getContent()) != null) {
                int n7 = n3 + this.padding.left;
                int n8 = n4 + this.padding.top;
                int n9 = Math.max(n5 - (this.padding.left + this.padding.right), 0);
                int n10 = Math.max(n6 - (n4 + this.padding.top + this.padding.bottom) + 1, 0);
                component.setLocation(n7, n8);
                component.setSize(n9, n10);
            }
        } else {
            Component component;
            this.titleBarTablePane.setVisible(false);
            this.resizeHandle.setVisible(false);
            int n11 = 0;
            MenuBar menuBar = frame.getMenuBar();
            if (menuBar != null && menuBar.isVisible()) {
                menuBar.setLocation(0, n11);
                menuBar.setSize(n, menuBar.getPreferredHeight());
                n11 += menuBar.getHeight();
            }
            if ((component = frame.getContent()) != null) {
                component.setLocation(this.padding.left, n11 + this.padding.top);
                component.setSize(Math.max(n - (this.padding.left + this.padding.right), 0), Math.max(n2 - (n11 + this.padding.top + this.padding.bottom), 0));
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        Frame frame = (Frame)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = frame.isMaximized();
        if (!bl || this.getShowWindowControls()) {
            int n3 = this.titleBarTablePane.getHeight();
            Color color = frame.isActive() ? this.titleBarBackgroundColor : this.inactiveTitleBarBackgroundColor;
            Color color2 = frame.isActive() ? this.titleBarBorderColor : this.inactiveTitleBarBorderColor;
            Color color3 = frame.isActive() ? this.titleBarBevelColor : this.inactiveTitleBarBevelColor;
            graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, color3, (float)n / 2.0f, n3 + 1, color));
            graphics2D.fillRect(0, 0, n, n3 + 1);
            graphics2D.setPaint(color2);
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)(n3 + 2));
            Bounds bounds = new Bounds(0, n3 + 2, n, n2 - (n3 + 2));
            graphics2D.setPaint(this.contentBorderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height);
            graphics2D.setPaint(this.contentBevelColor);
            GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)(bounds.x + 1), (int)(bounds.y + 1), (int)(bounds.width - 2), (Orientation)Orientation.HORIZONTAL);
        }
    }

    public Bounds getClientArea() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.titleBarTablePane.getHeight();
        Frame frame = (Frame)this.getComponent();
        boolean bl = frame.isMaximized();
        Bounds bounds = bl && !this.getShowWindowControls() ? new Bounds(0, 0, n, n2) : new Bounds(0, n3 + 2, n, n2 - (n3 + 2));
        return bounds;
    }

    public void setBackgroundColor(Color color) {
        super.setBackgroundColor(color);
        this.contentBevelColor = TerraTheme.brighten(color);
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public boolean getShowMinimizeButton() {
        return this.minimizeButton.isVisible();
    }

    public void setShowMinimizeButton(boolean bl) {
        this.minimizeButton.setVisible(bl);
    }

    public boolean getShowMaximizeButton() {
        return this.maximizeButton.isVisible();
    }

    public void setShowMaximizeButton(boolean bl) {
        this.maximizeButton.setVisible(bl);
    }

    public boolean getShowCloseButton() {
        return this.closeButton.isVisible();
    }

    public void setShowCloseButton(boolean bl) {
        this.closeButton.setVisible(bl);
    }

    public boolean getShowWindowControls() {
        return this.getShowMinimizeButton() || this.getShowMaximizeButton() || this.getShowCloseButton();
    }

    public void setShowWindowControls(boolean bl) {
        this.setShowMinimizeButton(bl);
        this.setShowMaximizeButton(bl);
        this.setShowCloseButton(bl);
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean bl) {
        this.resizable = bl;
        this.invalidateComponent();
    }

    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        if (Mouse.getCapturer() == component) {
            Frame frame = (Frame)this.getComponent();
            Display display = frame.getDisplay();
            Point point = frame.mapPointToAncestor((Container)display, n, n2);
            point = new Point(Math.min(Math.max(point.x, 0), display.getWidth() - 1), Math.min(Math.max(point.y, 0), display.getHeight() - 1));
            if (this.dragOffset != null) {
                frame.setLocation(point.x - this.dragOffset.x, point.y - this.dragOffset.y);
            } else if (this.resizeOffset != null) {
                int n3 = -1;
                int n4 = -1;
                if (frame.isPreferredWidthSet()) {
                    n3 = Math.max(point.x - frame.getX() + this.resizeOffset.x, this.titleBarTablePane.getPreferredWidth(-1) + 2);
                    n3 = Math.min(n3, frame.getMaximumPreferredWidth());
                    n3 = Math.max(n3, frame.getMinimumPreferredWidth());
                }
                if (frame.isPreferredHeightSet()) {
                    n4 = Math.max(point.y - frame.getY() + this.resizeOffset.y, this.titleBarTablePane.getHeight() + this.resizeHandle.getHeight() + 7);
                    n4 = Math.min(n4, frame.getMaximumPreferredHeight());
                    n4 = Math.max(n4, frame.getMinimumPreferredHeight());
                }
                frame.setPreferredSize(n3, n4);
            }
        } else {
            Cursor cursor = null;
            if (this.resizeHandle.isVisible() && n > this.resizeHandle.getX() && n2 > this.resizeHandle.getY()) {
                boolean bl2 = component.isPreferredWidthSet();
                boolean bl3 = component.isPreferredHeightSet();
                if (bl2 && bl3) {
                    cursor = Cursor.RESIZE_SOUTH_EAST;
                } else if (bl2) {
                    cursor = Cursor.RESIZE_EAST;
                } else if (bl3) {
                    cursor = Cursor.RESIZE_SOUTH;
                }
            }
            component.setCursor(cursor);
        }
        return bl;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        Frame frame = (Frame)this.getComponent();
        boolean bl2 = frame.isMaximized();
        if (button == Mouse.Button.LEFT && !bl2) {
            Bounds bounds = this.titleBarTablePane.getBounds();
            if (bounds.contains(n, n2)) {
                this.dragOffset = new Point(n, n2);
                Mouse.capture((Component)component);
            } else {
                Bounds bounds2 = this.resizeHandle.getBounds();
                if (bounds2.contains(n, n2)) {
                    this.resizeOffset = new Point(this.getWidth() - n, this.getHeight() - n2);
                    Mouse.capture((Component)component);
                }
            }
        }
        return bl;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        if (Mouse.getCapturer() == component) {
            this.dragOffset = null;
            this.resizeOffset = null;
            Mouse.release();
        }
        return bl;
    }

    public void titleChanged(Window window, String string) {
        String string2 = window.getTitle();
        this.titleLabel.setVisible(string2 != null);
        this.titleLabel.setText(string2);
    }

    public void iconChanged(Window window, Image image) {
        Image image2 = window.getIcon();
        this.iconImageView.setVisible(image2 != null);
        this.iconImageView.setImage(image2);
    }

    public void activeChanged(Window window, Window window2) {
        boolean bl = window.isActive();
        this.titleLabel.getStyles().put("color", (Object)(bl ? this.titleBarColor : this.inactiveTitleBarColor));
        this.iconImageView.getStyles().put("opacity", (Object)Float.valueOf(bl ? 1.0f : 0.5f));
        this.updateButtonStyles(this.minimizeButton, bl);
        this.updateButtonStyles(this.maximizeButton, bl);
        this.updateButtonStyles(this.closeButton, bl);
        this.repaintComponent();
    }

    public void maximizedChanged(Window window) {
        super.maximizedChanged(window);
        this.maximizeButton.setButtonData(window.isMaximized() ? this.restoreImage : this.maximizeImage);
    }

    public void menuBarChanged(Frame frame, MenuBar menuBar) {
        this.invalidateComponent();
    }

    private void updateButtonStyles(FrameButton frameButton, boolean bl) {
        frameButton.getStyles().put("color", (Object)(bl ? this.titleBarColor : this.inactiveTitleBarColor));
        frameButton.getStyles().put("backgroundColor", (Object)(bl ? this.titleBarBackgroundColor : this.inactiveTitleBarBackgroundColor));
        frameButton.getStyles().put("borderColor", (Object)(bl ? this.titleBarBorderColor : this.inactiveTitleBarBorderColor));
    }

    protected class ResizeImage
    extends Image {
        public static final int ALPHA = 64;

        protected ResizeImage() {
        }

        public int getWidth() {
            return 5;
        }

        public int getHeight() {
            return 5;
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setPaint(new Color(0, 0, 0, 64));
            graphics2D.fillRect(3, 0, 2, 1);
            graphics2D.fillRect(0, 3, 2, 1);
            graphics2D.fillRect(3, 3, 2, 1);
            graphics2D.setPaint(new Color(TerraFrameSkin.this.contentBorderColor.getRed(), TerraFrameSkin.this.contentBorderColor.getGreen(), TerraFrameSkin.this.contentBorderColor.getBlue(), 64));
            graphics2D.fillRect(3, 1, 2, 1);
            graphics2D.fillRect(0, 4, 2, 1);
            graphics2D.fillRect(3, 4, 2, 1);
        }
    }

    protected class CloseImage
    extends ButtonImage {
        protected CloseImage() {
        }

        public void paint(Graphics2D graphics2D) {
            Frame frame = (Frame)TerraFrameSkin.this.getComponent();
            graphics2D.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarColor : TerraFrameSkin.this.inactiveTitleBarColor);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.draw(new Line2D.Double(0.5, 0.5, 7.5, 7.5));
            graphics2D.draw(new Line2D.Double(0.5, 7.5, 7.5, 0.5));
        }
    }

    protected class RestoreImage
    extends ButtonImage {
        protected RestoreImage() {
        }

        public void paint(Graphics2D graphics2D) {
            Frame frame = (Frame)TerraFrameSkin.this.getComponent();
            graphics2D.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarColor : TerraFrameSkin.this.inactiveTitleBarColor);
            graphics2D.fillRect(1, 1, 6, 6);
            graphics2D.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarBackgroundColor : TerraFrameSkin.this.inactiveTitleBarBackgroundColor);
            graphics2D.fillRect(3, 3, 2, 2);
        }
    }

    protected class MaximizeImage
    extends ButtonImage {
        protected MaximizeImage() {
        }

        public void paint(Graphics2D graphics2D) {
            Frame frame = (Frame)TerraFrameSkin.this.getComponent();
            graphics2D.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarColor : TerraFrameSkin.this.inactiveTitleBarColor);
            graphics2D.fillRect(0, 0, 8, 8);
            graphics2D.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarBackgroundColor : TerraFrameSkin.this.inactiveTitleBarBackgroundColor);
            graphics2D.fillRect(2, 2, 4, 4);
        }
    }

    protected class MinimizeImage
    extends ButtonImage {
        protected MinimizeImage() {
        }

        public void paint(Graphics2D graphics2D) {
            Frame frame = (Frame)TerraFrameSkin.this.getComponent();
            graphics2D.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarColor : TerraFrameSkin.this.inactiveTitleBarColor);
            graphics2D.fillRect(0, 6, 8, 2);
        }
    }

    protected abstract class ButtonImage
    extends Image {
        protected ButtonImage() {
        }

        public int getWidth() {
            return 8;
        }

        public int getHeight() {
            return 8;
        }
    }

    public static class FrameButtonSkin
    extends TerraPushButtonSkin {
        public FrameButtonSkin() {
            this.setPadding(3);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            super.mouseDown(component, button, n, n2);
            return true;
        }
    }

    public static class FrameButton
    extends PushButton {
        public FrameButton(Object object) {
            super(object);
            this.installThemeSkin(FrameButton.class);
        }
    }
}

