/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.skin.MenuBarItemSkin;

public class TerraMenuBarItemSkin
extends MenuBarItemSkin {
    public void install(Component component) {
        super.install(component);
        MenuBar.Item item = (MenuBar.Item)component;
        item.setCursor(Cursor.DEFAULT);
    }

    public int getPreferredWidth(int n) {
        MenuBar.Item item = (MenuBar.Item)this.getComponent();
        Button.DataRenderer dataRenderer = item.getDataRenderer();
        dataRenderer.render(item.getButtonData(), (Button)item, false);
        return dataRenderer.getPreferredWidth(n);
    }

    public int getPreferredHeight(int n) {
        MenuBar.Item item = (MenuBar.Item)this.getComponent();
        Button.DataRenderer dataRenderer = item.getDataRenderer();
        dataRenderer.render(item.getButtonData(), (Button)item, false);
        return dataRenderer.getPreferredHeight(n);
    }

    public Dimensions getPreferredSize() {
        MenuBar.Item item = (MenuBar.Item)this.getComponent();
        Button.DataRenderer dataRenderer = item.getDataRenderer();
        dataRenderer.render(item.getButtonData(), (Button)item, false);
        return dataRenderer.getPreferredSize();
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics2D) {
        Button.DataRenderer dataRenderer;
        MenuBar.Item item = (MenuBar.Item)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = item.isActive();
        if (bl) {
            dataRenderer = (MenuBar)item.getParent();
            Color color = (Color)dataRenderer.getStyles().get("activeBackgroundColor");
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, n, n2);
        }
        dataRenderer = item.getDataRenderer();
        dataRenderer.render(item.getButtonData(), (Button)item, bl);
        dataRenderer.setSize(n, n2);
        dataRenderer.paint(graphics2D);
    }

    public boolean isOpaque() {
        boolean bl = false;
        MenuBar.Item item = (MenuBar.Item)this.getComponent();
        if (item.isActive()) {
            MenuBar menuBar = (MenuBar)item.getParent();
            Color color = (Color)menuBar.getStyles().get("activeBackgroundColor");
            bl = color.getTransparency() == 1;
        }
        return bl;
    }

    public Color getPopupBorderColor() {
        return (Color)this.menuPopup.getStyles().get("borderColor");
    }

    public void setPopupBorderColor(Color color) {
        this.menuPopup.getStyles().put("borderColor", (Object)color);
    }

    public void setPopupBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("popupBorderColor is null.");
        }
        this.menuPopup.getStyles().put("borderColor", (Object)string);
    }
}

