/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.MenuBarListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuBarSkin
extends ContainerSkin
implements MenuBarListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color activeColor;
    private Color activeBackgroundColor;
    private int spacing;

    public TerraMenuBarSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont().deriveFont(1);
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.activeColor = terraTheme.getColor(4);
        this.activeBackgroundColor = terraTheme.getColor(20);
        this.spacing = 2;
    }

    public void install(Component component) {
        super.install(component);
        MenuBar menuBar = (MenuBar)component;
        menuBar.getMenuBarListeners().add((Object)this);
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        MenuBar menuBar = (MenuBar)this.getComponent();
        MenuBar.ItemSequence itemSequence = menuBar.getItems();
        int n3 = 0;
        int n4 = itemSequence.getLength();
        for (int i = 0; i < n4; ++i) {
            MenuBar.Item item;
            if (n3 > 0) {
                n2 += this.spacing;
            }
            if (!(item = itemSequence.get(i)).isVisible()) continue;
            n2 += item.getPreferredWidth(n);
            ++n3;
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        MenuBar menuBar = (MenuBar)this.getComponent();
        MenuBar.ItemSequence itemSequence = menuBar.getItems();
        int n3 = itemSequence.getLength();
        for (int i = 0; i < n3; ++i) {
            MenuBar.Item item = itemSequence.get(i);
            if (!item.isVisible()) continue;
            n2 = Math.max(item.getPreferredHeight(n), n2);
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        int n = 0;
        int n2 = 0;
        MenuBar menuBar = (MenuBar)this.getComponent();
        MenuBar.ItemSequence itemSequence = menuBar.getItems();
        int n3 = 0;
        int n4 = itemSequence.getLength();
        for (int i = 0; i < n4; ++i) {
            MenuBar.Item item;
            if (n3 > 0) {
                n += this.spacing;
            }
            if (!(item = itemSequence.get(i)).isVisible()) continue;
            n += item.getPreferredWidth(-1);
            n2 = Math.max(item.getPreferredHeight(-1), n2);
        }
        return new Dimensions(n, n2);
    }

    public void layout() {
        MenuBar menuBar = (MenuBar)this.getComponent();
        int n = this.getHeight();
        int n2 = 0;
        for (MenuBar.Item item : menuBar.getItems()) {
            if (!item.isVisible()) continue;
            item.setSize(item.getPreferredWidth(n), n);
            item.setLocation(n2, 0);
            n2 += item.getWidth() + this.spacing;
        }
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraMenuBarSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColor(terraTheme.getColor(n));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(terraTheme.getColor(n));
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public void setActiveColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("activeColor is null.");
        }
        this.activeColor = color;
        this.repaintComponent();
    }

    public final void setActiveColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("activeColor is null.");
        }
        this.setActiveColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setActiveColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setActiveColor(terraTheme.getColor(n));
    }

    public Color getActiveBackgroundColor() {
        return this.activeBackgroundColor;
    }

    public void setActiveBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("activeBackgroundColor is null.");
        }
        this.activeBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setActiveBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("activeBackgroundColor is null.");
        }
        this.setActiveBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setActiveBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setActiveBackgroundColor(terraTheme.getColor(n));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Spacing is negative.");
        }
        this.spacing = n;
        this.invalidateComponent();
    }

    public void itemInserted(MenuBar menuBar, int n) {
        this.invalidateComponent();
    }

    public void itemsRemoved(MenuBar menuBar, int n, Sequence<MenuBar.Item> sequence) {
        this.invalidateComponent();
    }

    public void activeItemChanged(MenuBar menuBar, MenuBar.Item item) {
    }
}

