/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.MenuButton;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.MenuButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuButtonSkin
extends MenuButtonSkin {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Insets padding;
    private int spacing;
    private boolean toolbar;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;
    private WindowStateListener menuPopupWindowStateListener = new WindowStateListener.Adapter(){

        public void windowClosed(Window window, Display display, Window window2) {
            TerraMenuButtonSkin.this.repaintComponent();
        }
    };
    private static final int TRIGGER_WIDTH = 10;

    public TerraMenuButtonSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.backgroundColor = terraTheme.getColor(10);
        this.disabledBackgroundColor = terraTheme.getColor(10);
        this.borderColor = terraTheme.getColor(7);
        this.disabledBorderColor = terraTheme.getColor(7);
        this.padding = new Insets(3);
        this.spacing = 0;
        this.toolbar = false;
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
        this.menuPopup.getWindowStateListeners().add((Object)this.menuPopupWindowStateListener);
    }

    public int getPreferredWidth(int n) {
        MenuButton menuButton = (MenuButton)this.getComponent();
        Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
        dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, false);
        int n2 = dataRenderer.getPreferredWidth(-1) + 10 + this.padding.left + this.padding.right + this.spacing + 2;
        return n2;
    }

    public int getPreferredHeight(int n) {
        MenuButton menuButton = (MenuButton)this.getComponent();
        Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
        dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, false);
        int n2 = dataRenderer.getPreferredHeight(-1) + this.padding.top + this.padding.bottom + 2;
        return n2;
    }

    public Dimensions getPreferredSize() {
        MenuButton menuButton = (MenuButton)this.getComponent();
        Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
        dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, false);
        Dimensions dimensions = dataRenderer.getPreferredSize();
        int n = dimensions.width + 10 + this.padding.left + this.padding.right + 2;
        int n2 = dimensions.height + this.padding.top + this.padding.bottom + 2;
        return new Dimensions(n, n2);
    }

    public int getBaseline(int n, int n2) {
        MenuButton menuButton = (MenuButton)this.getComponent();
        Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
        dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, false);
        int n3 = Math.max(n - (10 + this.padding.left + this.padding.right + 2), 0);
        int n4 = Math.max(n2 - (this.padding.top + this.padding.bottom + 2), 0);
        int n5 = dataRenderer.getBaseline(n3, n4);
        if (n5 != -1) {
            n5 += this.padding.top + 1;
        }
        return n5;
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics2D) {
        MenuButton menuButton = (MenuButton)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        if (!this.toolbar || this.highlighted || menuButton.isFocused() || this.menuPopup.isOpen()) {
            if (menuButton.isEnabled()) {
                color = this.backgroundColor;
                color2 = this.pressed || this.menuPopup.isOpen() ? this.pressedBevelColor : this.bevelColor;
                color3 = this.borderColor;
            } else {
                color = this.disabledBackgroundColor;
                color2 = this.disabledBevelColor;
                color3 = this.disabledBorderColor;
            }
        }
        if (color != null && color2 != null) {
            graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, color2, (float)n / 2.0f, (float)n2 / 2.0f, color));
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (color3 != null) {
            graphics2D.setPaint(color3);
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
        }
        Bounds bounds = new Bounds(this.padding.left + 1, this.padding.top + 1, Math.max(n - (this.padding.left + this.padding.right + this.spacing + 10 + 2), 0), Math.max(n2 - (this.padding.top + this.padding.bottom + 2), 0));
        Button.DataRenderer dataRenderer = menuButton.getDataRenderer();
        dataRenderer.render(menuButton.getButtonData(), (Button)menuButton, this.highlighted);
        dataRenderer.setSize(bounds.width, bounds.height);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(bounds.x, bounds.y);
        graphics2D2.clipRect(0, 0, bounds.width, bounds.height);
        dataRenderer.paint(graphics2D2);
        graphics2D2.dispose();
        Bounds bounds2 = new Bounds(Math.max(n - (this.padding.right + 10), 0), 0, 10, Math.max(n2 - (this.padding.top - this.padding.bottom), 0));
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(3.0f, 3.0f);
        generalPath.lineTo(6.0f, 0.0f);
        generalPath.closePath();
        Graphics2D graphics2D3 = (Graphics2D)graphics2D.create();
        graphics2D3.setStroke(new BasicStroke(0.0f));
        graphics2D3.setPaint(this.color);
        int n3 = bounds2.x + (bounds2.width - generalPath.getBounds().width) / 2;
        int n4 = bounds2.y + (bounds2.height - generalPath.getBounds().height) / 2;
        graphics2D3.translate(n3, n4);
        graphics2D3.draw(generalPath);
        graphics2D3.fill(generalPath);
        graphics2D3.dispose();
        if (menuButton.isFocused() && !this.toolbar) {
            BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(color3);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.draw(new Rectangle2D.Double(2.5, 2.5, Math.max(n - 5, 0), Math.max(n2 - 5, 0)));
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraMenuButtonSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = color;
        this.bevelColor = TerraTheme.brighten(color);
        this.pressedBevelColor = TerraTheme.darken(color);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = color;
        this.disabledBevelColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.menuPopup.getStyles().put("borderColor", (Object)color);
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = n;
        this.invalidateComponent();
    }

    public final void setSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(number.intValue());
    }

    public boolean isToolbar() {
        return this.toolbar;
    }

    public void setToolbar(boolean bl) {
        this.toolbar = bl;
        if (bl && this.getComponent().isFocused()) {
            Component.clearFocus();
        }
        this.repaintComponent();
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        if (this.toolbar && component.isFocused()) {
            Component.clearFocus();
        }
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        if (!this.toolbar) {
            component.requestFocus();
        }
        return super.mouseClick(component, button, n, n2, n3);
    }

    public void buttonPressed(Button button) {
        if (this.menuPopup.isOpen()) {
            this.menuPopup.close();
        } else {
            MenuButton menuButton = (MenuButton)this.getComponent();
            Window window = menuButton.getWindow();
            if (window != null) {
                int n;
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                Display display = menuButton.getDisplay();
                Point point = menuButton.mapPointToAncestor((Container)display, 0, 0);
                Dimensions dimensions = display.getSize();
                this.menuPopup.setPreferredSize(-1, -1);
                Dimensions dimensions2 = this.menuPopup.getPreferredSize();
                int n4 = Math.max(dimensions2.width, menuButton.getWidth());
                int n5 = dimensions2.height;
                int n6 = point.x;
                if (n4 > n2 && n6 + n4 > dimensions.width) {
                    n6 = point.x + n2 - n4;
                }
                if ((n = point.y + n3 - 1) + dimensions2.height > dimensions.height) {
                    if (point.y - dimensions2.height > 0) {
                        n = point.y - dimensions2.height + 1;
                    } else {
                        n5 = dimensions.height - n;
                    }
                } else {
                    n5 = -1;
                }
                this.menuPopup.setLocation(n6, n);
                this.menuPopup.setPreferredSize(n4, n5);
                this.menuPopup.open(menuButton.getWindow());
                this.menuPopup.requestFocus();
            }
        }
    }
}

