/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuSkin
extends ContainerSkin
implements MenuListener,
Menu.SectionListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color activeColor;
    private Color activeBackgroundColor;
    private Color marginColor;
    private int margin;
    private Color separatorColor;
    private int sectionSpacing;
    private boolean showKeyboardShortcuts;

    public TerraMenuSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        Color color = terraTheme.getColor(4);
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 228);
        this.setBackgroundColor(color);
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.activeColor = terraTheme.getColor(4);
        this.activeBackgroundColor = terraTheme.getColor(19);
        this.marginColor = terraTheme.getColor(11);
        this.marginColor = new Color(this.marginColor.getRed(), this.marginColor.getGreen(), this.marginColor.getBlue(), 228);
        this.margin = 20;
        this.separatorColor = terraTheme.getColor(7);
        this.sectionSpacing = 7;
        this.showKeyboardShortcuts = true;
    }

    public void install(Component component) {
        super.install(component);
        Menu menu = (Menu)component;
        menu.getMenuListeners().add((Object)this);
        for (Menu.Section section : menu.getSections()) {
            section.getSectionListeners().add((Object)this);
        }
        menu.setFocusTraversalPolicy((FocusTraversalPolicy)new ContainerSkin.IndexFocusTraversalPolicy(true));
    }

    public boolean isFocusable() {
        return true;
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        Menu menu = (Menu)this.getComponent();
        Menu.SectionSequence sectionSequence = menu.getSections();
        int n3 = sectionSequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Menu.Section section = sectionSequence.get(i);
            for (Menu.Item item : section) {
                if (!item.isVisible()) continue;
                n2 = Math.max(item.getPreferredWidth(-1), n2);
            }
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        Menu menu = (Menu)this.getComponent();
        Menu.SectionSequence sectionSequence = menu.getSections();
        int n3 = sectionSequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Menu.Section section = sectionSequence.get(i);
            for (Menu.Item item : section) {
                if (!item.isVisible()) continue;
                n2 += item.getPreferredHeight(n);
            }
            if (i <= 0) continue;
            n2 += this.sectionSpacing;
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        int n = 0;
        int n2 = 0;
        Menu menu = (Menu)this.getComponent();
        Menu.SectionSequence sectionSequence = menu.getSections();
        int n3 = sectionSequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Menu.Section section = sectionSequence.get(i);
            for (Menu.Item item : section) {
                if (!item.isVisible()) continue;
                n = Math.max(item.getPreferredWidth(), n);
                n2 += item.getPreferredHeight();
            }
            if (i <= 0) continue;
            n2 += this.sectionSpacing;
        }
        return new Dimensions(n, n2);
    }

    public void layout() {
        Menu menu = (Menu)this.getComponent();
        Menu.SectionSequence sectionSequence = menu.getSections();
        int n = this.getWidth();
        int n2 = 0;
        int n3 = sectionSequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Menu.Section section = sectionSequence.get(i);
            for (Menu.Item item : section) {
                if (!item.isVisible()) continue;
                item.setSize(n, item.getPreferredHeight(n));
                item.setLocation(0, n2);
                n2 += item.getHeight();
            }
            n2 += this.sectionSpacing;
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        Menu menu = (Menu)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.marginColor != null) {
            graphics2D.setColor(this.marginColor);
            graphics2D.fillRect(0, 0, this.margin, n2);
        }
        Menu.SectionSequence sectionSequence = menu.getSections();
        int n3 = sectionSequence.getLength();
        for (int i = 0; i < n3; ++i) {
            Menu.Section section = sectionSequence.get(i);
            if (section.getLength() <= 0) continue;
            Menu.Item item = section.get(section.getLength() - 1);
            int n4 = item.getY() + item.getHeight() + this.sectionSpacing / 2;
            graphics2D.setColor(this.separatorColor);
            graphics2D.drawLine(1, n4, n - 2, n4);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraMenuSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public void setActiveColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("activeColor is null.");
        }
        this.activeColor = color;
        this.repaintComponent();
    }

    public final void setActiveColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("activeColor is null.");
        }
        this.setActiveColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getActiveBackgroundColor() {
        return this.activeBackgroundColor;
    }

    public void setActiveBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("activeBackgroundColor is null.");
        }
        this.activeBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setActiveBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("activeBackgroundColor is null.");
        }
        this.setActiveBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getMarginColor() {
        return this.marginColor;
    }

    public void setMarginColor(Color color) {
        this.marginColor = color;
        this.repaintComponent();
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("margin is negative.");
        }
        this.margin = n;
        this.invalidateComponent();
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("separatorColor is null.");
        }
        this.separatorColor = color;
        this.repaintComponent();
    }

    public int getSectionSpacing() {
        return this.sectionSpacing;
    }

    public void setSectionSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("sectionSpacing is negative.");
        }
        this.sectionSpacing = n;
        this.invalidateComponent();
    }

    public boolean getShowKeyboardShortcuts() {
        return this.showKeyboardShortcuts;
    }

    public void setShowKeyboardShortcuts(boolean bl) {
        this.showKeyboardShortcuts = bl;
        this.invalidateComponent();
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        Menu.Item item;
        boolean bl = super.keyPressed(component, n, keyLocation);
        Menu menu = (Menu)component;
        if (n == 38) {
            menu.activatePreviousItem();
            bl = true;
        } else if (n == 40) {
            menu.activateNextItem();
            bl = true;
        } else if (n == 37) {
            if (menu.getItem() != null) {
                Window window = menu.getWindow();
                window.close();
                bl = true;
            }
        } else if (n == 39) {
            Menu.Item item2 = menu.getActiveItem();
            if (item2 != null && item2.getMenu() != null) {
                item2.press();
                bl = true;
            }
        } else if (n == 10 && (item = menu.getActiveItem()) != null && item.getMenu() == null) {
            item.press();
            bl = true;
        }
        return bl;
    }

    public boolean keyReleased(Component component, int n, Keyboard.KeyLocation keyLocation) {
        Menu.Item item;
        boolean bl = super.keyReleased(component, n, keyLocation);
        Menu menu = (Menu)component;
        if (n == 32 && (item = menu.getActiveItem()) != null && item.getMenu() == null) {
            item.press();
            bl = true;
        }
        return bl;
    }

    public void sectionInserted(Menu menu, int n) {
        Menu.Section section = menu.getSections().get(n);
        section.getSectionListeners().add((Object)this);
        this.invalidateComponent();
    }

    public void sectionsRemoved(Menu menu, int n, Sequence<Menu.Section> sequence) {
        int n2 = sequence.getLength();
        for (int i = 0; i < n2; ++i) {
            Menu.Section section = (Menu.Section)sequence.get(i);
            section.getSectionListeners().remove((Object)this);
        }
        this.invalidateComponent();
    }

    public void itemInserted(Menu.Section section, int n) {
        this.invalidateComponent();
    }

    public void itemsRemoved(Menu.Section section, int n, Sequence<Menu.Item> sequence) {
        this.invalidateComponent();
    }

    public void activeItemChanged(Menu menu, Menu.Item item) {
    }

    public void nameChanged(Menu.Section section, String string) {
    }
}

