/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Viewport;
import org.apache.pivot.wtk.ViewportListener;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraPanoramaSkin
extends ContainerSkin
implements Viewport.Skin,
ViewportListener {
    private Color buttonColor;
    private Color buttonBackgroundColor;
    private int buttonPadding;
    private boolean alwaysShowScrollButtons = false;
    private ScrollButton northButton = new ScrollButton((Object)new NorthButtonImage());
    private ScrollButton southButton = new ScrollButton((Object)new SouthButtonImage());
    private ScrollButton eastButton = new ScrollButton((Object)new EastButtonImage());
    private ScrollButton westButton = new ScrollButton((Object)new WestButtonImage());
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ButtonDataRenderer();
    private ComponentMouseListener buttonMouseListener = new ComponentMouseListener.Adapter(){

        public void mouseOver(Component component) {
            TerraPanoramaSkin.this.scrollDistance = 10.0f;
            TerraPanoramaSkin.this.scheduledScrollCallback = ApplicationContext.scheduleRecurringCallback((Runnable)TerraPanoramaSkin.this.scrollCallback, (long)50L);
        }

        public void mouseOut(Component component) {
            if (TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                TerraPanoramaSkin.this.scheduledScrollCallback = null;
            }
        }
    };
    private float scrollDistance = 0.0f;
    private ScrollCallback scrollCallback = new ScrollCallback();
    private ApplicationContext.ScheduledCallback scheduledScrollCallback = null;
    private static final int SCROLL_RATE = 50;
    private static final float INITIAL_SCROLL_DISTANCE = 10.0f;
    private static final float SCROLL_ACCELERATION = 1.06f;
    private static final float MAXIMUM_SCROLL_DISTANCE = 150.0f;
    private static final int BUTTON_SIZE = 7;

    public TerraPanoramaSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.buttonColor = terraTheme.getColor(1);
        this.buttonBackgroundColor = null;
        this.buttonPadding = 4;
    }

    public void install(Component component) {
        super.install(component);
        Panorama panorama = (Panorama)component;
        panorama.getViewportListeners().add((Object)this);
        panorama.add((Component)this.northButton);
        this.northButton.getComponentMouseListeners().add((Object)this.buttonMouseListener);
        panorama.add((Component)this.southButton);
        this.southButton.getComponentMouseListeners().add((Object)this.buttonMouseListener);
        panorama.add((Component)this.eastButton);
        this.eastButton.getComponentMouseListeners().add((Object)this.buttonMouseListener);
        panorama.add((Component)this.westButton);
        this.westButton.getComponentMouseListeners().add((Object)this.buttonMouseListener);
        this.updateScrollButtonVisibility();
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        Panorama panorama = (Panorama)this.getComponent();
        Component component = panorama.getView();
        if (component != null) {
            n2 = component.getPreferredWidth(n);
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        Panorama panorama = (Panorama)this.getComponent();
        Component component = panorama.getView();
        if (component != null) {
            n2 = component.getPreferredHeight(n);
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        Dimensions dimensions = null;
        Panorama panorama = (Panorama)this.getComponent();
        Component component = panorama.getView();
        dimensions = component == null ? new Dimensions(0, 0) : component.getPreferredSize();
        return dimensions;
    }

    public void layout() {
        Panorama panorama = (Panorama)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Component component = panorama.getView();
        if (component != null) {
            int n3;
            int n4;
            Dimensions dimensions = component.getPreferredSize();
            component.setSize(Math.max(n, dimensions.width), Math.max(n2, dimensions.height));
            int n5 = component.getWidth();
            int n6 = component.getHeight();
            int n7 = panorama.getScrollTop();
            int n8 = this.getMaxScrollTop();
            if (n7 > n8) {
                panorama.setScrollTop(n8);
                n7 = n8;
            }
            if ((n4 = panorama.getScrollLeft()) > (n3 = this.getMaxScrollLeft())) {
                panorama.setScrollLeft(n3);
                n4 = n3;
            }
            if (n < n5) {
                this.eastButton.setSize(this.eastButton.getPreferredWidth(), n2);
                this.eastButton.setLocation(n - this.eastButton.getWidth(), 0);
                this.westButton.setSize(this.westButton.getPreferredWidth(), n2);
                this.westButton.setLocation(0, 0);
            }
            if (n2 < n6) {
                this.northButton.setSize(n, this.northButton.getPreferredHeight());
                this.northButton.setLocation(0, 0);
                this.southButton.setSize(n, this.southButton.getPreferredHeight());
                this.southButton.setLocation(0, n2 - this.southButton.getHeight());
            }
        }
        this.updateScrollButtonVisibility();
    }

    public Bounds getViewportBounds() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (this.buttonBackgroundColor != null) {
            int n5;
            if (this.northButton.isVisible()) {
                n5 = this.northButton.getHeight();
                n2 += n5;
                n4 -= n5;
            }
            if (this.southButton.isVisible()) {
                n4 -= this.southButton.getHeight();
            }
            if (this.eastButton.isVisible()) {
                n3 -= this.eastButton.getWidth();
            }
            if (this.westButton.isVisible()) {
                n5 = this.westButton.getWidth();
                n += n5;
                n3 -= n5;
            }
        }
        return new Bounds(n, n2, n3, n4);
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        boolean bl = false;
        Panorama panorama = (Panorama)this.getComponent();
        Component component2 = panorama.getView();
        if (component2 != null) {
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                int n5 = panorama.getScrollLeft();
                int n6 = n5 + n * n2 * 10;
                if (n2 > 0) {
                    int n7 = this.getMaxScrollLeft();
                    n6 = Math.min(n6, n7);
                    if (n5 < n7) {
                        bl = true;
                    }
                } else {
                    n6 = Math.max(n6, 0);
                    if (n5 > 0) {
                        bl = true;
                    }
                }
                panorama.setScrollLeft(n6);
            } else {
                int n8 = panorama.getScrollTop();
                int n9 = n8 + n * n2 * 10;
                if (n2 > 0) {
                    int n10 = this.getMaxScrollTop();
                    n9 = Math.min(n9, n10);
                    if (n8 < n10) {
                        bl = true;
                    }
                } else {
                    n9 = Math.max(n9, 0);
                    if (n8 > 0) {
                        bl = true;
                    }
                }
                panorama.setScrollTop(n9);
            }
        }
        return bl;
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.buttonColor = color;
        this.repaintComponent();
    }

    public final void setButtonColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setButtonColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    public void setButtonBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null.");
        }
        this.buttonBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setButtonBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null.");
        }
        this.setButtonBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setButtonBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setButtonBackgroundColor(terraTheme.getColor(n));
    }

    public int getButtonPadding() {
        return this.buttonPadding;
    }

    public void setButtonPadding(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("buttonPadding is negative.");
        }
        this.buttonPadding = n;
        this.invalidateComponent();
    }

    public boolean getAlwaysShowScrollButtons() {
        return this.alwaysShowScrollButtons;
    }

    public void setAlwaysShowScrollButtons(boolean bl) {
        this.alwaysShowScrollButtons = bl;
        this.updateScrollButtonVisibility();
    }

    protected int getMaxScrollTop() {
        int n = 0;
        Panorama panorama = (Panorama)this.getComponent();
        int n2 = this.getHeight();
        Component component = panorama.getView();
        if (component != null) {
            n = Math.max(component.getHeight() - n2, 0);
        }
        return n;
    }

    protected int getMaxScrollLeft() {
        int n = 0;
        Panorama panorama = (Panorama)this.getComponent();
        int n2 = this.getWidth();
        Component component = panorama.getView();
        if (component != null) {
            n = Math.max(component.getWidth() - n2, 0);
        }
        return n;
    }

    protected void updateScrollButtonVisibility() {
        Panorama panorama = (Panorama)this.getComponent();
        boolean bl = panorama.isMouseOver();
        int n = panorama.getScrollTop();
        int n2 = this.getMaxScrollTop();
        this.northButton.setVisible((this.alwaysShowScrollButtons || bl) && n > 0);
        this.southButton.setVisible((this.alwaysShowScrollButtons || bl) && n < n2);
        int n3 = panorama.getScrollLeft();
        int n4 = this.getMaxScrollLeft();
        this.westButton.setVisible((this.alwaysShowScrollButtons || bl) && n3 > 0);
        this.eastButton.setVisible((this.alwaysShowScrollButtons || bl) && n3 < n4);
    }

    public void mouseOver(Component component) {
        super.mouseOver(component);
        this.updateScrollButtonVisibility();
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.updateScrollButtonVisibility();
    }

    public void scrollTopChanged(Viewport viewport, int n) {
        Component component = viewport.getView();
        if (component != null) {
            int n2 = this.getMaxScrollTop();
            int n3 = Math.min(viewport.getScrollTop(), n2);
            component.setLocation(component.getX(), -n3);
            this.updateScrollButtonVisibility();
        }
    }

    public void scrollLeftChanged(Viewport viewport, int n) {
        Component component = viewport.getView();
        if (component != null) {
            int n2 = this.getMaxScrollLeft();
            int n3 = Math.min(viewport.getScrollLeft(), n2);
            component.setLocation(-n3, component.getY());
            this.updateScrollButtonVisibility();
        }
    }

    public void viewChanged(Viewport viewport, Component component) {
        this.invalidateComponent();
    }

    private class ScrollCallback
    implements Runnable {
        private ScrollCallback() {
        }

        @Override
        public void run() {
            Panorama panorama = (Panorama)TerraPanoramaSkin.this.getComponent();
            if (TerraPanoramaSkin.this.northButton.isMouseOver()) {
                int n = Math.max(panorama.getScrollTop() - (int)TerraPanoramaSkin.this.scrollDistance, 0);
                if (n == 0 && TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                    TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                    TerraPanoramaSkin.this.scheduledScrollCallback = null;
                }
                panorama.setScrollTop(n);
            } else if (TerraPanoramaSkin.this.southButton.isMouseOver()) {
                int n = TerraPanoramaSkin.this.getMaxScrollTop();
                int n2 = Math.min(panorama.getScrollTop() + (int)TerraPanoramaSkin.this.scrollDistance, n);
                if (n2 == n && TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                    TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                    TerraPanoramaSkin.this.scheduledScrollCallback = null;
                }
                panorama.setScrollTop(n2);
            } else if (TerraPanoramaSkin.this.eastButton.isMouseOver()) {
                int n = TerraPanoramaSkin.this.getMaxScrollLeft();
                int n3 = Math.min(panorama.getScrollLeft() + (int)TerraPanoramaSkin.this.scrollDistance, n);
                if (n3 == n && TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                    TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                    TerraPanoramaSkin.this.scheduledScrollCallback = null;
                }
                panorama.setScrollLeft(n3);
            } else if (TerraPanoramaSkin.this.westButton.isMouseOver()) {
                int n = Math.max(panorama.getScrollLeft() - (int)TerraPanoramaSkin.this.scrollDistance, 0);
                if (n == 0 && TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                    TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                    TerraPanoramaSkin.this.scheduledScrollCallback = null;
                }
                panorama.setScrollLeft(n);
            }
            TerraPanoramaSkin.this.scrollDistance = Math.min(TerraPanoramaSkin.this.scrollDistance * 1.06f, 150.0f);
        }
    }

    public class ScrollButtonSkin
    extends ButtonSkin {
        public int getPreferredWidth(int n) {
            return 7 + TerraPanoramaSkin.this.buttonPadding;
        }

        public int getPreferredHeight(int n) {
            return 7 + TerraPanoramaSkin.this.buttonPadding;
        }

        public Dimensions getPreferredSize() {
            return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
        }

        public void paint(Graphics2D graphics2D) {
            ScrollButton scrollButton = (ScrollButton)this.getComponent();
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (TerraPanoramaSkin.this.buttonBackgroundColor != null) {
                graphics2D.setColor(TerraPanoramaSkin.this.buttonBackgroundColor);
                graphics2D.fillRect(0, 0, n, n2);
            }
            Button.DataRenderer dataRenderer = scrollButton.getDataRenderer();
            dataRenderer.render(scrollButton.getButtonData(), (Button)scrollButton, false);
            dataRenderer.setSize(n - TerraPanoramaSkin.this.buttonPadding * 2, n2 - TerraPanoramaSkin.this.buttonPadding * 2);
            graphics2D.translate(TerraPanoramaSkin.this.buttonPadding, TerraPanoramaSkin.this.buttonPadding);
            dataRenderer.paint(graphics2D);
        }

        public boolean isFocusable() {
            return false;
        }
    }

    protected class ScrollButton
    extends Button {
        public ScrollButton(Object object) {
            super(object);
            this.setDataRenderer(DEFAULT_DATA_RENDERER);
            this.setSkin((Skin)new ScrollButtonSkin());
        }

        public void setToggleButton(boolean bl) {
            throw new UnsupportedOperationException("Link buttons cannot be toggle buttons.");
        }
    }

    protected class WestButtonImage
    extends ScrollButtonImage {
        protected WestButtonImage() {
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            int[] nArray = new int[]{5, 1, 5};
            int[] nArray2 = new int[]{0, 3, 6};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    protected class EastButtonImage
    extends ScrollButtonImage {
        protected EastButtonImage() {
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            int[] nArray = new int[]{1, 5, 1};
            int[] nArray2 = new int[]{0, 3, 6};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    protected class SouthButtonImage
    extends ScrollButtonImage {
        protected SouthButtonImage() {
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            int[] nArray = new int[]{0, 3, 6};
            int[] nArray2 = new int[]{1, 5, 1};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    protected class NorthButtonImage
    extends ScrollButtonImage {
        protected NorthButtonImage() {
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            int[] nArray = new int[]{0, 3, 6};
            int[] nArray2 = new int[]{5, 1, 5};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    protected abstract class ScrollButtonImage
    extends Image {
        protected ScrollButtonImage() {
        }

        public int getWidth() {
            return 7;
        }

        public int getHeight() {
            return 7;
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setPaint(TerraPanoramaSkin.this.buttonColor);
        }
    }
}

