/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.PushButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraPushButtonSkin
extends PushButtonSkin {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Insets padding;
    private float minumumAspectRatio;
    private float maximumAspectRatio;
    private boolean toolbar;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;

    public TerraPushButtonSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.backgroundColor = terraTheme.getColor(10);
        this.disabledBackgroundColor = terraTheme.getColor(10);
        this.borderColor = terraTheme.getColor(7);
        this.disabledBorderColor = terraTheme.getColor(7);
        this.padding = new Insets(2, 3, 2, 3);
        this.minumumAspectRatio = Float.NaN;
        this.maximumAspectRatio = Float.NaN;
        this.toolbar = false;
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        if (n == -1) {
            n2 = this.getPreferredSize().width;
        } else {
            PushButton pushButton = (PushButton)this.getComponent();
            Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
            dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, false);
            int n3 = n;
            if (n3 != -1) {
                n3 = Math.max(n3 - (this.padding.top + this.padding.bottom + 2), 0);
            }
            n2 = dataRenderer.getPreferredWidth(n3) + this.padding.left + this.padding.right + 2;
            if (!Float.isNaN(this.minumumAspectRatio) && (float)n2 / (float)n < this.minumumAspectRatio) {
                n2 = (int)((float)n * this.minumumAspectRatio);
            }
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        if (n == -1) {
            n2 = this.getPreferredSize().height;
        } else {
            PushButton pushButton = (PushButton)this.getComponent();
            Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
            dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, false);
            int n3 = n;
            if (n3 != -1) {
                n3 = Math.max(n3 - (this.padding.left + this.padding.right + 2), 0);
            }
            n2 = dataRenderer.getPreferredHeight(n3) + this.padding.top + this.padding.bottom + 2;
            if (!Float.isNaN(this.maximumAspectRatio) && (float)n / (float)n2 > this.maximumAspectRatio) {
                n2 = (int)((float)n / this.maximumAspectRatio);
            }
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        PushButton pushButton = (PushButton)this.getComponent();
        Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
        dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, false);
        Dimensions dimensions = dataRenderer.getPreferredSize();
        int n = dimensions.width + this.padding.left + this.padding.right + 2;
        int n2 = dimensions.height + this.padding.top + this.padding.bottom + 2;
        float f = (float)n / (float)n2;
        if (!Float.isNaN(this.minumumAspectRatio) && f < this.minumumAspectRatio) {
            n = (int)((float)n2 * this.minumumAspectRatio);
        }
        if (!Float.isNaN(this.maximumAspectRatio) && f > this.maximumAspectRatio) {
            n2 = (int)((float)n / this.maximumAspectRatio);
        }
        return new Dimensions(n, n2);
    }

    public int getBaseline(int n, int n2) {
        PushButton pushButton = (PushButton)this.getComponent();
        Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
        dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, false);
        int n3 = Math.max(n - (this.padding.left + this.padding.right + 2), 0);
        int n4 = Math.max(n2 - (this.padding.top + this.padding.bottom + 2), 0);
        int n5 = dataRenderer.getBaseline(n3, n4);
        if (n5 != -1) {
            n5 += this.padding.top + 1;
        }
        return n5;
    }

    public void paint(Graphics2D graphics2D) {
        PushButton pushButton = (PushButton)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        if (!this.toolbar || this.highlighted || pushButton.isFocused()) {
            if (pushButton.isEnabled()) {
                color = this.backgroundColor;
                color2 = this.pressed || pushButton.isSelected() ? this.pressedBevelColor : this.bevelColor;
                color3 = this.borderColor;
            } else {
                color = this.disabledBackgroundColor;
                color2 = this.disabledBevelColor;
                color3 = this.disabledBorderColor;
            }
        }
        if (color != null && color2 != null) {
            graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, color2, (float)n / 2.0f, (float)n2 / 2.0f, color));
            graphics2D.fillRect(0, 0, n, n2);
        }
        if (color3 != null) {
            graphics2D.setPaint(color3);
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
        }
        Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
        dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, this.highlighted);
        dataRenderer.setSize(Math.max(n - (this.padding.left + this.padding.right + 2), 0), Math.max(this.getHeight() - (this.padding.top + this.padding.bottom + 2), 0));
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(this.padding.left + 1, this.padding.top + 1);
        graphics2D2.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(graphics2D2);
        graphics2D2.dispose();
        if (pushButton.isFocused() && !this.toolbar) {
            BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(this.borderColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.draw(new Rectangle2D.Double(2.5, 2.5, Math.max(n - 5, 0), Math.max(n2 - 5, 0)));
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraPushButtonSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColor(terraTheme.getColor(n));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(terraTheme.getColor(n));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = color;
        this.bevelColor = TerraTheme.brighten(color);
        this.pressedBevelColor = TerraTheme.darken(color);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = color;
        this.disabledBevelColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledBackgroundColor(terraTheme.getColor(n));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBorderColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(terraTheme.getColor(n));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledBorderColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledBorderColor(terraTheme.getColor(n));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public float getMinimumAspectRatio() {
        return this.minumumAspectRatio;
    }

    public void setMinimumAspectRatio(float f) {
        if (!Float.isNaN(this.maximumAspectRatio) && f > this.maximumAspectRatio) {
            throw new IllegalArgumentException("minumumAspectRatio is greater than maximumAspectRatio.");
        }
        this.minumumAspectRatio = f;
        this.invalidateComponent();
    }

    public final void setMinimumAspectRatio(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("minumumAspectRatio is null.");
        }
        this.setMinimumAspectRatio(number.floatValue());
    }

    public float getMaximumAspectRatio() {
        return this.maximumAspectRatio;
    }

    public void setMaximumAspectRatio(float f) {
        if (!Float.isNaN(this.minumumAspectRatio) && f < this.minumumAspectRatio) {
            throw new IllegalArgumentException("maximumAspectRatio is less than minimumAspectRatio.");
        }
        this.maximumAspectRatio = f;
        this.invalidateComponent();
    }

    public final void setMaximumAspectRatio(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("maximumAspectRatio is null.");
        }
        this.setMaximumAspectRatio(number.floatValue());
    }

    public boolean isToolbar() {
        return this.toolbar;
    }

    public void setToolbar(boolean bl) {
        this.toolbar = bl;
        if (bl && this.getComponent().isFocused()) {
            Component.clearFocus();
        }
        this.repaintComponent();
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        if (this.toolbar && component.isFocused()) {
            Component.clearFocus();
        }
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        if (!this.toolbar) {
            component.requestFocus();
        }
        return super.mouseClick(component, button, n, n2, n3);
    }
}

