/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.RadioButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.RadioButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraRadioButtonSkin
extends RadioButtonSkin {
    private Font font;
    private Color color;
    private Color disabledColor;
    private int spacing;
    private Color buttonColor;
    private Color buttonBorderColor;
    private Color buttonSelectionColor;
    private Color disabledButtonColor;
    private Color disabledButtonBorderColor;
    private Color disabledButtonSelectionColor;
    private static final int BUTTON_DIAMETER = 14;
    private static final int BUTTON_SELECTION_DIAMETER = 6;

    public TerraRadioButtonSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.spacing = 3;
        this.buttonColor = terraTheme.getColor(4);
        this.buttonBorderColor = terraTheme.getColor(7);
        this.buttonSelectionColor = terraTheme.getColor(13);
        this.disabledButtonColor = terraTheme.getColor(3);
        this.disabledButtonBorderColor = terraTheme.getColor(7);
        this.disabledButtonSelectionColor = terraTheme.getColor(7);
    }

    public int getPreferredWidth(int n) {
        RadioButton radioButton = (RadioButton)this.getComponent();
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        dataRenderer.render(radioButton.getButtonData(), (Button)radioButton, false);
        int n2 = 14 + dataRenderer.getPreferredWidth(n) + this.spacing * 2;
        return n2;
    }

    public int getPreferredHeight(int n) {
        RadioButton radioButton = (RadioButton)this.getComponent();
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        dataRenderer.render(radioButton.getButtonData(), (Button)radioButton, false);
        if (n != -1) {
            n = Math.max(n - (14 + this.spacing), 0);
        }
        int n2 = Math.max(14, dataRenderer.getPreferredHeight(n));
        return n2;
    }

    public Dimensions getPreferredSize() {
        RadioButton radioButton = (RadioButton)this.getComponent();
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        dataRenderer.render(radioButton.getButtonData(), (Button)radioButton, false);
        int n = 14 + dataRenderer.getPreferredWidth(-1) + this.spacing * 2;
        int n2 = Math.max(14, dataRenderer.getPreferredHeight(-1));
        return new Dimensions(n, n2);
    }

    public int getBaseline(int n, int n2) {
        RadioButton radioButton = (RadioButton)this.getComponent();
        int n3 = -1;
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        dataRenderer.render(radioButton.getButtonData(), (Button)radioButton, false);
        int n4 = Math.max(n - (14 + this.spacing), 0);
        n3 = dataRenderer.getBaseline(n4, n2);
        return n3;
    }

    public void paint(Graphics2D graphics2D) {
        RadioButton radioButton = (RadioButton)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        this.paintButton(graphics2D2, radioButton, n2);
        graphics2D2.dispose();
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        dataRenderer.render(radioButton.getButtonData(), (Button)radioButton, false);
        dataRenderer.setSize(Math.max(n - (14 + this.spacing * 2), 0), n2);
        Graphics2D graphics2D3 = (Graphics2D)graphics2D.create();
        graphics2D3.translate(14 + this.spacing, 0);
        graphics2D3.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(graphics2D3);
        graphics2D3.dispose();
        if (radioButton.isFocused()) {
            BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(this.buttonBorderColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.draw(new Rectangle2D.Double(15.0, 0.5, dataRenderer.getWidth() + this.spacing * 2 - 2, dataRenderer.getHeight() - 1));
        }
    }

    private void paintButton(Graphics2D graphics2D, RadioButton radioButton, int n) {
        Paint paint;
        Color color = null;
        Color color2 = null;
        Ellipse2D.Double double_ = new Ellipse2D.Double(1.0, 1.0, 11.0, 11.0);
        if (radioButton.isEnabled()) {
            paint = new RadialGradientPaint((float)double_.getCenterX(), (float)double_.getCenterY(), (float)((RectangularShape)double_).getWidth() * 2.0f / 3.0f, new float[]{0.0f, 1.0f}, new Color[]{TerraTheme.darken(this.buttonColor), this.buttonColor});
            color = this.buttonBorderColor;
            color2 = this.buttonSelectionColor;
        } else {
            paint = this.disabledButtonColor;
            color = this.disabledButtonBorderColor;
            color2 = this.disabledButtonSelectionColor;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(0, (n - 14) / 2);
        graphics2D.setColor(color);
        graphics2D.fillOval(0, 0, 13, 13);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (radioButton.isSelected()) {
            Ellipse2D.Double double_2 = new Ellipse2D.Double(4.0, 4.0, 5.0, 5.0);
            graphics2D.setColor(color2);
            graphics2D.fill(double_2);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraRadioButtonSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = n;
        this.invalidateComponent();
    }

    public final void setSpacing(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(number.intValue());
    }
}

