/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.ScrollBar;
import org.apache.pivot.wtk.ScrollBarListener;
import org.apache.pivot.wtk.ScrollBarValueListener;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraScrollBarSkin
extends ContainerSkin
implements ScrollBarListener,
ScrollBarValueListener {
    private static final int DEFAULT_THICKNESS = 15;
    private static final int DEFAULT_LENGTH = 100;
    private AutomaticScroller automaticScroller = new AutomaticScroller();
    private ScrollButton scrollUpButton = new ScrollButton(-1, new ScrollUpImage());
    private ScrollButton scrollDownButton = new ScrollButton(1, new ScrollDownImage());
    private Handle handle = new Handle();
    private int minimumHandleLength;
    private Color borderColor;
    private Color scrollButtonImageColor;
    private Color scrollButtonBackgroundColor;
    private Color scrollButtonDisabledBackgroundColor;
    private Color scrollButtonPressedBackgroundColor;
    private Color scrollButtonHighlightedBackgroundColor;

    public TerraScrollBarSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.minimumHandleLength = 31;
        this.borderColor = terraTheme.getColor(7);
        this.scrollButtonImageColor = terraTheme.getColor(1);
        this.scrollButtonBackgroundColor = terraTheme.getColor(10);
        this.scrollButtonDisabledBackgroundColor = terraTheme.getColor(10);
        this.scrollButtonPressedBackgroundColor = terraTheme.getColor(9);
        this.scrollButtonHighlightedBackgroundColor = terraTheme.getColor(11);
    }

    public void install(Component component) {
        super.install(component);
        ScrollBar scrollBar = (ScrollBar)component;
        scrollBar.getScrollBarListeners().add((Object)this);
        scrollBar.getScrollBarValueListeners().add((Object)this);
        scrollBar.add((Component)this.scrollUpButton);
        scrollBar.add((Component)this.scrollDownButton);
        scrollBar.add((Component)this.handle);
        this.setBackgroundColor(9);
        this.enabledChanged((Component)scrollBar);
    }

    public int getPreferredWidth(int n) {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int n2 = 0;
        n2 = scrollBar.getOrientation() == Orientation.HORIZONTAL ? 100 : 15;
        return n2;
    }

    public int getPreferredHeight(int n) {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int n2 = 0;
        n2 = scrollBar.getOrientation() == Orientation.HORIZONTAL ? 15 : 100;
        return n2;
    }

    public Dimensions getPreferredSize() {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int n = 0;
        int n2 = 0;
        if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
            n = 100;
            n2 = 15;
        } else {
            n = 15;
            n2 = 100;
        }
        return new Dimensions(n, n2);
    }

    public void layout() {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = scrollBar.getStart();
        int n4 = scrollBar.getEnd();
        int n5 = scrollBar.getExtent();
        int n6 = scrollBar.getValue();
        int n7 = n4 - n5;
        int n8 = n7 - n3 + 1;
        float f = (float)n5 / (float)(n4 - n3);
        if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
            this.scrollUpButton.setSize(this.scrollUpButton.getPreferredWidth(-1), n2);
            this.scrollUpButton.setLocation(0, 0);
            this.scrollDownButton.setSize(this.scrollDownButton.getPreferredWidth(-1), n2);
            this.scrollDownButton.setLocation(n - this.scrollDownButton.getWidth(), 0);
            if (scrollBar.isEnabled()) {
                int n9 = n - this.scrollUpButton.getWidth() - this.scrollDownButton.getWidth() + 2;
                int n10 = Math.max(this.minimumHandleLength, Math.round(f * (float)n9));
                int n11 = n9 - n10 + 1;
                float f2 = (float)n11 / (float)n8;
                int n12 = (int)((float)n6 * f2) + this.scrollUpButton.getWidth() - 1;
                if (n10 > n9) {
                    this.handle.setVisible(false);
                } else {
                    this.handle.setVisible(true);
                    this.handle.setSize(n10, n2);
                    this.handle.setLocation(n12, 0);
                }
            } else {
                this.handle.setVisible(false);
            }
        } else {
            this.scrollUpButton.setSize(n, this.scrollUpButton.getPreferredHeight(-1));
            this.scrollUpButton.setLocation(0, 0);
            this.scrollDownButton.setSize(n, this.scrollDownButton.getPreferredHeight(-1));
            this.scrollDownButton.setLocation(0, n2 - this.scrollDownButton.getHeight());
            if (scrollBar.isEnabled()) {
                int n13 = n2 - this.scrollUpButton.getHeight() - this.scrollDownButton.getHeight() + 2;
                int n14 = Math.max(this.minimumHandleLength, Math.round(f * (float)n13));
                int n15 = n13 - n14 + 1;
                float f3 = (float)n15 / (float)n8;
                int n16 = (int)((float)n6 * f3) + this.scrollUpButton.getHeight() - 1;
                if (n14 > n13) {
                    this.handle.setVisible(false);
                } else {
                    this.handle.setVisible(true);
                    this.handle.setSize(n, n14);
                    this.handle.setLocation(0, n16);
                }
            } else {
                this.handle.setVisible(false);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setPaint(this.borderColor);
        if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
            int n3 = this.scrollUpButton.getWidth();
            int n4 = this.scrollDownButton.getWidth();
            GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)n3, (int)0, (int)(n - n4 - n3), (Orientation)Orientation.HORIZONTAL);
            GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)n3, (int)(n2 - 1), (int)(n - n4 - n3), (Orientation)Orientation.HORIZONTAL);
        } else {
            int n5 = this.scrollUpButton.getHeight();
            int n6 = this.scrollDownButton.getHeight();
            GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)n5, (int)(n2 - n6 - n5), (Orientation)Orientation.VERTICAL);
            GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)(n - 1), (int)n5, (int)(n2 - n6 - n5), (Orientation)Orientation.VERTICAL);
        }
    }

    public void setBackgroundColor(Color color) {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        Color color2 = TerraTheme.brighten(color);
        GradientPaint gradientPaint = scrollBar.getOrientation() == Orientation.HORIZONTAL ? new GradientPaint(0.0f, 1.0f, color, 0.0f, 13.0f, color2) : new GradientPaint(1.0f, 0.0f, color, 13.0f, 0.0f, color2);
        this.setBackgroundPaint(gradientPaint);
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public int getMinimumHandleLength() {
        return this.minimumHandleLength;
    }

    public void setMinimumHandleLength(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("minimumHandleLength must be positive.");
        }
        if (n != this.minimumHandleLength) {
            this.minimumHandleLength = n;
            this.invalidateComponent();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null");
        }
        this.borderColor = color;
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBorderColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(terraTheme.getColor(n));
    }

    public Color getScrollButtonImageColor() {
        return this.scrollButtonImageColor;
    }

    public void setScrollButtonImageColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("scrollButtonImageColor is null");
        }
        this.scrollButtonImageColor = color;
        this.repaintComponent();
    }

    public final void setScrollButtonImageColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("scrollButtonImageColor is null");
        }
        this.setScrollButtonImageColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setScrollButtonImageColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonImageColor(terraTheme.getColor(n));
    }

    public Color getScrollButtonBackgroundColor() {
        return this.scrollButtonBackgroundColor;
    }

    public void setScrollButtonBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("scrollButtonBackgroundColor is null");
        }
        this.scrollButtonBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setScrollButtonBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("scrollButtonBackgroundColor is null");
        }
        this.setScrollButtonBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setScrollButtonBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonBackgroundColor(terraTheme.getColor(n));
    }

    public Color getScrollButtonDisabledBackgroundColor() {
        return this.scrollButtonDisabledBackgroundColor;
    }

    public void setScrollButtonDisabledBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("scrollButtonDisabledBackgroundColor is null");
        }
        this.scrollButtonDisabledBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setScrollButtonDisabledBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("scrollButtonDisabledBackgroundColor is null");
        }
        this.setScrollButtonDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setScrollButtonDisabledBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonDisabledBackgroundColor(terraTheme.getColor(n));
    }

    public Color getScrollButtonPressedBackgroundColor() {
        return this.scrollButtonPressedBackgroundColor;
    }

    public void setScrollButtonPressedBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("scrollButtonPressedBackgroundColor is null");
        }
        this.scrollButtonPressedBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setScrollButtonPressedBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("scrollButtonPressedBackgroundColor is null");
        }
        this.setScrollButtonPressedBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setScrollButtonPressedBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonPressedBackgroundColor(terraTheme.getColor(n));
    }

    public Color getScrollButtonHighlightedBackgroundColor() {
        return this.scrollButtonHighlightedBackgroundColor;
    }

    public void setScrollButtonHighlightedBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("scrollButtonHighlightedBackgroundColor is null");
        }
        this.scrollButtonHighlightedBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setScrollButtonHighlightedBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("scrollButtonHighlightedBackgroundColor is null");
        }
        this.setScrollButtonHighlightedBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setScrollButtonHighlightedBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonHighlightedBackgroundColor(terraTheme.getColor(n));
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.automaticScroller.stop();
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        if (button == Mouse.Button.LEFT && this.handle.isVisible()) {
            int n3;
            int n4;
            ScrollBar scrollBar = (ScrollBar)this.getComponent();
            if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                n4 = n < this.handle.getX() ? -1 : 1;
                int n5 = n - this.scrollUpButton.getWidth() + 1;
                if (n4 == 1) {
                    n5 -= this.handle.getWidth();
                }
                n3 = (int)((float)n5 / this.getValueScale());
            } else {
                n4 = n2 < this.handle.getY() ? -1 : 1;
                int n6 = n2 - this.scrollUpButton.getHeight() + 1;
                if (n4 == 1) {
                    n6 -= this.handle.getHeight();
                }
                n3 = (int)((float)n6 / this.getValueScale());
            }
            this.automaticScroller.start(n4, Mouse.ScrollType.BLOCK, n3);
            bl = true;
        }
        return bl;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        if (button == Mouse.Button.LEFT) {
            this.automaticScroller.stop();
        }
        return bl;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        boolean bl = false;
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int n5 = scrollBar.getValue();
        int n6 = n5 + n * n2 * scrollBar.getUnitIncrement();
        if (n2 > 0) {
            int n7 = scrollBar.getEnd() - scrollBar.getExtent();
            n6 = Math.min(n6, n7);
            if (n5 < n7) {
                bl = true;
            }
        } else {
            n6 = Math.max(n6, 0);
            if (n5 > 0) {
                bl = true;
            }
        }
        scrollBar.setValue(n6);
        return bl;
    }

    private float getValueScale() {
        int n;
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int n2 = scrollBar.getStart();
        int n3 = scrollBar.getEnd();
        int n4 = scrollBar.getExtent();
        int n5 = n3 - n4;
        int n6 = n5 - n2 + 1;
        if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
            int n7 = this.getWidth() - this.scrollUpButton.getWidth() - this.scrollDownButton.getWidth() + 2;
            n = n7 - this.handle.getWidth() + 1;
        } else {
            int n8 = this.getHeight() - this.scrollUpButton.getHeight() - this.scrollDownButton.getHeight() + 2;
            n = n8 - this.handle.getHeight() + 1;
        }
        float f = (float)n / (float)n6;
        return f;
    }

    public void enabledChanged(Component component) {
        boolean bl = component.isEnabled();
        this.scrollUpButton.setEnabled(bl);
        this.scrollDownButton.setEnabled(bl);
        this.invalidateComponent();
    }

    public void orientationChanged(ScrollBar scrollBar, Orientation orientation) {
        this.invalidateComponent();
    }

    public void scopeChanged(ScrollBar scrollBar, int n, int n2, int n3) {
        this.invalidateComponent();
    }

    public void unitIncrementChanged(ScrollBar scrollBar, int n) {
    }

    public void blockIncrementChanged(ScrollBar scrollBar, int n) {
    }

    public void valueChanged(ScrollBar scrollBar, int n) {
        if (this.handle.isVisible()) {
            int n2 = scrollBar.getValue();
            if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                int n3 = (int)((float)n2 * this.getValueScale()) + this.scrollUpButton.getWidth() - 1;
                this.handle.setLocation(n3, 0);
            } else {
                int n4 = (int)((float)n2 * this.getValueScale()) + this.scrollUpButton.getHeight() - 1;
                this.handle.setLocation(0, n4);
            }
        }
    }

    protected class HandleSkin
    extends ComponentSkin {
        private int dragOffset;
        private boolean highlighted = false;

        protected HandleSkin() {
        }

        public boolean isFocusable() {
            return false;
        }

        public int getPreferredWidth(int n) {
            throw new UnsupportedOperationException();
        }

        public int getPreferredHeight(int n) {
            throw new UnsupportedOperationException();
        }

        public Dimensions getPreferredSize() {
            throw new UnsupportedOperationException();
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            Orientation orientation = scrollBar.getOrientation();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color color = this.highlighted ? TerraScrollBarSkin.this.scrollButtonHighlightedBackgroundColor : TerraScrollBarSkin.this.scrollButtonBackgroundColor;
            Color color2 = TerraTheme.brighten(color);
            Color color3 = TerraTheme.darken(color);
            if (orientation == Orientation.HORIZONTAL) {
                graphics2D.setPaint(new GradientPaint(0.0f, 1.0f, color2, 0.0f, n2 - 2, color));
            } else {
                graphics2D.setPaint(new GradientPaint(1.0f, 0.0f, color2, n - 2, 0.0f, color));
            }
            graphics2D.fillRect(1, 1, n - 2, n2 - 2);
            graphics2D.setPaint(TerraScrollBarSkin.this.borderColor);
            graphics2D.setStroke(new BasicStroke());
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
            if (orientation == Orientation.HORIZONTAL) {
                int n3 = n / 2;
                graphics2D.setPaint(color3);
                graphics2D.drawLine(n3 - 3, 4, n3 - 3, n2 - 5);
                graphics2D.drawLine(n3, 4, n3, n2 - 5);
                graphics2D.drawLine(n3 + 3, 4, n3 + 3, n2 - 5);
                graphics2D.setPaint(color2);
                graphics2D.drawLine(n3 - 2, 4, n3 - 2, n2 - 5);
                graphics2D.drawLine(n3 + 1, 4, n3 + 1, n2 - 5);
                graphics2D.drawLine(n3 + 4, 4, n3 + 4, n2 - 5);
            } else {
                int n4 = n2 / 2;
                graphics2D.setPaint(color3);
                graphics2D.drawLine(4, n4 - 3, n - 5, n4 - 3);
                graphics2D.drawLine(4, n4, n - 5, n4);
                graphics2D.drawLine(4, n4 + 3, n - 5, n4 + 3);
                graphics2D.setPaint(color2);
                graphics2D.drawLine(4, n4 - 2, n - 5, n4 - 2);
                graphics2D.drawLine(4, n4 + 1, n - 5, n4 + 1);
                graphics2D.drawLine(4, n4 + 4, n - 5, n4 + 4);
            }
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            this.highlighted = true;
            this.repaintComponent();
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            this.highlighted = false;
            this.repaintComponent();
        }

        public boolean mouseMove(Component component, int n, int n2) {
            boolean bl = super.mouseMove(component, n, n2);
            if (Mouse.getCapturer() == component) {
                ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
                Orientation orientation = scrollBar.getOrientation();
                int n3 = orientation == Orientation.HORIZONTAL ? component.getX() - TerraScrollBarSkin.this.scrollUpButton.getWidth() + n - this.dragOffset : component.getY() - TerraScrollBarSkin.this.scrollUpButton.getHeight() + n2 - this.dragOffset;
                int n4 = (int)((float)n3 / TerraScrollBarSkin.this.getValueScale());
                int n5 = scrollBar.getEnd();
                int n6 = scrollBar.getExtent();
                n4 = Math.min(Math.max(n4, 0), n5 - n6);
                scrollBar.setValue(n4);
            }
            return bl;
        }

        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseDown(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
                Orientation orientation = scrollBar.getOrientation();
                this.dragOffset = orientation == Orientation.HORIZONTAL ? n : n2;
                Mouse.capture((Component)component);
                bl = true;
            }
            return bl;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseUp(component, button, n, n2);
            if (button == Mouse.Button.LEFT && Mouse.getCapturer() == component) {
                Mouse.release();
            }
            return bl;
        }
    }

    protected class Handle
    extends Component {
        public Handle() {
            this.setSkin((Skin)new HandleSkin());
        }
    }

    protected class ScrollDownImage
    extends ScrollButtonImage {
        protected ScrollDownImage() {
        }

        public void paint(Graphics2D graphics2D) {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setPaint(TerraScrollBarSkin.this.scrollButtonImageColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath generalPath = new GeneralPath(0);
            if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                generalPath.moveTo(0.0f, 0.0f);
                generalPath.lineTo((float)n + 0.5f, (float)n2 / 2.0f);
                generalPath.lineTo(0.0f, n2);
            } else {
                generalPath.moveTo(0.0f, 0.0f);
                generalPath.lineTo((float)n / 2.0f, (float)n2 + 0.5f);
                generalPath.lineTo(n, 0.0f);
            }
            generalPath.closePath();
            graphics2D.fill(generalPath);
        }
    }

    protected class ScrollUpImage
    extends ScrollButtonImage {
        protected ScrollUpImage() {
        }

        public void paint(Graphics2D graphics2D) {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setPaint(TerraScrollBarSkin.this.scrollButtonImageColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath generalPath = new GeneralPath(0);
            if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                generalPath.moveTo((float)n + 0.5f, 0.0f);
                generalPath.lineTo(0.0f, (float)n2 / 2.0f);
                generalPath.lineTo((float)n + 0.5f, n2);
            } else {
                generalPath.moveTo(0.0f, (float)n2 + 0.5f);
                generalPath.lineTo((float)n / 2.0f, 0.0f);
                generalPath.lineTo(n, (float)n2 + 0.5f);
            }
            generalPath.closePath();
            graphics2D.fill(generalPath);
        }
    }

    protected abstract class ScrollButtonImage
    extends Image {
        protected ScrollButtonImage() {
        }

        public int getWidth() {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            Orientation orientation = scrollBar.getOrientation();
            return orientation == Orientation.HORIZONTAL ? 5 : 7;
        }

        public int getHeight() {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            Orientation orientation = scrollBar.getOrientation();
            return orientation == Orientation.HORIZONTAL ? 7 : 5;
        }
    }

    protected class ScrollButtonSkin
    extends ComponentSkin {
        private boolean highlighted = false;
        private boolean pressed = false;

        protected ScrollButtonSkin() {
        }

        public boolean isFocusable() {
            return false;
        }

        public int getPreferredWidth(int n) {
            return 15;
        }

        public int getPreferredHeight(int n) {
            return 15;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            Color color;
            ScrollButton scrollButton = (ScrollButton)this.getComponent();
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            Orientation orientation = scrollBar.getOrientation();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color color2 = scrollButton.isEnabled() ? (this.pressed ? TerraScrollBarSkin.this.scrollButtonPressedBackgroundColor : (this.highlighted ? TerraScrollBarSkin.this.scrollButtonHighlightedBackgroundColor : TerraScrollBarSkin.this.scrollButtonBackgroundColor)) : TerraScrollBarSkin.this.scrollButtonDisabledBackgroundColor;
            Color color3 = TerraTheme.brighten(color2);
            Color color4 = this.pressed ? color2 : color3;
            Color color5 = color = this.pressed ? color3 : color2;
            if (orientation == Orientation.HORIZONTAL) {
                graphics2D.setPaint(new GradientPaint(0.0f, 1.0f, color4, 0.0f, n2 - 2, color));
            } else {
                graphics2D.setPaint(new GradientPaint(1.0f, 0.0f, color4, n - 2, 0.0f, color));
            }
            graphics2D.fillRect(1, 1, n - 2, n2 - 2);
            graphics2D.setPaint(TerraScrollBarSkin.this.borderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
            ScrollButtonImage scrollButtonImage = scrollButton.getButtonImage();
            int n3 = scrollButtonImage.getWidth();
            int n4 = scrollButtonImage.getHeight();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n5 = (n - n3) / 2;
            int n6 = (n2 - n4) / 2;
            graphics2D2.translate(n5, n6);
            graphics2D2.clipRect(0, 0, n3, n4);
            scrollButtonImage.paint(graphics2D2);
            graphics2D2.dispose();
        }

        public void enabledChanged(Component component) {
            super.enabledChanged(component);
            TerraScrollBarSkin.this.automaticScroller.stop();
            this.pressed = false;
            this.highlighted = false;
            this.repaintComponent();
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            this.highlighted = true;
            this.repaintComponent();
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            TerraScrollBarSkin.this.automaticScroller.stop();
            this.pressed = false;
            this.highlighted = false;
            this.repaintComponent();
        }

        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseDown(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                ScrollButton scrollButton = (ScrollButton)this.getComponent();
                TerraScrollBarSkin.this.automaticScroller.start(scrollButton.getDirection(), Mouse.ScrollType.UNIT, -1);
                this.pressed = true;
                this.repaintComponent();
                bl = true;
            }
            return bl;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseUp(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                TerraScrollBarSkin.this.automaticScroller.stop();
                this.pressed = false;
                this.repaintComponent();
            }
            return bl;
        }
    }

    protected class ScrollButton
    extends Component {
        private int direction;
        private ScrollButtonImage buttonImage;

        public ScrollButton(int n, ScrollButtonImage scrollButtonImage) {
            this.direction = n;
            this.buttonImage = scrollButtonImage;
            this.setSkin((Skin)new ScrollButtonSkin());
        }

        public int getDirection() {
            return this.direction;
        }

        public ScrollButtonImage getButtonImage() {
            return this.buttonImage;
        }
    }

    protected class AutomaticScroller {
        public int direction;
        public Mouse.ScrollType incrementType;
        public int stopValue;
        private ApplicationContext.ScheduledCallback scheduledScrollCallback = null;

        protected AutomaticScroller() {
        }

        public void start(int n, Mouse.ScrollType scrollType, int n2) {
            if (this.scheduledScrollCallback != null) {
                throw new IllegalStateException("Already running");
            }
            this.direction = n;
            this.incrementType = scrollType;
            this.stopValue = n2;
            this.scheduledScrollCallback = ApplicationContext.scheduleRecurringCallback((Runnable)new Runnable(){

                @Override
                public void run() {
                    AutomaticScroller.this.scroll();
                }
            }, (long)400L, (long)30L);
            this.scroll();
        }

        public void stop() {
            if (this.scheduledScrollCallback != null) {
                this.scheduledScrollCallback.cancel();
                this.scheduledScrollCallback = null;
            }
        }

        private void scroll() {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            int n = scrollBar.getStart();
            int n2 = scrollBar.getEnd();
            int n3 = scrollBar.getExtent();
            int n4 = scrollBar.getValue();
            int n5 = this.incrementType == Mouse.ScrollType.UNIT ? this.direction * scrollBar.getUnitIncrement() : this.direction * scrollBar.getBlockIncrement();
            if (n5 < 0) {
                int n6 = Math.max(n4 + n5, n);
                scrollBar.setValue(n6);
                if (this.stopValue != -1 && n6 < this.stopValue) {
                    this.stop();
                }
                if (n6 == n) {
                    this.stop();
                }
            } else {
                int n7 = Math.min(n4 + n5, n2 - n3);
                scrollBar.setValue(n7);
                if (this.stopValue != -1 && n7 > this.stopValue) {
                    this.stop();
                }
                if (n7 == n2 - n3) {
                    this.stop();
                }
            }
        }
    }
}

