/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Slider;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.SliderSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraSliderSkin
extends SliderSkin {
    private Thumb thumb = new Thumb();
    Point dragOffset = null;
    private Color trackColor;
    private int trackWidth;
    private Color buttonBackgroundColor;
    private Color buttonBorderColor;
    private int thumbWidth;
    private int thumbHeight;
    private Color buttonBevelColor;
    public static final int DEFAULT_WIDTH = 120;
    public static final int MINIMUM_THUMB_WIDTH = 4;
    public static final int MINIMUM_THUMB_HEIGHT = 4;
    private static final BasicStroke dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);

    public TerraSliderSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.trackColor = terraTheme.getColor(6);
        this.trackWidth = 2;
        this.buttonBackgroundColor = terraTheme.getColor(10);
        this.buttonBorderColor = terraTheme.getColor(7);
        this.buttonBevelColor = TerraTheme.brighten(this.buttonBackgroundColor);
        this.thumbWidth = 8;
        this.thumbHeight = 16;
    }

    public void install(Component component) {
        super.install(component);
        Slider slider = (Slider)component;
        slider.add((Component)this.thumb);
    }

    public int getPreferredWidth(int n) {
        Slider slider = (Slider)this.getComponent();
        int n2 = slider.getOrientation() == Orientation.HORIZONTAL ? 120 : this.thumbHeight;
        return n2;
    }

    public int getPreferredHeight(int n) {
        Slider slider = (Slider)this.getComponent();
        int n2 = slider.getOrientation() == Orientation.HORIZONTAL ? this.thumbHeight : 120;
        return n2;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public void layout() {
        Slider slider = (Slider)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = slider.getStart();
        int n4 = slider.getEnd();
        int n5 = slider.getValue();
        float f = (float)(n5 - n3) / (float)(n4 - n3);
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            this.thumb.setSize(this.thumbWidth, this.thumbHeight);
            this.thumb.setLocation((int)((float)(n - this.thumbWidth) * f), (n2 - this.thumbHeight) / 2);
        } else {
            this.thumb.setSize(this.thumbHeight, this.thumbWidth);
            this.thumb.setLocation((n - this.thumbHeight) / 2, (int)((float)n2 - (float)(n2 - this.thumbWidth) * f - (float)this.thumbWidth));
        }
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        Slider slider = (Slider)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics2D.setColor(this.trackColor);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            graphics2D.fillRect(0, (n2 - this.trackWidth) / 2, n, this.trackWidth);
        } else {
            graphics2D.fillRect((n - this.trackWidth) / 2, 0, this.trackWidth, n2);
        }
        if (this.thumb.isFocused()) {
            graphics2D.setStroke(dashStroke);
            graphics2D.setColor(this.buttonBorderColor);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawRect(0, 0, n - 1, n2 - 1);
        }
    }

    public Color getTrackColor() {
        return this.trackColor;
    }

    public void setTrackColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("trackColor is null.");
        }
        this.trackColor = color;
        this.repaintComponent();
    }

    public final void setTrackColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("trackColor is null");
        }
        this.setTrackColor(GraphicsUtilities.decodeColor((String)string));
    }

    public int getTrackWidth() {
        return this.trackWidth;
    }

    public void setTrackWidth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("trackWidth is negative.");
        }
        this.trackWidth = n;
        this.repaintComponent();
    }

    public void setTrackWidth(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("trackWidth is null.");
        }
        this.setTrackWidth(number.intValue());
    }

    public Color getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    public void setButtonBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null.");
        }
        this.buttonBackgroundColor = color;
        this.buttonBevelColor = TerraTheme.brighten(color);
        this.repaintComponent();
    }

    public final void setButtonBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null");
        }
        this.setButtonBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getButtonBorderColor() {
        return this.buttonBorderColor;
    }

    public void setButtonBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("buttonBorderColor is null.");
        }
        this.buttonBorderColor = color;
        this.repaintComponent();
    }

    public final void setButtonBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonBorderColor is null.");
        }
        this.setButtonBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public int getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbWidth(int n) {
        if (n < 4) {
            throw new IllegalArgumentException("thumbWidth must be greater than or equal to 4");
        }
        this.thumbWidth = n;
        this.invalidateComponent();
    }

    public void setThumbWidth(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("thumbWidth is null.");
        }
        this.setThumbWidth(number.intValue());
    }

    public int getThumbHeight() {
        return this.thumbHeight;
    }

    public void setThumbHeight(int n) {
        if (n < 4) {
            throw new IllegalArgumentException("thumbHeight must be greater than or equal to 4");
        }
        this.thumbHeight = n;
        this.invalidateComponent();
    }

    public void setThumbHeight(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("thumbHeight is null.");
        }
        this.setThumbHeight(number.intValue());
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        this.thumb.requestFocus();
        return super.mouseClick(component, button, n, n2, n3);
    }

    public void rangeChanged(Slider slider, int n, int n2) {
        this.invalidateComponent();
    }

    public void orientationChanged(Slider slider) {
        this.invalidateComponent();
    }

    public void valueChanged(Slider slider, int n) {
        this.layout();
    }

    protected class ThumbSkin
    extends ComponentSkin {
        private boolean highlighted = false;

        protected ThumbSkin() {
        }

        public boolean isFocusable() {
            return true;
        }

        public int getPreferredWidth(int n) {
            return 0;
        }

        public int getPreferredHeight(int n) {
            return 0;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, TerraSliderSkin.this.buttonBevelColor, (float)n / 2.0f, n2, TerraSliderSkin.this.buttonBackgroundColor));
            graphics2D.fillRect(0, 0, n, n2);
            float f = this.highlighted || TerraSliderSkin.this.dragOffset != null ? 0.25f : 0.0f;
            graphics2D.setPaint(new Color(0.0f, 0.0f, 0.0f, f));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(TerraSliderSkin.this.buttonBorderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
        }

        public void enabledChanged(Component component) {
            super.enabledChanged(component);
            this.highlighted = false;
            this.repaintComponent();
        }

        public void focusedChanged(Component component, Component component2) {
            super.focusedChanged(component, component2);
            TerraSliderSkin.this.repaintComponent();
        }

        public boolean mouseMove(Component component, int n, int n2) {
            boolean bl = super.mouseMove(component, n, n2);
            if (Mouse.getCapturer() == component) {
                Slider slider = (Slider)TerraSliderSkin.this.getComponent();
                if (slider.getOrientation() == Orientation.HORIZONTAL) {
                    int n3;
                    int n4 = slider.getWidth();
                    int n5 = TerraSliderSkin.this.thumb.getWidth();
                    Point point = TerraSliderSkin.this.thumb.mapPointToAncestor((Container)slider, n, n2);
                    int n6 = point.x;
                    int n7 = TerraSliderSkin.this.dragOffset.x;
                    if (n6 < n7) {
                        n6 = n7;
                    }
                    if (n6 > (n3 = n4 - n5 + TerraSliderSkin.this.dragOffset.x)) {
                        n6 = n3;
                    }
                    float f = (float)(n6 - TerraSliderSkin.this.dragOffset.x) / (float)(n4 - n5);
                    int n8 = slider.getStart();
                    int n9 = slider.getEnd();
                    int n10 = (int)((float)n8 + (float)(n9 - n8) * f);
                    slider.setValue(n10);
                } else {
                    int n11;
                    int n12 = slider.getHeight();
                    int n13 = TerraSliderSkin.this.thumb.getHeight();
                    Point point = TerraSliderSkin.this.thumb.mapPointToAncestor((Container)slider, n, n2);
                    int n14 = point.y;
                    int n15 = TerraSliderSkin.this.dragOffset.y;
                    if (n14 < n15) {
                        n14 = n15;
                    }
                    if (n14 > (n11 = n12 + TerraSliderSkin.this.dragOffset.y)) {
                        n14 = n11;
                    }
                    float f = (float)(n12 - n14 + TerraSliderSkin.this.dragOffset.y) / (float)(n12 - n13);
                    int n16 = slider.getStart();
                    int n17 = slider.getEnd();
                    int n18 = (int)((float)n16 + (float)(n17 - n16) * f);
                    slider.setValue(n18);
                }
            }
            return bl;
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            this.highlighted = true;
            this.repaintComponent();
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            this.highlighted = false;
            this.repaintComponent();
        }

        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseDown(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                TerraSliderSkin.this.dragOffset = new Point(n, n2);
                Mouse.capture((Component)component);
                this.repaintComponent();
                bl = true;
            }
            return bl;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseUp(component, button, n, n2);
            if (Mouse.getCapturer() == component) {
                TerraSliderSkin.this.dragOffset = null;
                Mouse.release();
                this.repaintComponent();
            }
            return bl;
        }

        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            component.requestFocus();
            return super.mouseClick(component, button, n, n2, n3);
        }

        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            boolean bl = super.keyPressed(component, n, keyLocation);
            Slider slider = (Slider)TerraSliderSkin.this.getComponent();
            int n2 = slider.getStart();
            int n3 = slider.getEnd();
            int n4 = n3 - n2;
            int n5 = slider.getValue();
            int n6 = n4 / 10;
            if (n == 37 || n == 40) {
                slider.setValue(Math.max(n2, n5 - n6));
                bl = true;
            } else if (n == 39 || n == 38) {
                slider.setValue(Math.min(n3, n5 + n6));
                bl = true;
            }
            return bl;
        }
    }

    protected class Thumb
    extends Component {
        public Thumb() {
            this.setSkin((Skin)new ThumbSkin());
        }
    }
}

