/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Spinner;
import org.apache.pivot.wtk.SpinnerListener;
import org.apache.pivot.wtk.SpinnerSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraSpinnerSkin
extends ContainerSkin
implements Spinner.Skin,
SpinnerListener,
SpinnerSelectionListener {
    private SpinnerContent spinnerContent = new SpinnerContent();
    private SpinButton upButton = new SpinButton(1, new SpinUpImage());
    private SpinButton downButton = new SpinButton(-1, new SpinDownImage());
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color borderColor;
    private Color buttonColor;
    private Color buttonBackgroundColor;
    private boolean sizeToContent = false;
    private Color buttonBevelColor;
    private static AutomaticSpinner automaticSpinner = new AutomaticSpinner();
    public static final int BUTTON_IMAGE_SIZE = 5;

    public TerraSpinnerSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(4));
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.borderColor = terraTheme.getColor(7);
        this.buttonColor = terraTheme.getColor(1);
        this.buttonBackgroundColor = terraTheme.getColor(10);
        this.buttonBevelColor = TerraTheme.brighten(this.buttonBackgroundColor);
    }

    public void setSize(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        super.setSize(n, n2);
        if (n3 != n || n4 != n2) {
            automaticSpinner.stop();
        }
    }

    public void install(Component component) {
        super.install(component);
        Spinner spinner = (Spinner)component;
        spinner.getSpinnerListeners().add((Object)this);
        spinner.getSpinnerSelectionListeners().add((Object)this);
        spinner.add((Component)this.spinnerContent);
        spinner.add((Component)this.upButton);
        spinner.add((Component)this.downButton);
    }

    public int getPreferredWidth(int n) {
        int n2 = 2;
        int n3 = n < 0 ? -1 : n / 2;
        n2 += Math.max(this.upButton.getPreferredWidth(n3), this.downButton.getPreferredWidth(n3));
        if (n >= 0) {
            n = Math.max(n - 2, 0);
        }
        return n2 += this.spinnerContent.getPreferredWidth(n);
    }

    public int getPreferredHeight(int n) {
        Dimensions dimensions = this.upButton.getPreferredSize();
        Dimensions dimensions2 = this.downButton.getPreferredSize();
        int n2 = Math.max(dimensions.height, dimensions2.height) * 2;
        if (n >= 0) {
            int n3 = Math.max(dimensions.width, dimensions2.width);
            n = Math.max(n - n3 - 2, 0);
        }
        n2 = Math.max(n2, this.spinnerContent.getPreferredHeight(n)) + 1;
        return n2;
    }

    public int getBaseline(int n, int n2) {
        int n3;
        Dimensions dimensions = this.upButton.getPreferredSize();
        Dimensions dimensions2 = this.downButton.getPreferredSize();
        int n4 = Math.max(dimensions.width, dimensions2.width);
        int n5 = Math.max(n - n4 - 2, 0);
        int n6 = this.spinnerContent.getBaseline(n5, n3 = Math.max(n2 - 2, 0));
        if (n6 != -1) {
            ++n6;
        }
        return n6;
    }

    public void layout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = Math.max((n2 - 3) / 2, 0);
        int n4 = Math.max(this.upButton.getPreferredWidth(n3), this.downButton.getPreferredWidth(n3));
        this.spinnerContent.setSize(Math.max(n - n4 - 3, 0), Math.max(n2 - 2, 0));
        this.spinnerContent.setLocation(1, 1);
        this.upButton.setSize(n4, n3);
        this.upButton.setLocation(n - n4 - 1, 1);
        this.downButton.setSize(n4, Math.max(n2 - n3 - 3, 0));
        this.downButton.setLocation(n - n4 - 1, n3 + 2);
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.upButton.getX();
        int n4 = this.upButton.getWidth();
        int n5 = this.upButton.getHeight();
        graphics2D.setPaint(new GradientPaint(n3 + n4 / 2, 0.0f, this.buttonBevelColor, n3 + n4 / 2, n5, this.buttonBackgroundColor));
        graphics2D.fillRect(n3, 0, n4, n2);
        graphics2D.setPaint(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)(n - n4 - 2), (int)0, (int)n2, (Orientation)Orientation.VERTICAL);
        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)(n - n4 - 2), (int)(n5 + 1), (int)(n4 + 1), (Orientation)Orientation.HORIZONTAL);
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        this.spinnerContent.requestFocus();
        return false;
    }

    protected void invalidateContent() {
        this.spinnerContent.invalidate();
        this.spinnerContent.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonImageColor(Color color) {
        this.buttonColor = color;
        this.repaintComponent();
    }

    public final void setButtonColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonColor is null");
        }
        this.setButtonImageColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Color getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    public void setButtonBackgroundColor(Color color) {
        this.buttonBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setButtonBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null");
        }
        this.setButtonBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateContent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraSpinnerSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public boolean isSizeToContent() {
        return this.sizeToContent;
    }

    public void setSizeToContent(boolean bl) {
        this.sizeToContent = bl;
        this.invalidateContent();
    }

    public Bounds getContentBounds() {
        return this.spinnerContent.getBounds();
    }

    public void spinnerDataChanged(Spinner spinner, List<?> list) {
        this.invalidateContent();
    }

    public void itemRendererChanged(Spinner spinner, Spinner.ItemRenderer itemRenderer) {
        this.invalidateContent();
    }

    public void circularChanged(Spinner spinner) {
    }

    public void selectedItemKeyChanged(Spinner spinner, String string) {
    }

    public void selectedIndexChanged(Spinner spinner, int n) {
        this.invalidateContent();
    }

    protected class SpinDownImage
    extends SpinButtonImage {
        protected SpinDownImage() {
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            int[] nArray = new int[]{0, 2, 4};
            int[] nArray2 = new int[]{1, 3, 1};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    protected class SpinUpImage
    extends SpinButtonImage {
        protected SpinUpImage() {
        }

        @Override
        public void paint(Graphics2D graphics2D) {
            super.paint(graphics2D);
            int[] nArray = new int[]{0, 2, 4};
            int[] nArray2 = new int[]{3, 1, 3};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            graphics2D.drawPolygon(nArray, nArray2, 3);
        }
    }

    protected abstract class SpinButtonImage
    extends Image {
        protected SpinButtonImage() {
        }

        public int getWidth() {
            return 5;
        }

        public int getHeight() {
            return 5;
        }

        public void paint(Graphics2D graphics2D) {
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setPaint(TerraSpinnerSkin.this.buttonColor);
        }
    }

    protected class SpinButtonSkin
    extends ComponentSkin {
        private boolean highlighted = false;
        private boolean pressed = false;

        protected SpinButtonSkin() {
        }

        public int getPreferredWidth(int n) {
            return 11;
        }

        public int getPreferredHeight(int n) {
            return 7;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            SpinButton spinButton = (SpinButton)this.getComponent();
            int n = this.getWidth();
            int n2 = this.getHeight();
            float f = this.pressed ? 0.5f : (this.highlighted ? 0.25f : 0.0f);
            graphics2D.setPaint(new Color(0.0f, 0.0f, 0.0f, f));
            graphics2D.fillRect(0, 0, n, n2);
            SpinButtonImage spinButtonImage = (SpinButtonImage)spinButton.getButtonImage();
            graphics2D.translate((n - 5) / 2, (n2 - 5) / 2);
            spinButtonImage.paint(graphics2D);
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean isOpaque() {
            return false;
        }

        public void enabledChanged(Component component) {
            super.enabledChanged(component);
            automaticSpinner.stop();
            this.pressed = false;
            this.highlighted = false;
            this.repaintComponent();
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            this.highlighted = true;
            this.repaintComponent();
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            automaticSpinner.stop();
            this.pressed = false;
            this.highlighted = false;
            this.repaintComponent();
        }

        public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseDown(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                SpinButton spinButton = (SpinButton)this.getComponent();
                Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
                automaticSpinner.start(spinner, spinButton.getDirection());
                this.pressed = true;
                this.repaintComponent();
            }
            return bl;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
            boolean bl = super.mouseUp(component, button, n, n2);
            if (button == Mouse.Button.LEFT) {
                automaticSpinner.stop();
                this.pressed = false;
                this.repaintComponent();
            }
            return bl;
        }
    }

    protected class SpinButton
    extends Component {
        private int direction;
        private Image buttonImage;

        public SpinButton(int n, Image image) {
            this.direction = n;
            this.buttonImage = image;
            this.setSkin((Skin)new SpinButtonSkin());
        }

        public int getDirection() {
            return this.direction;
        }

        public Image getButtonImage() {
            return this.buttonImage;
        }
    }

    protected class SpinnerContentSkin
    extends ComponentSkin {
        protected SpinnerContentSkin() {
        }

        public int getPreferredWidth(int n) {
            int n2 = 0;
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            if (TerraSpinnerSkin.this.sizeToContent) {
                List list = spinner.getSpinnerData();
                for (Object e : list) {
                    itemRenderer.render(e, spinner);
                    n2 = Math.max(n2, itemRenderer.getPreferredWidth(n));
                }
            } else {
                itemRenderer.render(spinner.getSelectedItem(), spinner);
                n2 = itemRenderer.getPreferredWidth(n);
            }
            return n2;
        }

        public int getPreferredHeight(int n) {
            int n2 = 0;
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            itemRenderer.render(spinner.getSelectedItem(), spinner);
            n2 = itemRenderer.getPreferredHeight(n);
            return n2;
        }

        public int getBaseline(int n, int n2) {
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            int n3 = -1;
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            itemRenderer.render(spinner.getSelectedItem(), spinner);
            n3 = itemRenderer.getBaseline(n, n2);
            return n3;
        }

        public Dimensions getPreferredSize() {
            Dimensions dimensions;
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            if (TerraSpinnerSkin.this.sizeToContent) {
                dimensions = new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
            } else {
                itemRenderer.render(spinner.getSelectedItem(), spinner);
                dimensions = itemRenderer.getPreferredSize();
            }
            return dimensions;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics2D) {
            SpinnerContent spinnerContent = (SpinnerContent)this.getComponent();
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            itemRenderer.render(spinner.getSelectedItem(), spinner);
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            itemRenderer.setSize(n, n2);
            itemRenderer.paint(graphics2D2);
            graphics2D2.dispose();
            if (spinnerContent.isFocused()) {
                BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
                graphics2D.setStroke(basicStroke);
                graphics2D.setColor(TerraSpinnerSkin.this.borderColor);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.draw(new Rectangle2D.Double(1.0, 1.5, Math.max((double)n - 2.5, 0.0), Math.max(n2 - 3, 0)));
            }
        }

        public boolean isOpaque() {
            return false;
        }

        public void focusedChanged(Component component, Component component2) {
            super.focusedChanged(component, component2);
            this.repaintComponent();
        }

        public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
            int n2;
            boolean bl = false;
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            boolean bl2 = spinner.isCircular();
            int n3 = spinner.getSpinnerData().getLength();
            int n4 = n2 = spinner.getSelectedIndex();
            if (n == 38) {
                if (n2 < n3 - 1) {
                    ++n4;
                } else if (bl2) {
                    n4 = 0;
                }
            } else if (n == 40) {
                if (n2 > 0) {
                    --n4;
                } else if (bl2) {
                    n4 = n3 - 1;
                }
            } else {
                bl = super.keyPressed(component, n, keyLocation);
            }
            if (n4 != n2) {
                spinner.setSelectedIndex(n4);
                bl = true;
            }
            return bl;
        }
    }

    protected class SpinnerContent
    extends Component {
        public SpinnerContent() {
            this.setSkin((Skin)new SpinnerContentSkin());
        }
    }

    private static class AutomaticSpinner {
        public Spinner spinner;
        public int direction;
        private ApplicationContext.ScheduledCallback scheduledSpinnerCallback = null;

        private AutomaticSpinner() {
        }

        public void start(Spinner spinner, int n) {
            assert (n != 0) : "Direction must be positive or negative";
            if (this.scheduledSpinnerCallback != null) {
                throw new IllegalStateException("Already running");
            }
            this.spinner = spinner;
            this.direction = n;
            this.scheduledSpinnerCallback = ApplicationContext.scheduleRecurringCallback((Runnable)new Runnable(){

                @Override
                public void run() {
                    AutomaticSpinner.this.spin();
                }
            }, (long)400L, (long)30L);
            this.spin();
        }

        private void spin() {
            boolean bl = this.spinner.isCircular();
            int n = this.spinner.getSelectedIndex();
            int n2 = this.spinner.getSpinnerData().getLength();
            if (this.direction > 0) {
                if (n < n2 - 1) {
                    this.spinner.setSelectedIndex(n + 1);
                } else if (bl) {
                    this.spinner.setSelectedIndex(0);
                } else {
                    this.stop();
                }
            } else if (n > 0) {
                this.spinner.setSelectedIndex(n - 1);
            } else if (bl) {
                this.spinner.setSelectedIndex(n2 - 1);
            } else {
                this.stop();
            }
        }

        public void stop() {
            if (this.scheduledSpinnerCallback != null) {
                this.scheduledSpinnerCallback.cancel();
                this.scheduledSpinnerCallback = null;
            }
        }
    }
}

