/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonGroupListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.TabPane;
import org.apache.pivot.wtk.TabPaneAttributeListener;
import org.apache.pivot.wtk.TabPaneListener;
import org.apache.pivot.wtk.TabPaneSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import org.apache.pivot.wtk.effects.ClipDecorator;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quadratic;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTabPaneSkin
extends ContainerSkin
implements TabPaneListener,
TabPaneSelectionListener,
TabPaneAttributeListener {
    protected Panorama buttonPanorama = new Panorama();
    protected BoxPane buttonBoxPane = new BoxPane();
    private ButtonGroup tabButtonGroup = new ButtonGroup();
    private Color activeTabColor;
    private Color inactiveTabColor;
    private Color borderColor;
    private Insets padding;
    private Font buttonFont;
    private Color buttonColor;
    private Color disabledButtonColor;
    private Insets buttonPadding;
    private Color buttonBevelColor;
    private boolean collapsible = false;
    private Orientation tabOrientation = Orientation.HORIZONTAL;
    private SelectionChangeTransition selectionChangeTransition = null;
    private ClipDecorator clipDecorator = new ClipDecorator();
    private ComponentStateListener tabStateListener = new ComponentStateListener.Adapter(){

        public void enabledChanged(Component component) {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            int n = tabPane.getTabs().indexOf(component);
            TerraTabPaneSkin.this.buttonBoxPane.get(n).setEnabled(component.isEnabled());
        }
    };
    private static final int SELECTION_CHANGE_DURATION = 250;
    private static final int SELECTION_CHANGE_RATE = 30;
    public static final int GRADIENT_BEVEL_THICKNESS = 4;
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ButtonDataRenderer(){

        public void render(Object object, Button button, boolean bl) {
            Component component = (Component)object;
            super.render((Object)new ButtonData(TabPane.getIcon((Component)component), TabPane.getLabel((Component)component)), button, bl);
        }
    };

    public TerraTabPaneSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.activeTabColor = terraTheme.getColor(11);
        this.inactiveTabColor = terraTheme.getColor(9);
        this.borderColor = terraTheme.getColor(7);
        this.padding = new Insets(6);
        this.buttonFont = terraTheme.getFont();
        this.buttonColor = terraTheme.getColor(1);
        this.disabledButtonColor = terraTheme.getColor(7);
        this.buttonPadding = new Insets(3, 4, 3, 4);
        this.buttonBevelColor = TerraTheme.brighten(this.inactiveTabColor);
        this.buttonBoxPane.getStyles().put("fill", (Object)true);
        this.buttonPanorama.getStyles().put("buttonBackgroundColor", (Object)this.borderColor);
        this.buttonPanorama.getStyles().put("buttonPadding", (Object)6);
        this.buttonPanorama.setView((Component)this.buttonBoxPane);
        this.tabButtonGroup.getButtonGroupListeners().add((Object)new ButtonGroupListener.Adapter(){

            public void selectionChanged(ButtonGroup buttonGroup, Button button) {
                Button button2 = TerraTabPaneSkin.this.tabButtonGroup.getSelection();
                int n = button2 == null ? -1 : TerraTabPaneSkin.this.buttonBoxPane.indexOf((Component)button2);
                TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
                tabPane.setSelectedIndex(n);
            }
        });
        this.setButtonSpacing(2);
    }

    public void install(Component component) {
        super.install(component);
        TabPane tabPane = (TabPane)component;
        tabPane.getTabPaneListeners().add((Object)this);
        tabPane.getTabPaneSelectionListeners().add((Object)this);
        tabPane.getTabPaneAttributeListeners().add((Object)this);
        tabPane.add((Component)this.buttonPanorama);
        TabPane.TabSequence tabSequence = tabPane.getTabs();
        int n = tabPane.getSelectedIndex();
        int n2 = tabSequence.getLength();
        for (int i = 0; i < n2; ++i) {
            Component component2 = (Component)tabSequence.get(i);
            component2.setVisible(i == n);
            TabButton tabButton = new TabButton(component2);
            tabButton.setButtonGroup(this.tabButtonGroup);
            this.buttonBoxPane.add((Component)tabButton);
            tabButton.setEnabled(component2.isEnabled());
            component2.getComponentStateListeners().add((Object)this.tabStateListener);
        }
        this.selectedIndexChanged(tabPane, -1);
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        Component component = tabPane.getSelectedTab();
        Component component2 = tabPane.getCorner();
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                if (n != -1) {
                    n = component2 != null ? Math.max(n - Math.max(component2.getPreferredHeight(-1), Math.max(this.buttonPanorama.getPreferredHeight(-1) - 1, 0)), 0) : Math.max(n - (this.buttonPanorama.getPreferredHeight(-1) - 1), 0);
                    n = Math.max(n - (this.padding.top + this.padding.bottom + 2), 0);
                }
                n2 = this.getPreferredTabWidth(n) + (this.padding.left + this.padding.right + 2);
                int n3 = this.buttonPanorama.getPreferredWidth(-1);
                if (component2 != null) {
                    n3 += component2.getPreferredWidth(-1);
                }
                n2 = Math.max(n2, n3);
                break;
            }
            case VERTICAL: {
                if (n != -1) {
                    n = Math.max(n - (this.padding.top + this.padding.bottom + 2), 0);
                }
                if (component == null && this.selectionChangeTransition == null) {
                    n2 = 1;
                } else {
                    n2 = this.getPreferredTabWidth(n) + (this.padding.left + this.padding.right);
                    if (this.selectionChangeTransition != null) {
                        float f = this.selectionChangeTransition.getScale();
                        n2 = (int)((float)n2 * f);
                    }
                    n2 += 2;
                }
                if (component2 != null) {
                    n2 += Math.max(component2.getPreferredWidth(-1), Math.max(this.buttonPanorama.getPreferredWidth(-1) - 1, 0));
                    break;
                }
                n2 += Math.max(this.buttonPanorama.getPreferredWidth(-1) - 1, 0);
            }
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        Component component = tabPane.getSelectedTab();
        Component component2 = tabPane.getCorner();
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                if (n != -1) {
                    n = Math.max(n - (this.padding.left + this.padding.right + 2), 0);
                }
                if (component == null && this.selectionChangeTransition == null) {
                    n2 = 1;
                } else {
                    n2 = this.getPreferredTabHeight(n) + (this.padding.top + this.padding.bottom);
                    if (this.selectionChangeTransition != null) {
                        float f = this.selectionChangeTransition.getScale();
                        n2 = (int)((float)n2 * f);
                    }
                    n2 += 2;
                }
                if (component2 != null) {
                    n2 += Math.max(component2.getPreferredHeight(-1), Math.max(this.buttonPanorama.getPreferredHeight(-1) - 1, 0));
                    break;
                }
                n2 += Math.max(this.buttonPanorama.getPreferredHeight(-1) - 1, 0);
                break;
            }
            case VERTICAL: {
                if (n != -1) {
                    n = component2 != null ? Math.max(n - Math.max(component2.getPreferredWidth(-1), Math.max(this.buttonPanorama.getPreferredWidth(-1) - 1, 0)), 0) : Math.max(n - (this.buttonPanorama.getPreferredWidth(-1) - 1), 0);
                    n = Math.max(n - (this.padding.left + this.padding.right + 2), 0);
                }
                n2 = this.getPreferredTabHeight(n) + (this.padding.top + this.padding.bottom + 2);
                int n3 = this.buttonPanorama.getPreferredHeight(-1);
                if (component2 != null) {
                    n3 += component2.getPreferredHeight(-1);
                }
                n2 = Math.max(n2, n3);
                break;
            }
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        int n;
        int n2;
        TabPane tabPane = (TabPane)this.getComponent();
        Component component = tabPane.getSelectedTab();
        Component component2 = tabPane.getCorner();
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                if (component == null && this.selectionChangeTransition == null) {
                    n2 = this.getPreferredTabWidth(-1) + (this.padding.left + this.padding.right + 2);
                    n = 1;
                } else {
                    Dimensions dimensions = this.getPreferredTabSize();
                    n2 = dimensions.width + (this.padding.left + this.padding.right + 2);
                    n = dimensions.height + (this.padding.top + this.padding.bottom);
                    if (this.selectionChangeTransition != null) {
                        float f = this.selectionChangeTransition.getScale();
                        n = (int)((float)n * f);
                    }
                    n += 2;
                }
                int n3 = this.buttonPanorama.getPreferredWidth(-1);
                if (component2 != null) {
                    n3 += component2.getPreferredWidth(-1);
                    n += Math.max(component2.getPreferredHeight(-1), Math.max(this.buttonPanorama.getPreferredHeight(-1) - 1, 0));
                } else {
                    n += Math.max(this.buttonPanorama.getPreferredHeight(-1) - 1, 0);
                }
                n2 = Math.max(n2, n3);
                break;
            }
            case VERTICAL: {
                if (component == null && this.selectionChangeTransition == null) {
                    n2 = 1;
                    n = this.getPreferredTabHeight(-1) + (this.padding.top + this.padding.bottom + 2);
                } else {
                    Dimensions dimensions = this.getPreferredTabSize();
                    n2 = dimensions.width + (this.padding.left + this.padding.right);
                    n = dimensions.height + (this.padding.top + this.padding.bottom + 2);
                    if (this.selectionChangeTransition != null) {
                        float f = this.selectionChangeTransition.getScale();
                        n2 = (int)((float)n2 * f);
                    }
                    n2 += 2;
                }
                int n4 = this.buttonPanorama.getPreferredHeight(-1);
                if (component2 != null) {
                    n2 += Math.max(component2.getPreferredWidth(-1), Math.max(this.buttonPanorama.getPreferredWidth(-1) - 1, 0));
                    n4 += component2.getPreferredHeight(-1);
                } else {
                    n2 += Math.max(this.buttonPanorama.getPreferredWidth(-1) - 1, 0);
                }
                n = Math.max(n, n4);
                break;
            }
            default: {
                n2 = 0;
                n = 0;
            }
        }
        return new Dimensions(n2, n);
    }

    public int getBaseline(int n, int n2) {
        int n3 = -1;
        if (this.tabOrientation == Orientation.HORIZONTAL && this.buttonBoxPane.getLength() > 0) {
            TabButton tabButton = (TabButton)this.buttonBoxPane.get(0);
            int n4 = this.buttonBoxPane.getPreferredHeight();
            n3 = tabButton.getBaseline(tabButton.getPreferredWidth(n4), n4);
        }
        return n3;
    }

    private int getPreferredTabWidth(int n) {
        int n2 = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        for (Component component : tabPane.getTabs()) {
            n2 = Math.max(n2, component.getPreferredWidth(n));
        }
        return n2;
    }

    private int getPreferredTabHeight(int n) {
        int n2 = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        for (Component component : tabPane.getTabs()) {
            n2 = Math.max(n2, component.getPreferredHeight(n));
        }
        return n2;
    }

    private Dimensions getPreferredTabSize() {
        int n = 0;
        int n2 = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        for (Component component : tabPane.getTabs()) {
            Dimensions dimensions = component.getPreferredSize();
            n = Math.max(n, dimensions.width);
            n2 = Math.max(n2, dimensions.height);
        }
        return new Dimensions(n, n2);
    }

    public void layout() {
        TabPane tabPane = (TabPane)this.getComponent();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Component component = tabPane.getCorner();
        Dimensions dimensions = this.buttonPanorama.getPreferredSize();
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = Math.min(n, dimensions.width);
                int n12 = dimensions.height;
                int n13 = 0;
                if (component != null) {
                    n10 = n - n11;
                    n9 = Math.max(component.getPreferredHeight(-1), dimensions.height - 1);
                    n8 = n11;
                    n7 = Math.max(n12 - n9 - 1, 0);
                    n13 = Math.max(n9 - n12 + 1, 0);
                    component.setLocation(n8, n7);
                    component.setSize(n10, n9);
                }
                this.buttonPanorama.setLocation(0, n13);
                this.buttonPanorama.setSize(n11, n12);
                n3 = this.padding.left + 1;
                n4 = this.padding.top + n13 + n12;
                n5 = Math.max(n - (this.padding.left + this.padding.right + 2), 0);
                n6 = Math.max(n2 - (this.padding.top + this.padding.bottom + n13 + n12 + 1), 0);
                break;
            }
            case VERTICAL: {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11 = dimensions.width;
                int n12 = Math.min(n2, dimensions.height);
                int n13 = 0;
                if (component != null) {
                    n10 = component.getPreferredWidth(-1);
                    n9 = n2 - n12;
                    n8 = Math.max(n11 - n10 - 1, 0);
                    n7 = n12;
                    n13 = Math.max(n10 - n11 + 1, 0);
                    component.setLocation(n8, n7);
                    component.setSize(n10, n9);
                }
                this.buttonPanorama.setLocation(n13, 0);
                this.buttonPanorama.setSize(n11, n12);
                n3 = this.padding.left + n13 + n11;
                n4 = this.padding.top + 1;
                n5 = Math.max(n - (this.padding.left + this.padding.right + n13 + n11 + 1), 0);
                n6 = Math.max(n2 - (this.padding.top + this.padding.bottom + 2), 0);
                break;
            }
        }
        for (Component component2 : tabPane.getTabs()) {
            component2.setLocation(n3, n4);
            if (this.selectionChangeTransition != null && this.selectionChangeTransition.isRunning()) {
                this.clipDecorator.setSize(n5, n6);
                switch (this.tabOrientation) {
                    case HORIZONTAL: {
                        component2.setSize(n5, this.getPreferredTabHeight(n5));
                        break;
                    }
                    case VERTICAL: {
                        component2.setSize(this.getPreferredTabWidth(n6), n6);
                    }
                }
                continue;
            }
            component2.setSize(n5, n6);
        }
    }

    public void paint(Graphics2D graphics2D) {
        TabPane tabPane = (TabPane)this.getComponent();
        Bounds bounds = tabPane.getBounds();
        super.paint(graphics2D);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                n = 0;
                n2 = Math.max(this.buttonPanorama.getY() + this.buttonPanorama.getHeight() - 1, 0);
                n3 = bounds.width;
                n4 = Math.max(bounds.height - n2, 0);
                break;
            }
            case VERTICAL: {
                n = Math.max(this.buttonPanorama.getX() + this.buttonPanorama.getWidth() - 1, 0);
                n2 = 0;
                n3 = Math.max(bounds.width - n, 0);
                n4 = bounds.height;
            }
        }
        int n5 = tabPane.getSelectedIndex();
        if (n5 != -1 || this.selectionChangeTransition != null) {
            Bounds bounds2 = new Bounds(n, n2, n3, n4);
            graphics2D.setPaint(this.activeTabColor);
            graphics2D.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
            graphics2D.setPaint(this.borderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)bounds2.x, (int)bounds2.y, (int)bounds2.width, (int)bounds2.height);
            if (this.tabOrientation == Orientation.VERTICAL) {
                graphics2D.setPaint(new GradientPaint((float)n3 / 2.0f, bounds2.y + 1, this.buttonBevelColor, (float)n3 / 2.0f, bounds2.y + 1 + 4, this.activeTabColor));
                graphics2D.fillRect(bounds2.x + 1, bounds2.y + 1, bounds2.width - 2, 4);
            }
        }
    }

    public Color getActiveTabColor() {
        return this.activeTabColor;
    }

    public void setActiveTabColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("activeTabColor is null.");
        }
        this.activeTabColor = color;
        this.repaintComponent();
    }

    public final void setActiveTabColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("activeTabColor is null.");
        }
        this.setActiveTabColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setActiveTabColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setActiveTabColor(terraTheme.getColor(n));
    }

    public Color getInactiveTabColor() {
        return this.inactiveTabColor;
    }

    public void setInactiveTabColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveTabColor is null.");
        }
        this.inactiveTabColor = color;
        this.buttonBevelColor = TerraTheme.brighten(color);
        this.repaintComponent();
    }

    public final void setInactiveTabColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveTabColor is null.");
        }
        this.setInactiveTabColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInactiveTabColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInactiveTabColor(terraTheme.getColor(n));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.buttonPanorama.getStyles().put("buttonBackgroundColor", (Object)color);
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBorderColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(terraTheme.getColor(n));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = insets;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(dictionary));
    }

    public final void setPadding(int n) {
        this.setPadding(new Insets(n));
    }

    public final void setPadding(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(number.intValue());
    }

    public final void setPadding(String string) {
        if (string == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)string));
    }

    public Font getButtonFont() {
        return this.buttonFont;
    }

    public void setButtonFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("buttonFont is null.");
        }
        this.buttonFont = font;
        this.invalidateComponent();
    }

    public final void setButtonFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setButtonFont(TerraTabPaneSkin.decodeFont((String)string));
    }

    public final void setButtonFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setButtonFont(Theme.deriveFont(dictionary));
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.buttonColor = color;
        this.repaintComponent();
    }

    public final void setButtonColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setButtonColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setButtonColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setButtonColor(terraTheme.getColor(n));
    }

    public Insets getButtonPadding() {
        return this.buttonPadding;
    }

    public void setButtonPadding(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.buttonPadding = insets;
        this.invalidateComponent();
        for (Component component : this.buttonBoxPane) {
            component.invalidate();
        }
    }

    public final void setButtonPadding(int n) {
        this.setButtonPadding(new Insets(n));
    }

    public int getButtonSpacing() {
        return (Integer)this.buttonBoxPane.getStyles().get("spacing");
    }

    public void setButtonSpacing(int n) {
        this.buttonBoxPane.getStyles().put("spacing", (Object)n);
    }

    public Orientation getTabOrientation() {
        return this.tabOrientation;
    }

    public void setTabOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("tabOrientation is null.");
        }
        this.tabOrientation = orientation;
        for (Component component : this.buttonBoxPane) {
            component.invalidate();
        }
        this.buttonBoxPane.setOrientation(orientation);
        switch (orientation) {
            case HORIZONTAL: {
                this.buttonBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
                break;
            }
            case VERTICAL: {
                this.buttonBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.TOP);
            }
        }
    }

    public void setTabOrientation(String string) {
        if (string == null) {
            throw new IllegalArgumentException("tabOrientation is null.");
        }
        this.setTabOrientation(Orientation.valueOf((String)string.toUpperCase()));
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean bl) {
        this.collapsible = bl;
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyPressed(component, n, keyLocation);
        Keyboard.Modifier modifier = Platform.getCommandModifier();
        if (!bl && Keyboard.isPressed((Keyboard.Modifier)modifier)) {
            TabPane tabPane = (TabPane)this.getComponent();
            TabPane.TabSequence tabSequence = tabPane.getTabs();
            int n2 = -1;
            switch (n) {
                case 49: 
                case 97: {
                    n2 = 0;
                    break;
                }
                case 50: 
                case 98: {
                    n2 = 1;
                    break;
                }
                case 51: 
                case 99: {
                    n2 = 2;
                    break;
                }
                case 52: 
                case 100: {
                    n2 = 3;
                    break;
                }
                case 53: 
                case 101: {
                    n2 = 4;
                    break;
                }
                case 54: 
                case 102: {
                    n2 = 5;
                    break;
                }
                case 55: 
                case 103: {
                    n2 = 6;
                    break;
                }
                case 56: 
                case 104: {
                    n2 = 7;
                    break;
                }
                case 57: 
                case 105: {
                    n2 = 8;
                }
            }
            if (n2 >= 0 && n2 < tabSequence.getLength() && tabSequence.get(n2).isEnabled()) {
                tabPane.setSelectedIndex(n2);
                bl = true;
            }
        }
        return bl;
    }

    public void tabInserted(TabPane tabPane, int n) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        Component component = tabPane.getTabs().get(n);
        component.setVisible(false);
        TabButton tabButton = new TabButton(component);
        tabButton.setButtonGroup(this.tabButtonGroup);
        this.buttonBoxPane.insert((Component)tabButton, n);
        tabButton.setEnabled(component.isEnabled());
        component.getComponentStateListeners().add((Object)this.tabStateListener);
        if (tabPane.getTabs().getLength() == 1) {
            tabPane.setSelectedIndex(0);
        }
        this.invalidateComponent();
    }

    public void tabsRemoved(TabPane tabPane, int n, Sequence<Component> sequence) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        Sequence sequence2 = this.buttonBoxPane.remove(n, sequence.getLength());
        int n2 = sequence.getLength();
        for (int i = 0; i < n2; ++i) {
            TabButton tabButton = (TabButton)((Object)sequence2.get(i));
            tabButton.setButtonGroup(null);
            Component component = (Component)tabButton.getButtonData();
            component.getComponentStateListeners().remove((Object)this.tabStateListener);
        }
        this.invalidateComponent();
    }

    public void cornerChanged(TabPane tabPane, Component component) {
        this.invalidateComponent();
    }

    public Vote previewSelectedIndexChange(TabPane tabPane, int n) {
        if (tabPane.isShowing() && this.selectionChangeTransition == null) {
            int n2 = tabPane.getSelectedIndex();
            if (n == -1) {
                Component component = tabPane.getTabs().get(n2);
                this.selectionChangeTransition = new SelectionChangeTransition(component, false);
            } else if (n2 == -1) {
                Component component = tabPane.getTabs().get(n);
                this.selectionChangeTransition = new SelectionChangeTransition(component, true);
            }
            if (this.selectionChangeTransition != null) {
                this.selectionChangeTransition.start(new TransitionListener(){

                    public void transitionCompleted(Transition transition) {
                        TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
                        SelectionChangeTransition selectionChangeTransition = (SelectionChangeTransition)transition;
                        int n = selectionChangeTransition.expand ? tabPane.getTabs().indexOf(selectionChangeTransition.tab) : -1;
                        tabPane.setSelectedIndex(n);
                        TerraTabPaneSkin.this.selectionChangeTransition = null;
                    }
                });
            }
        }
        Vote vote = this.selectionChangeTransition == null || !this.selectionChangeTransition.isRunning() ? Vote.APPROVE : Vote.DEFER;
        return vote;
    }

    public void selectedIndexChangeVetoed(TabPane tabPane, Vote vote) {
        if (vote == Vote.DENY && this.selectionChangeTransition != null) {
            this.selectionChangeTransition.stop();
            this.selectionChangeTransition = null;
            this.invalidateComponent();
        }
    }

    public void selectedIndexChanged(TabPane tabPane, int n) {
        Button button;
        int n2 = tabPane.getSelectedIndex();
        if (n2 == -1) {
            button = this.tabButtonGroup.getSelection();
            if (button != null) {
                button.setSelected(false);
            }
        } else {
            button = (Button)this.buttonBoxPane.get(n2);
            button.setSelected(true);
            Component component = tabPane.getTabs().get(n2);
            component.setVisible(true);
            component.requestFocus();
            ApplicationContext.queueCallback((Runnable)new Runnable(){

                @Override
                public void run() {
                    button.scrollAreaToVisible(0, 0, button.getWidth(), button.getHeight());
                }
            });
        }
        if (n != -1) {
            button = tabPane.getTabs().get(n);
            button.setVisible(false);
        }
        if (n2 == -1 || n == -1) {
            this.invalidateComponent();
        }
    }

    public void labelChanged(TabPane tabPane, Component component, String string) {
        int n = tabPane.getTabs().indexOf(component);
        this.buttonBoxPane.get(n).invalidate();
        this.invalidateComponent();
    }

    public void iconChanged(TabPane tabPane, Component component, Image image) {
        int n = tabPane.getTabs().indexOf(component);
        this.buttonBoxPane.get(n).invalidate();
        this.invalidateComponent();
    }

    public void closeableChanged(TabPane tabPane, Component component) {
        int n = tabPane.getTabs().indexOf(component);
        this.buttonBoxPane.get(n).invalidate();
        this.invalidateComponent();
    }

    public class SelectionChangeTransition
    extends Transition {
        public final Component tab;
        public final boolean expand;
        private Easing easing;

        public SelectionChangeTransition(Component component, boolean bl) {
            super(250, 30, false);
            this.easing = new Quadratic();
            this.tab = component;
            this.expand = bl;
        }

        public float getScale() {
            int n = this.getElapsedTime();
            int n2 = this.getDuration();
            float f = this.expand ? this.easing.easeOut((float)n, 0.0f, 1.0f, (float)n2) : this.easing.easeIn((float)n, 1.0f, -1.0f, (float)n2);
            return f;
        }

        public void start(TransitionListener transitionListener) {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            if (this.expand) {
                this.tab.setVisible(true);
            }
            this.tab.getDecorators().add((Decorator)TerraTabPaneSkin.this.clipDecorator);
            tabPane.setEnabled(false);
            super.start(transitionListener);
        }

        public void stop() {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            if (!this.expand) {
                this.tab.setVisible(false);
            }
            this.tab.getDecorators().remove((Decorator)TerraTabPaneSkin.this.clipDecorator);
            tabPane.setEnabled(true);
            super.stop();
        }

        protected void update() {
            TerraTabPaneSkin.this.invalidateComponent();
        }
    }

    public class TabButtonSkin
    extends ButtonSkin {
        public int getPreferredWidth(int n) {
            Dimensions dimensions = this.getPreferredSize();
            return dimensions.width;
        }

        public int getPreferredHeight(int n) {
            Dimensions dimensions = this.getPreferredSize();
            return dimensions.height;
        }

        public Dimensions getPreferredSize() {
            TabButton tabButton = (TabButton)this.getComponent();
            Button.DataRenderer dataRenderer = tabButton.getDataRenderer();
            dataRenderer.render(tabButton.getButtonData(), (Button)tabButton, false);
            Dimensions dimensions = dataRenderer.getPreferredSize();
            int n = 0;
            int n2 = 0;
            switch (TerraTabPaneSkin.this.tabOrientation) {
                case HORIZONTAL: {
                    n = dimensions.width + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2;
                    n2 = dimensions.height + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2;
                    break;
                }
                case VERTICAL: {
                    n = dimensions.height + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2;
                    n2 = dimensions.width + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2;
                }
            }
            Dimensions dimensions2 = new Dimensions(n, n2);
            return dimensions2;
        }

        public int getBaseline(int n, int n2) {
            TabButton tabButton = (TabButton)this.getComponent();
            Button.DataRenderer dataRenderer = tabButton.getDataRenderer();
            dataRenderer.render(tabButton.getButtonData(), (Button)tabButton, false);
            int n3 = Math.max(n - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2), 0);
            int n4 = Math.max(n2 - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2), 0);
            int n5 = dataRenderer.getBaseline(n3, n4);
            if (n5 != -1) {
                n5 += ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + 1;
            }
            return n5;
        }

        public void paint(Graphics2D graphics2D) {
            TabButton tabButton = (TabButton)this.getComponent();
            Component component = (Component)tabButton.getButtonData();
            boolean bl = TerraTabPaneSkin.this.selectionChangeTransition != null && ((TerraTabPaneSkin)TerraTabPaneSkin.this).selectionChangeTransition.tab == component;
            Color color = tabButton.isSelected() || bl ? TerraTabPaneSkin.this.activeTabColor : TerraTabPaneSkin.this.inactiveTabColor;
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setPaint(color);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 1.0f, TerraTabPaneSkin.this.buttonBevelColor, (float)n / 2.0f, 4.0f, color));
            switch (TerraTabPaneSkin.this.tabOrientation) {
                case HORIZONTAL: {
                    graphics2D.fillRect(1, 1, n - 2, 4);
                    break;
                }
                case VERTICAL: {
                    graphics2D.fillRect(1, 1, n - 1, 4);
                }
            }
            graphics2D.setPaint(TerraTabPaneSkin.this.borderColor);
            if (tabButton.isSelected() || bl) {
                switch (TerraTabPaneSkin.this.tabOrientation) {
                    case HORIZONTAL: {
                        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)0, (int)n2, (Orientation)Orientation.VERTICAL);
                        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (Orientation)Orientation.HORIZONTAL);
                        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)(n - 1), (int)0, (int)n2, (Orientation)Orientation.VERTICAL);
                        break;
                    }
                    case VERTICAL: {
                        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (Orientation)Orientation.HORIZONTAL);
                        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)0, (int)n2, (Orientation)Orientation.VERTICAL);
                        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)(n2 - 1), (int)n, (Orientation)Orientation.HORIZONTAL);
                    }
                }
            } else {
                GraphicsUtilities.drawRect((Graphics2D)graphics2D, (int)0, (int)0, (int)n, (int)n2);
            }
            Button.DataRenderer dataRenderer = tabButton.getDataRenderer();
            dataRenderer.render(tabButton.getButtonData(), (Button)tabButton, false);
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            switch (TerraTabPaneSkin.this.tabOrientation) {
                case HORIZONTAL: {
                    dataRenderer.setSize(Math.max(this.getWidth() - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2), 0), Math.max(this.getHeight() - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2), 0));
                    graphics2D2.translate(((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + 1, ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + 1);
                    break;
                }
                case VERTICAL: {
                    dataRenderer.setSize(Math.max(this.getHeight() - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2), 0), Math.max(this.getWidth() - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2), 0));
                    graphics2D2.translate(((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + 1, ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + 1);
                    graphics2D2.rotate(-1.5707963267948966);
                    graphics2D2.translate(-dataRenderer.getWidth(), 0);
                }
            }
            graphics2D2.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
            dataRenderer.paint(graphics2D2);
            graphics2D2.dispose();
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
            boolean bl = super.mouseClick(component, button, n, n2, n3);
            TabButton tabButton = (TabButton)this.getComponent();
            tabButton.press();
            return bl;
        }

        public Font getFont() {
            return TerraTabPaneSkin.this.buttonFont;
        }

        public Color getColor() {
            return TerraTabPaneSkin.this.buttonColor;
        }

        public Color getDisabledColor() {
            return TerraTabPaneSkin.this.disabledButtonColor;
        }
    }

    public class TabButton
    extends Button {
        public TabButton(Component component) {
            super((Object)component);
            super.setToggleButton(true);
            this.setDataRenderer(DEFAULT_DATA_RENDERER);
            this.setSkin((Skin)new TabButtonSkin());
        }

        public void setToggleButton(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public void setTriState(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public void press() {
            this.setSelected(TerraTabPaneSkin.this.collapsible ? !this.isSelected() : true);
            super.press();
        }
    }
}

