/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewColumnListener;
import org.apache.pivot.wtk.TableViewHeader;
import org.apache.pivot.wtk.TableViewHeaderListener;
import org.apache.pivot.wtk.TableViewSortListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTableViewSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTableViewHeaderSkin
extends ComponentSkin
implements TableViewHeader.Skin,
TableViewHeaderListener,
TableViewColumnListener,
TableViewSortListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private boolean headersPressable;
    private boolean columnsResizable;
    private boolean includeTrailingVerticalGridLine;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;
    private ArrayList<Integer> headerWidths = null;
    private int pressedHeaderIndex = -1;
    private int resizeHeaderIndex = -1;
    private static final int SORT_INDICATOR_PADDING = 2;
    private static final int RESIZE_HANDLE_SIZE = 6;
    public static final int MINIMUM_COLUMN_WIDTH = 2;
    private SortIndicatorImage sortAscendingImage = new SortIndicatorImage(SortDirection.ASCENDING);
    private SortIndicatorImage sortDescendingImage = new SortIndicatorImage(SortDirection.DESCENDING);

    public TerraTableViewHeaderSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.backgroundColor = terraTheme.getColor(10);
        this.disabledBackgroundColor = terraTheme.getColor(10);
        this.borderColor = terraTheme.getColor(7);
        this.disabledBorderColor = terraTheme.getColor(7);
        this.headersPressable = true;
        this.columnsResizable = true;
        this.includeTrailingVerticalGridLine = false;
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
    }

    public void install(Component component) {
        super.install(component);
        TableViewHeader tableViewHeader = (TableViewHeader)component;
        tableViewHeader.getTableViewHeaderListeners().add((Object)this);
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            tableView.getTableViewColumnListeners().add((Object)this);
            tableView.getTableViewSortListeners().add((Object)this);
        }
    }

    public int getPreferredWidth(int n) {
        int n2 = 0;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            n2 = TerraTableViewSkin.getPreferredWidth(tableView, this.includeTrailingVerticalGridLine);
        }
        return n2;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            TableView.ColumnSequence columnSequence = tableView.getColumns();
            TableViewHeader.DataRenderer dataRenderer = tableViewHeader.getDataRenderer();
            int n3 = columnSequence.getLength();
            for (int i = 0; i < n3; ++i) {
                TableView.Column column = columnSequence.get(i);
                dataRenderer.render(column.getHeaderData(), tableViewHeader, false);
                n2 = Math.max(n2, dataRenderer.getPreferredHeight(-1));
            }
            ++n2;
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public int getBaseline(int n, int n2) {
        int n3 = -1;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            ArrayList<Integer> arrayList = TerraTableViewSkin.getColumnWidths(tableView, n);
            int n4 = this.getPreferredHeight(n) - 1;
            TableView.ColumnSequence columnSequence = tableView.getColumns();
            TableViewHeader.DataRenderer dataRenderer = tableViewHeader.getDataRenderer();
            int n5 = columnSequence.getLength();
            for (int i = 0; i < n5; ++i) {
                TableView.Column column = columnSequence.get(i);
                dataRenderer.render(column.getHeaderData(), tableViewHeader, false);
                n3 = Math.max(n3, dataRenderer.getBaseline(((Integer)arrayList.get(i)).intValue(), n4));
            }
        }
        return n3;
    }

    public void layout() {
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        this.headerWidths = tableView != null ? TerraTableViewSkin.getColumnWidths(tableView, this.getWidth()) : null;
    }

    public void paint(Graphics2D graphics2D) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        if (tableViewHeader.isEnabled()) {
            color = this.backgroundColor;
            color2 = this.bevelColor;
            color3 = this.borderColor;
        } else {
            color = this.disabledBackgroundColor;
            color2 = this.disabledBevelColor;
            color3 = this.disabledBorderColor;
        }
        graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, color2, (float)n / 2.0f, n2, color));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setPaint(color3);
        GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)(n2 - 1), (int)n, (Orientation)Orientation.HORIZONTAL);
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            TableView.ColumnSequence columnSequence = tableView.getColumns();
            TableViewHeader.DataRenderer dataRenderer = tableViewHeader.getDataRenderer();
            int n3 = 0;
            int n4 = columnSequence.getLength();
            for (int i = 0; i < n4; ++i) {
                TableView.Column column = columnSequence.get(i);
                int n5 = (Integer)this.headerWidths.get(i);
                if (i == this.pressedHeaderIndex) {
                    graphics2D.setPaint(new GradientPaint((float)n / 2.0f, 0.0f, this.pressedBevelColor, (float)n / 2.0f, n2, color));
                    graphics2D.fillRect(0, 0, n, n2);
                }
                Object object = column.getHeaderData();
                dataRenderer.render(object, tableViewHeader, false);
                dataRenderer.setSize(n5, n2 - 1);
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n3, 0, n5, n2 - 1);
                dataRenderer.paint(graphics2D2);
                graphics2D2.dispose();
                SortIndicatorImage sortIndicatorImage = null;
                String string = column.getName();
                SortDirection sortDirection = tableView.getSort().get(string);
                if (sortDirection != null) {
                    switch (sortDirection) {
                        case ASCENDING: {
                            sortIndicatorImage = this.sortAscendingImage;
                            break;
                        }
                        case DESCENDING: {
                            sortIndicatorImage = this.sortDescendingImage;
                        }
                    }
                }
                if (sortIndicatorImage != null) {
                    int n6 = sortIndicatorImage.getWidth() + 4;
                    if (n5 >= dataRenderer.getPreferredWidth(-1) + n6) {
                        Graphics2D graphics2D3 = (Graphics2D)graphics2D.create();
                        graphics2D3.translate(n3 + n5 - n6, (n2 - sortIndicatorImage.getHeight()) / 2);
                        sortIndicatorImage.paint(graphics2D3);
                        graphics2D3.dispose();
                    }
                }
                n3 += n5;
                if (i < n4 - 1 || this.includeTrailingVerticalGridLine) {
                    graphics2D.setPaint(color3);
                    GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)n3, (int)0, (int)n2, (Orientation)Orientation.VERTICAL);
                }
                ++n3;
            }
        }
    }

    public int getHeaderAt(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("x is negative");
        }
        int n2 = -1;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            int n3;
            int n4 = 0;
            int n5 = tableView.getColumns().getLength();
            for (n3 = 0; n4 < n5 && n > n3; n3 += (Integer)this.headerWidths.get(n4) + 1, ++n4) {
            }
            if (n <= n3) {
                n2 = n4 - 1;
            }
        }
        return n2;
    }

    public Bounds getHeaderBounds(int n) {
        Bounds bounds = null;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            if (n < 0 || n >= this.headerWidths.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 += (Integer)this.headerWidths.get(i) + 1;
            }
            bounds = new Bounds(n2, 0, ((Integer)this.headerWidths.get(n)).intValue(), this.getHeight() - 1);
        }
        return bounds;
    }

    public boolean isFocusable() {
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraTableViewHeaderSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColor(terraTheme.getColor(n));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(terraTheme.getColor(n));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = color;
        this.bevelColor = TerraTheme.brighten(color);
        this.pressedBevelColor = TerraTheme.darken(color);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = color;
        this.disabledBevelColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledBackgroundColor(terraTheme.getColor(n));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = color;
        this.repaintComponent();
    }

    public final void setBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBorderColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(terraTheme.getColor(n));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = color;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledBorderColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledBorderColor(terraTheme.getColor(n));
    }

    public boolean getHeadersPressable() {
        return this.headersPressable;
    }

    public void setHeadersPressable(boolean bl) {
        this.headersPressable = bl;
        this.pressedHeaderIndex = -1;
        this.repaintComponent();
    }

    public boolean getColumnsResizable() {
        return this.columnsResizable;
    }

    public void setColumnsResizable(boolean bl) {
        this.columnsResizable = bl;
    }

    public boolean getIncludeTrailingVerticalGridLine() {
        return this.includeTrailingVerticalGridLine;
    }

    public void setIncludeTrailingVerticalGridLine(boolean bl) {
        this.includeTrailingVerticalGridLine = bl;
        this.invalidateComponent();
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.pressedHeaderIndex = -1;
        this.resizeHeaderIndex = -1;
        this.repaintComponent();
    }

    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            if (this.resizeHeaderIndex != -1 && Mouse.getCapturer() != tableViewHeader) {
                Mouse.capture((Component)tableViewHeader);
            }
            if (Mouse.getCapturer() == tableViewHeader) {
                TableView.Column column = tableView.getColumns().get(this.resizeHeaderIndex);
                Bounds bounds = this.getHeaderBounds(this.resizeHeaderIndex);
                int n3 = Math.max(n - bounds.x, 2);
                column.setWidth(n3, false);
            } else {
                int n4 = this.getHeaderAt(n);
                if (n4 != -1 && this.columnsResizable) {
                    Bounds bounds = this.getHeaderBounds(n4);
                    TableView.Column column = tableView.getColumns().get(n4);
                    if (!column.isRelative() && column.getWidth() != -1 && n > bounds.x + bounds.width - 6) {
                        tableViewHeader.setCursor(Cursor.RESIZE_EAST);
                    } else {
                        tableViewHeader.setCursor((Cursor)null);
                    }
                } else {
                    tableViewHeader.setCursor((Cursor)null);
                }
            }
        }
        return bl;
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        if (this.pressedHeaderIndex != -1) {
            this.repaintComponent(this.getHeaderBounds(this.pressedHeaderIndex));
        }
        this.pressedHeaderIndex = -1;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        int n3;
        TableViewHeader tableViewHeader;
        TableView tableView;
        boolean bl = super.mouseDown(component, button, n, n2);
        if (button == Mouse.Button.LEFT && (tableView = (tableViewHeader = (TableViewHeader)this.getComponent()).getTableView()) != null && (n3 = this.getHeaderAt(n)) != -1) {
            Bounds bounds = this.getHeaderBounds(n3);
            TableView.Column column = tableView.getColumns().get(n3);
            if (this.columnsResizable && !column.isRelative() && column.getWidth() != -1 && n > bounds.x + bounds.width - 6) {
                this.resizeHeaderIndex = n3;
            } else if (this.headersPressable) {
                this.pressedHeaderIndex = n3;
                this.repaintComponent(this.getHeaderBounds(this.pressedHeaderIndex));
            }
        }
        return bl;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseUp(component, button, n, n2);
        if (button == Mouse.Button.LEFT) {
            if (this.resizeHeaderIndex != -1) {
                if (Mouse.getCapturer() == component) {
                    Mouse.release();
                    this.resizeHeaderIndex = -1;
                }
            } else if (this.pressedHeaderIndex != -1) {
                this.repaintComponent(this.getHeaderBounds(this.pressedHeaderIndex));
            }
        }
        return bl;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        if (button == Mouse.Button.LEFT) {
            TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
            TableView tableView = tableViewHeader.getTableView();
            if (this.resizeHeaderIndex != -1) {
                TableView.Column column = tableView.getColumns().get(this.resizeHeaderIndex);
                if (n3 == 2 && !column.isRelative() && column.getWidth() != -1) {
                    int n4 = 0;
                    TableView.CellRenderer cellRenderer = column.getCellRenderer();
                    List list = tableView.getTableData();
                    int n5 = 0;
                    for (Object e : list) {
                        cellRenderer.render(e, n5++, this.resizeHeaderIndex, tableView, column.getName(), false, false, false);
                        n4 = Math.max(cellRenderer.getPreferredWidth(-1), n4);
                    }
                    column.setWidth(n4);
                }
            } else if (this.pressedHeaderIndex != -1) {
                tableViewHeader.pressHeader(this.pressedHeaderIndex);
                TableViewHeader.SortMode sortMode = tableViewHeader.getSortMode();
                if (sortMode != TableViewHeader.SortMode.NONE) {
                    TableView.Column column = tableView.getColumns().get(this.pressedHeaderIndex);
                    String string = column.getName();
                    SortDirection sortDirection = tableView.getSort().get(string);
                    sortDirection = sortDirection == null ? SortDirection.ASCENDING : (sortDirection == SortDirection.ASCENDING ? SortDirection.DESCENDING : SortDirection.ASCENDING);
                    if (sortMode == TableViewHeader.SortMode.MULTI_COLUMN && Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                        tableView.getSort().put(string, sortDirection);
                    } else {
                        tableView.setSort(string, sortDirection);
                    }
                    bl = true;
                }
            }
            this.resizeHeaderIndex = -1;
            this.pressedHeaderIndex = -1;
        }
        return bl;
    }

    public void tableViewChanged(TableViewHeader tableViewHeader, TableView tableView) {
        TableView tableView2;
        if (tableView != null) {
            tableView.getTableViewColumnListeners().remove((Object)this);
            tableView.getTableViewSortListeners().remove((Object)this);
        }
        if ((tableView2 = tableViewHeader.getTableView()) != null) {
            tableView2.getTableViewColumnListeners().add((Object)this);
            tableView2.getTableViewSortListeners().add((Object)this);
        }
        this.invalidateComponent();
    }

    public void dataRendererChanged(TableViewHeader tableViewHeader, TableViewHeader.DataRenderer dataRenderer) {
        this.invalidateComponent();
    }

    public void sortModeChanged(TableViewHeader tableViewHeader, TableViewHeader.SortMode sortMode) {
    }

    public void columnInserted(TableView tableView, int n) {
        this.invalidateComponent();
    }

    public void columnsRemoved(TableView tableView, int n, Sequence<TableView.Column> sequence) {
        this.invalidateComponent();
    }

    public void columnNameChanged(TableView.Column column, String string) {
    }

    public void columnHeaderDataChanged(TableView.Column column, Object object) {
        this.invalidateComponent();
    }

    public void columnWidthChanged(TableView.Column column, int n, boolean bl) {
        this.invalidateComponent();
    }

    public void columnWidthLimitsChanged(TableView.Column column, int n, int n2) {
        this.invalidateComponent();
    }

    public void columnFilterChanged(TableView.Column column, Object object) {
    }

    public void columnCellRendererChanged(TableView.Column column, TableView.CellRenderer cellRenderer) {
    }

    public void sortAdded(TableView tableView, String string) {
        this.repaintComponent();
    }

    public void sortUpdated(TableView tableView, String string, SortDirection sortDirection) {
        this.repaintComponent();
    }

    public void sortRemoved(TableView tableView, String string, SortDirection sortDirection) {
        this.repaintComponent();
    }

    public void sortChanged(TableView tableView) {
        this.repaintComponent();
    }

    private class SortIndicatorImage
    extends Image {
        private SortDirection sortDirection = null;

        public SortIndicatorImage(SortDirection sortDirection) {
            this.sortDirection = sortDirection;
        }

        public int getWidth() {
            return 7;
        }

        public int getHeight() {
            return 4;
        }

        public void paint(Graphics2D graphics2D) {
            GeneralPath generalPath = new GeneralPath();
            switch (this.sortDirection) {
                case ASCENDING: {
                    generalPath.moveTo(0.0f, 3.0f);
                    generalPath.lineTo(3.0f, 0.0f);
                    generalPath.lineTo(6.0f, 3.0f);
                    break;
                }
                case DESCENDING: {
                    generalPath.moveTo(0.0f, 0.0f);
                    generalPath.lineTo(3.0f, 3.0f);
                    generalPath.lineTo(6.0f, 0.0f);
                }
            }
            generalPath.closePath();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setStroke(new BasicStroke(0.0f));
            graphics2D.setPaint(TerraTableViewHeaderSkin.this.borderColor);
            graphics2D.draw(generalPath);
            graphics2D.fill(generalPath);
        }
    }
}

