/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewColumnListener;
import org.apache.pivot.wtk.TableViewListener;
import org.apache.pivot.wtk.TableViewRowListener;
import org.apache.pivot.wtk.TableViewSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTableViewSkin
extends ComponentSkin
implements TableView.Skin,
TableViewListener,
TableViewColumnListener,
TableViewRowListener,
TableViewSelectionListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Color highlightBackgroundColor;
    private Color alternateRowColor;
    private Color columnSelectionColor;
    private Color columnSelectionHorizontalGridColor;
    private Color horizontalGridColor;
    private Color verticalGridColor;
    private boolean showHighlight;
    private boolean showHorizontalGridLines;
    private boolean showVerticalGridLines;
    private boolean includeTrailingVerticalGridLine;
    private boolean includeTrailingHorizontalGridLine;
    private boolean variableRowHeight;
    private ArrayList<Integer> columnWidths = null;
    private ArrayList<Integer> rowHeights = null;
    private int fixedRowHeight = -1;
    private int highlightedIndex = -1;
    private int editIndex = -1;

    public TerraTableViewSkin() {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.font = terraTheme.getFont();
        this.color = terraTheme.getColor(1);
        this.disabledColor = terraTheme.getColor(7);
        this.backgroundColor = terraTheme.getColor(4);
        this.selectionColor = terraTheme.getColor(4);
        this.selectionBackgroundColor = terraTheme.getColor(19);
        this.inactiveSelectionColor = terraTheme.getColor(1);
        this.inactiveSelectionBackgroundColor = terraTheme.getColor(9);
        this.highlightBackgroundColor = terraTheme.getColor(10);
        this.alternateRowColor = terraTheme.getColor(11);
        this.columnSelectionColor = null;
        this.columnSelectionHorizontalGridColor = null;
        this.horizontalGridColor = terraTheme.getColor(11);
        this.verticalGridColor = terraTheme.getColor(11);
        this.showHighlight = true;
        this.showHorizontalGridLines = true;
        this.showVerticalGridLines = true;
        this.includeTrailingVerticalGridLine = false;
        this.includeTrailingHorizontalGridLine = false;
    }

    public void install(Component component) {
        super.install(component);
        TableView tableView = (TableView)component;
        tableView.getTableViewListeners().add((Object)this);
        tableView.getTableViewColumnListeners().add((Object)this);
        tableView.getTableViewRowListeners().add((Object)this);
        tableView.getTableViewSelectionListeners().add((Object)this);
    }

    public int getPreferredWidth(int n) {
        return TerraTableViewSkin.getPreferredWidth((TableView)this.getComponent(), this.includeTrailingVerticalGridLine);
    }

    public static int getPreferredWidth(TableView tableView, boolean bl) {
        int n = 0;
        TableView.ColumnSequence columnSequence = tableView.getColumns();
        List list = tableView.getTableData();
        int n2 = columnSequence.getLength();
        for (int i = 0; i < n2; ++i) {
            TableView.Column column = columnSequence.get(i);
            if (!column.isRelative()) {
                int n3 = column.getWidth();
                if (n3 == -1) {
                    n3 = 0;
                    TableView.CellRenderer cellRenderer = column.getCellRenderer();
                    int n4 = 0;
                    for (Object e : list) {
                        cellRenderer.render(e, n4++, i, tableView, column.getName(), false, false, false);
                        n3 = Math.max(cellRenderer.getPreferredWidth(-1), n3);
                    }
                }
                n += Math.min(Math.max(n3, column.getMinimumWidth()), column.getMaximumWidth());
                continue;
            }
            n += column.getMinimumWidth();
        }
        n += n2 - 1;
        if (bl) {
            ++n;
        }
        return n;
    }

    public int getPreferredHeight(int n) {
        int n2 = 0;
        TableView tableView = (TableView)this.getComponent();
        int n3 = tableView.getTableData().getLength();
        if (this.variableRowHeight) {
            ArrayList<Integer> arrayList = TerraTableViewSkin.getColumnWidths(tableView, n);
            for (int i = 0; i < n3; ++i) {
                n2 += this.getVariableRowHeight(i, arrayList);
            }
        } else {
            int n4 = this.calculateFixedRowHeight(tableView);
            n2 = n4 * n3;
        }
        n2 += n3 - 1;
        if (this.includeTrailingHorizontalGridLine) {
            ++n2;
        }
        return n2;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public int getBaseline(int n, int n2) {
        TableView tableView = (TableView)this.getComponent();
        List list = tableView.getTableData();
        int n3 = -1;
        TableView.ColumnSequence columnSequence = tableView.getColumns();
        ArrayList<Integer> arrayList = TerraTableViewSkin.getColumnWidths(tableView, n);
        if (this.variableRowHeight) {
            int n4 = this.getVariableRowHeight(0, arrayList);
            Object object = list.get(0);
            int n5 = columnSequence.getLength();
            for (int i = 0; i < n5; ++i) {
                TableView.Column column = columnSequence.get(i);
                TableView.CellRenderer cellRenderer = column.getCellRenderer();
                cellRenderer.render(object, 0, i, tableView, column.getName(), false, false, false);
                n3 = Math.max(n3, cellRenderer.getBaseline(((Integer)arrayList.get(i)).intValue(), n4));
            }
        } else {
            int n6 = this.calculateFixedRowHeight(tableView);
            int n7 = columnSequence.getLength();
            for (int i = 0; i < n7; ++i) {
                TableView.Column column = columnSequence.get(i);
                TableView.CellRenderer cellRenderer = column.getCellRenderer();
                cellRenderer.render(null, -1, i, tableView, column.getName(), false, false, false);
                n3 = Math.max(n3, cellRenderer.getBaseline(((Integer)arrayList.get(i)).intValue(), n6));
            }
        }
        return n3;
    }

    public void layout() {
        this.columnWidths = TerraTableViewSkin.getColumnWidths((TableView)this.getComponent(), this.getWidth());
        TableView tableView = (TableView)this.getComponent();
        TableView.ColumnSequence columnSequence = tableView.getColumns();
        if (this.variableRowHeight) {
            List list = tableView.getTableData();
            this.rowHeights = new ArrayList(list.getLength() + 1);
            int n = list.getLength() - 1;
            int n2 = 0;
            for (int i = 0; i <= n; ++i) {
                Object object = list.get(i);
                boolean bl = i == this.highlightedIndex && tableView.getSelectMode() != TableView.SelectMode.NONE;
                boolean bl2 = tableView.isRowSelected(i);
                boolean bl3 = tableView.isRowDisabled(i);
                int n3 = 0;
                int n4 = columnSequence.getLength();
                for (int j = 0; j < n4; ++j) {
                    TableView.Column column = columnSequence.get(j);
                    TableView.CellRenderer cellRenderer = column.getCellRenderer();
                    int n5 = (Integer)this.columnWidths.get(j);
                    cellRenderer.render(object, i, j, tableView, column.getName(), bl2, bl, bl3);
                    n3 = Math.max(n3, cellRenderer.getPreferredHeight(n5));
                }
                this.rowHeights.add((Object)n2);
                n2 += n3 + 1;
            }
            this.rowHeights.add((Object)n2);
        } else {
            this.fixedRowHeight = this.calculateFixedRowHeight(tableView);
        }
    }

    private int calculateFixedRowHeight(TableView tableView) {
        int n = 0;
        TableView.ColumnSequence columnSequence = tableView.getColumns();
        int n2 = columnSequence.getLength();
        for (int i = 0; i < n2; ++i) {
            TableView.Column column = columnSequence.get(i);
            TableView.CellRenderer cellRenderer = column.getCellRenderer();
            cellRenderer.render(null, -1, i, tableView, column.getName(), false, false, false);
            n = Math.max(n, cellRenderer.getPreferredHeight(-1));
        }
        return n;
    }

    public void paint(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        TableView tableView = (TableView)this.getComponent();
        List list = tableView.getTableData();
        TableView.ColumnSequence columnSequence = tableView.getColumns();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        if (this.backgroundColor != null) {
            graphics2D.setPaint(this.backgroundColor);
            graphics2D.fillRect(0, 0, n6, n7);
        }
        int n8 = 0;
        int n9 = list.getLength() - 1;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            if (this.variableRowHeight) {
                n8 = this.getRowAt(rectangle.y);
                if (n8 == -1) {
                    n8 = list.getLength();
                }
                n5 = (Integer)this.rowHeights.get(n9 + 1) - 1;
                n9 = this.getRowAt(Math.min(rectangle.y + rectangle.height - 1, n5));
            } else {
                n8 = Math.max(n8, (int)Math.floor((double)rectangle.y / (double)(this.fixedRowHeight + 1)));
                n9 = Math.min(n9, (int)Math.ceil((double)(rectangle.y + rectangle.height) / (double)(this.fixedRowHeight + 1)) - 1);
            }
        }
        if (this.alternateRowColor != null) {
            for (n5 = n8; n5 <= n9; ++n5) {
                n4 = this.getRowY(n5);
                n3 = this.getRowHeight(n5);
                if (n5 % 2 <= 0) continue;
                graphics2D.setPaint(this.alternateRowColor);
                graphics2D.fillRect(0, n4, n6, n3 + 1);
            }
        }
        n5 = 0;
        if (this.columnSelectionColor != null) {
            graphics2D.setColor(this.columnSelectionColor);
            n5 = 0;
            n3 = columnSequence.getLength();
            for (n4 = 0; n4 < n3; ++n4) {
                TableView.Column column = columnSequence.get(n4);
                n2 = (Integer)this.columnWidths.get(n4);
                String string = column.getName();
                SortDirection sortDirection = tableView.getSort().get(string);
                if (sortDirection != null) {
                    graphics2D.fillRect(n5, 0, n2, n7);
                }
                n5 += n2 + 1;
            }
        }
        for (n4 = n8; n4 <= n9; ++n4) {
            Object object = list.get(n4);
            boolean bl = n4 == this.highlightedIndex && tableView.getSelectMode() != TableView.SelectMode.NONE;
            n2 = tableView.isRowSelected(n4);
            boolean bl2 = tableView.isRowDisabled(n4);
            int n10 = this.getRowY(n4);
            int n11 = this.getRowHeight(n4);
            Color color = null;
            if (n2 != 0) {
                color = tableView.isFocused() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor;
            } else if (bl && this.showHighlight && !bl2) {
                color = this.highlightBackgroundColor;
            }
            if (color != null) {
                graphics2D.setPaint(color);
                graphics2D.fillRect(0, n10, n6, n11);
            }
            n5 = 0;
            int n12 = columnSequence.getLength();
            for (n = 0; n < n12; ++n) {
                TableView.Column column = columnSequence.get(n);
                TableView.CellRenderer cellRenderer = column.getCellRenderer();
                int n13 = (Integer)this.columnWidths.get(n);
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n5, n10, n13, n11);
                cellRenderer.render(object, n4, n, tableView, column.getName(), n2 != 0, bl, bl2);
                cellRenderer.setSize(n13, n11);
                cellRenderer.paint(graphics2D2);
                graphics2D2.dispose();
                n5 += n13 + 1;
            }
        }
        graphics2D.setPaint(this.verticalGridColor);
        if (this.showVerticalGridLines) {
            n5 = 0;
            int n14 = columnSequence.getLength();
            for (n4 = 0; n4 < n14; ++n4) {
                n5 += ((Integer)this.columnWidths.get(n4)).intValue();
                if (n4 < n14 - 1 || this.includeTrailingVerticalGridLine) {
                    GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)n5, (int)0, (int)n7, (Orientation)Orientation.VERTICAL);
                }
                ++n5;
            }
        }
        graphics2D.setPaint(this.horizontalGridColor);
        if (this.showHorizontalGridLines) {
            int n15;
            n4 = list.getLength();
            for (n15 = n8; n15 <= n9; ++n15) {
                int n16 = this.getRowY(n15 + 1) - 1;
                if (n15 >= n4 - 1 && !this.includeTrailingHorizontalGridLine) continue;
                GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)0, (int)n16, (int)n6, (Orientation)Orientation.HORIZONTAL);
            }
            if (this.columnSelectionHorizontalGridColor != null) {
                graphics2D.setColor(this.columnSelectionHorizontalGridColor);
                n5 = 0;
                int n17 = columnSequence.getLength();
                for (n15 = 0; n15 < n17; ++n15) {
                    TableView.Column column = columnSequence.get(n15);
                    int n18 = (Integer)this.columnWidths.get(n15);
                    String string = column.getName();
                    SortDirection sortDirection = tableView.getSort().get(string);
                    if (sortDirection != null) {
                        for (int i = n8; i <= n9; ++i) {
                            n = this.getRowY(i + 1) - 1;
                            if (i >= n4 - 1 && !this.includeTrailingHorizontalGridLine) continue;
                            GraphicsUtilities.drawLine((Graphics2D)graphics2D, (int)n5, (int)n, (int)n18, (Orientation)Orientation.HORIZONTAL);
                        }
                    }
                    n5 += n18 + 1;
                }
            }
        }
    }

    private int getRowY(int n) {
        int n2 = this.variableRowHeight ? (Integer)this.rowHeights.get(n) : n * (this.fixedRowHeight + 1);
        return n2;
    }

    private int getRowHeight(int n) {
        int n2 = this.variableRowHeight ? (Integer)this.rowHeights.get(n + 1) - (Integer)this.rowHeights.get(n) : this.fixedRowHeight;
        return n2;
    }

    protected int getVariableRowHeight(int n, ArrayList<Integer> arrayList) {
        TableView tableView = (TableView)this.getComponent();
        List list = tableView.getTableData();
        TableView.ColumnSequence columnSequence = tableView.getColumns();
        Object object = list.get(0);
        int n2 = 0;
        int n3 = columnSequence.getLength();
        for (int i = 0; i < n3; ++i) {
            TableView.Column column = columnSequence.get(i);
            TableView.CellRenderer cellRenderer = column.getCellRenderer();
            cellRenderer.render(object, n, i, tableView, column.getName(), false, false, false);
            n2 = Math.max(n2, cellRenderer.getPreferredHeight(((Integer)arrayList.get(i)).intValue()));
        }
        return n2;
    }

    public int getRowAt(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("y is negative");
        }
        TableView tableView = (TableView)this.getComponent();
        List list = tableView.getTableData();
        if (this.variableRowHeight) {
            n2 = ArrayList.binarySearch(this.rowHeights, (Comparable)Integer.valueOf(n));
            if (n2 < 0) {
                n2 = -n2 - 2;
            }
        } else {
            n2 = n / (this.fixedRowHeight + 1);
        }
        if (n2 >= list.getLength()) {
            n2 = -1;
        }
        return n2;
    }

    public int getColumnAt(int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("x is negative");
        }
        TableView tableView = (TableView)this.getComponent();
        int n3 = -1;
        int n4 = 0;
        int n5 = tableView.getColumns().getLength();
        for (n2 = 0; n4 < n5 && n > n2; n2 += (Integer)this.columnWidths.get(n4) + 1, ++n4) {
        }
        if (n <= n2) {
            n3 = n4 - 1;
        }
        return n3;
    }

    public Bounds getRowBounds(int n) {
        return new Bounds(0, this.getRowY(n), this.getWidth(), this.getRowHeight(n));
    }

    public Bounds getColumnBounds(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += (Integer)this.columnWidths.get(i) + 1;
        }
        return new Bounds(n2, 0, ((Integer)this.columnWidths.get(n)).intValue(), this.getHeight());
    }

    public Bounds getCellBounds(int n, int n2) {
        int n3;
        TableView tableView = (TableView)this.getComponent();
        List list = tableView.getTableData();
        if (n < 0 || n >= list.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            n4 += (Integer)this.columnWidths.get(n3) + 1;
        }
        n3 = this.getRowHeight(n);
        return new Bounds(n4, n * (n3 + 1), ((Integer)this.columnWidths.get(n2)).intValue(), n3);
    }

    public static ArrayList<Integer> getColumnWidths(TableView tableView, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        TableView.ColumnSequence columnSequence = tableView.getColumns();
        int n5 = columnSequence.getLength();
        ArrayList arrayList = new ArrayList(n5);
        for (n2 = 0; n2 < n5; ++n2) {
            TableView.Column column = columnSequence.get(n2);
            if (column.isRelative()) {
                arrayList.add((Object)0);
                n4 += column.getWidth();
                continue;
            }
            int n6 = column.getWidth();
            if (n6 == -1) {
                n6 = 0;
                TableView.CellRenderer cellRenderer = column.getCellRenderer();
                List list = tableView.getTableData();
                int n7 = 0;
                for (Object e : list) {
                    cellRenderer.render(e, n7++, n2, tableView, column.getName(), false, false, false);
                    n6 = Math.max(cellRenderer.getPreferredWidth(-1), n6);
                }
            }
            n6 = Math.min(Math.max(n6, column.getMinimumWidth()), column.getMaximumWidth());
            arrayList.add((Object)n6);
            n3 += n6;
        }
        n2 = Math.max(n - (n3 += n5 - 1), 0);
        for (int i = 0; i < n5; ++i) {
            TableView.Column column = columnSequence.get(i);
            if (!column.isRelative()) continue;
            int n8 = (int)Math.round((double)(column.getWidth() * n2) / (double)n4);
            arrayList.update(i, (Object)Math.min(Math.max(n8, column.getMinimumWidth()), column.getMaximumWidth()));
        }
        return arrayList;
    }

    public boolean isFocusable() {
        TableView tableView = (TableView)this.getComponent();
        return tableView.getSelectMode() != TableView.SelectMode.NONE;
    }

    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String string) {
        if (string == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraTableViewSkin.decodeFont((String)string));
    }

    public final void setFont(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(dictionary));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColor(terraTheme.getColor(n));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = color;
        this.repaintComponent();
    }

    public final void setDisabledColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setDisabledColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(terraTheme.getColor(n));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(terraTheme.getColor(n));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = color;
        this.repaintComponent();
    }

    public final void setSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setSelectionColor(terraTheme.getColor(n));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setSelectionBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setSelectionBackgroundColor(terraTheme.getColor(n));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = color;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInactiveSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionColor(terraTheme.getColor(n));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setInactiveSelectionBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionBackgroundColor(terraTheme.getColor(n));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = color;
        this.repaintComponent();
    }

    public final void setHighlightBackgroundColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setHighlightBackgroundColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setHighlightBackgroundColor(terraTheme.getColor(n));
    }

    public Color getAlternateRowColor() {
        return this.alternateRowColor;
    }

    public void setAlternateRowColor(Color color) {
        this.alternateRowColor = color;
        this.repaintComponent();
    }

    public final void setAlternateRowColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("alternateRowColor is null.");
        }
        this.setAlternateRowColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setAlternateRowColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setAlternateRowColor(terraTheme.getColor(n));
    }

    public Color getColumnSelectionColor() {
        return this.columnSelectionColor;
    }

    public void setColumnSelectionColor(Color color) {
        this.columnSelectionColor = color;
        this.repaintComponent();
    }

    public final void setColumnSelectionColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("columnSelectionColor is null.");
        }
        this.setColumnSelectionColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColumnSelectionColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColumnSelectionColor(terraTheme.getColor(n));
    }

    public Color getColumnSelectionHorizontalGridColor() {
        return this.columnSelectionHorizontalGridColor;
    }

    public void setColumnSelectionHorizontalGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("columnSelectionHorizontalGridColor is null.");
        }
        this.columnSelectionHorizontalGridColor = color;
        this.repaintComponent();
    }

    public final void setColumnSelectionHorizontalGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("columnSelectionHorizontalGridColor is null.");
        }
        this.setColumnSelectionHorizontalGridColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setColumnSelectionHorizontalGridColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setColumnSelectionHorizontalGridColor(terraTheme.getColor(n));
    }

    public Color getHorizontalGridColor() {
        return this.horizontalGridColor;
    }

    public void setHorizontalGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.horizontalGridColor = color;
        this.repaintComponent();
    }

    public final void setHorizontalGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.setHorizontalGridColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setHorizontalGridColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setHorizontalGridColor(terraTheme.getColor(n));
    }

    public Color getVerticalGridColor() {
        return this.verticalGridColor;
    }

    public void setVerticalGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.verticalGridColor = color;
        this.repaintComponent();
    }

    public final void setVerticalGridColor(String string) {
        if (string == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.setVerticalGridColor(GraphicsUtilities.decodeColor((String)string));
    }

    public final void setVerticalGridColor(int n) {
        TerraTheme terraTheme = (TerraTheme)Theme.getTheme();
        this.setVerticalGridColor(terraTheme.getColor(n));
    }

    public boolean getShowHighlight() {
        return this.showHighlight;
    }

    public void setShowHighlight(boolean bl) {
        this.showHighlight = bl;
        this.repaintComponent();
    }

    public boolean getShowHorizontalGridLines() {
        return this.showHorizontalGridLines;
    }

    public void setShowHorizontalGridLines(boolean bl) {
        this.showHorizontalGridLines = bl;
        this.repaintComponent();
    }

    public boolean getShowVerticalGridLines() {
        return this.showVerticalGridLines;
    }

    public void setShowVerticalGridLines(boolean bl) {
        this.showVerticalGridLines = bl;
        this.repaintComponent();
    }

    public boolean getIncludeTrailingVerticalGridLine() {
        return this.includeTrailingVerticalGridLine;
    }

    public void setIncludeTrailingVerticalGridLine(boolean bl) {
        this.includeTrailingVerticalGridLine = bl;
        this.invalidateComponent();
    }

    public boolean getIncludeTrailingHorizontalGridLine() {
        return this.includeTrailingHorizontalGridLine;
    }

    public void setIncludeTrailingHorizontalGridLine(boolean bl) {
        this.includeTrailingHorizontalGridLine = bl;
        this.invalidateComponent();
    }

    public boolean isVariableRowHeight() {
        return this.variableRowHeight;
    }

    public void setVariableRowHeight(boolean bl) {
        this.variableRowHeight = bl;
        this.rowHeights = null;
        this.fixedRowHeight = -1;
        this.invalidateComponent();
    }

    public boolean mouseMove(Component component, int n, int n2) {
        boolean bl = super.mouseMove(component, n, n2);
        TableView tableView = (TableView)this.getComponent();
        int n3 = this.highlightedIndex;
        this.highlightedIndex = this.getRowAt(n2);
        if (n3 != this.highlightedIndex && tableView.getSelectMode() != TableView.SelectMode.NONE && this.showHighlight) {
            if (n3 != -1) {
                this.repaintComponent(this.getRowBounds(n3));
            }
            if (this.highlightedIndex != -1) {
                this.repaintComponent(this.getRowBounds(this.highlightedIndex));
            }
        }
        return bl;
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        TableView tableView = (TableView)this.getComponent();
        if (this.highlightedIndex != -1 && tableView.getSelectMode() != TableView.SelectMode.NONE && this.showHighlight) {
            this.repaintComponent(this.getRowBounds(this.highlightedIndex));
        }
        this.highlightedIndex = -1;
        this.editIndex = -1;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int n, int n2) {
        boolean bl = super.mouseDown(component, button, n, n2);
        TableView tableView = (TableView)this.getComponent();
        int n3 = this.getRowAt(n2);
        if (n3 >= 0 && !tableView.isRowDisabled(n3)) {
            TableView.SelectMode selectMode = tableView.getSelectMode();
            if (button == Mouse.Button.RIGHT) {
                if (!tableView.isRowSelected(n3) && selectMode != TableView.SelectMode.NONE) {
                    tableView.setSelectedIndex(n3);
                }
            } else {
                Keyboard.Modifier modifier = Platform.getCommandModifier();
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && selectMode == TableView.SelectMode.MULTI) {
                    Filter filter = tableView.getDisabledRowFilter();
                    if (filter == null) {
                        int n4 = tableView.getFirstSelectedIndex();
                        int n5 = tableView.getLastSelectedIndex();
                        Span span = n3 > n4 ? new Span(n4, n3) : new Span(n3, n5);
                        ArrayList arrayList = new ArrayList();
                        arrayList.add((Object)span);
                        tableView.setSelectedRanges((Sequence)arrayList);
                    }
                } else if (Keyboard.isPressed((Keyboard.Modifier)modifier) && selectMode == TableView.SelectMode.MULTI) {
                    if (tableView.isRowSelected(n3)) {
                        tableView.removeSelectedIndex(n3);
                    } else {
                        tableView.addSelectedIndex(n3);
                    }
                } else if (selectMode != TableView.SelectMode.NONE) {
                    if (tableView.isRowSelected(n3) && tableView.isFocused()) {
                        this.editIndex = n3;
                    }
                    tableView.setSelectedIndex(n3);
                }
            }
        }
        tableView.requestFocus();
        return bl;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int n, int n2, int n3) {
        TableView.RowEditor rowEditor;
        boolean bl = super.mouseClick(component, button, n, n2, n3);
        TableView tableView = (TableView)this.getComponent();
        if (this.editIndex != -1 && n3 == 2 && (rowEditor = tableView.getRowEditor()) != null && !rowEditor.isEditing()) {
            rowEditor.editRow(tableView, this.editIndex, this.getColumnAt(n));
        }
        this.editIndex = -1;
        return bl;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int n, int n2, int n3, int n4) {
        TableView tableView = (TableView)this.getComponent();
        if (this.highlightedIndex != -1) {
            Bounds bounds = this.getRowBounds(this.highlightedIndex);
            this.highlightedIndex = -1;
            if (tableView.getSelectMode() != TableView.SelectMode.NONE && this.showHighlight) {
                this.repaintComponent(bounds.x, bounds.y, bounds.width, bounds.height, true);
            }
        }
        return super.mouseWheel(component, scrollType, n, n2, n3, n4);
    }

    public boolean keyPressed(Component component, int n, Keyboard.KeyLocation keyLocation) {
        boolean bl = super.keyPressed(component, n, keyLocation);
        TableView tableView = (TableView)this.getComponent();
        switch (n) {
            case 38: {
                int n2 = tableView.getFirstSelectedIndex();
                while (--n2 >= 0 && tableView.isRowDisabled(n2)) {
                }
                if (n2 >= 0) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && tableView.getSelectMode() == TableView.SelectMode.MULTI) {
                        tableView.addSelectedIndex(n2);
                    } else {
                        tableView.setSelectedIndex(n2);
                    }
                    tableView.scrollAreaToVisible(this.getRowBounds(n2));
                }
                bl = true;
                break;
            }
            case 40: {
                int n3 = tableView.getLastSelectedIndex();
                int n4 = tableView.getTableData().getLength();
                while (++n3 < n4 && tableView.isRowDisabled(n3)) {
                }
                if (n3 < n4) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && tableView.getSelectMode() == TableView.SelectMode.MULTI) {
                        tableView.addSelectedIndex(n3);
                    } else {
                        tableView.setSelectedIndex(n3);
                    }
                    tableView.scrollAreaToVisible(this.getRowBounds(n3));
                }
                bl = true;
                break;
            }
        }
        if (this.highlightedIndex != -1 && tableView.getSelectMode() != TableView.SelectMode.NONE && this.showHighlight) {
            this.repaintComponent(this.getRowBounds(this.highlightedIndex));
        }
        this.highlightedIndex = -1;
        return bl;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component component2) {
        super.focusedChanged(component, component2);
        this.repaintComponent();
    }

    public void tableDataChanged(TableView tableView, List<?> list) {
        this.invalidateComponent();
    }

    public void columnSourceChanged(TableView tableView, TableView tableView2) {
        TableView tableView3;
        if (tableView2 != null) {
            tableView2.getTableViewColumnListeners().remove((Object)this);
        }
        if ((tableView3 = tableView.getColumnSource()) != null) {
            tableView3.getTableViewColumnListeners().add((Object)this);
        }
        this.invalidateComponent();
    }

    public void rowEditorChanged(TableView tableView, TableView.RowEditor rowEditor) {
    }

    public void selectModeChanged(TableView tableView, TableView.SelectMode selectMode) {
        this.repaintComponent();
    }

    public void disabledRowFilterChanged(TableView tableView, Filter<?> filter) {
        this.repaintComponent();
    }

    public void columnInserted(TableView tableView, int n) {
        this.invalidateComponent();
    }

    public void columnsRemoved(TableView tableView, int n, Sequence<TableView.Column> sequence) {
        this.invalidateComponent();
    }

    public void columnNameChanged(TableView.Column column, String string) {
        this.invalidateComponent();
    }

    public void columnHeaderDataChanged(TableView.Column column, Object object) {
    }

    public void columnWidthChanged(TableView.Column column, int n, boolean bl) {
        this.invalidateComponent();
    }

    public void columnWidthLimitsChanged(TableView.Column column, int n, int n2) {
        this.invalidateComponent();
    }

    public void columnFilterChanged(TableView.Column column, Object object) {
    }

    public void columnCellRendererChanged(TableView.Column column, TableView.CellRenderer cellRenderer) {
        this.invalidateComponent();
    }

    public void rowInserted(TableView tableView, int n) {
        this.invalidateComponent();
    }

    public void rowsRemoved(TableView tableView, int n, int n2) {
        this.invalidateComponent();
    }

    public void rowUpdated(TableView tableView, int n) {
        if (this.variableRowHeight) {
            this.invalidateComponent();
        } else {
            this.repaintComponent(this.getRowBounds(n));
        }
    }

    public void rowsCleared(TableView tableView) {
        this.invalidateComponent();
    }

    public void rowsSorted(TableView tableView) {
        if (this.variableRowHeight) {
            this.invalidateComponent();
        } else {
            this.repaintComponent();
        }
    }

    public void selectedRangeAdded(TableView tableView, int n, int n2) {
        this.repaintComponent(0, this.getRowY(n), this.getWidth(), this.getRowY(n2 + 1) - this.getRowY(n));
    }

    public void selectedRangeRemoved(TableView tableView, int n, int n2) {
        this.repaintComponent(0, this.getRowY(n), this.getWidth(), this.getRowY(n) - this.getRowY(n2));
    }

    public void selectedRangesChanged(TableView tableView, Sequence<Span> sequence) {
        List list = tableView.getTableData();
        int n = 0;
        int n2 = list.getLength() - 1;
        for (int i = 0; i < sequence.getLength(); ++i) {
            Span span = (Span)sequence.get(i);
            n = Math.min(n, span.start);
            n2 = Math.max(n2, span.end);
        }
        Sequence sequence2 = tableView.getSelectedRanges();
        for (int i = 0; i < sequence2.getLength(); ++i) {
            Span span = (Span)sequence2.get(i);
            n = Math.min(n, span.start);
            n2 = Math.max(n2, span.end);
        }
        this.repaintComponent(0, this.getRowY(n), this.getWidth(), this.getRowY(n2) + this.getRowY(n2));
    }
}

