/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.ActionClassListener;
import org.apache.pivot.wtk.ActionListener;

public abstract class Action {
    private boolean enabled = true;
    private ActionListenerList actionListeners = new ActionListenerList();
    private static HashMap<String, Action> namedActions = new HashMap();
    private static NamedActionDictionary namedActionDictionary = new NamedActionDictionary();
    private static ActionClassListenerList actionClassListeners = new ActionClassListenerList();

    public Action() {
        this(true);
    }

    public Action(boolean bl) {
        this.setEnabled(bl);
    }

    public String getDescription() {
        return null;
    }

    public abstract void perform();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.actionListeners.enabledChanged(this);
        }
    }

    public static NamedActionDictionary getNamedActions() {
        return namedActionDictionary;
    }

    public ListenerList<ActionListener> getActionListeners() {
        return this.actionListeners;
    }

    public static ListenerList<ActionClassListener> getActionClassListeners() {
        return actionClassListeners;
    }

    private static class ActionClassListenerList
    extends ListenerList<ActionClassListener>
    implements ActionClassListener {
        private ActionClassListenerList() {
        }

        @Override
        public void actionAdded(String string) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ActionClassListener actionClassListener = (ActionClassListener)iterator.next();
                actionClassListener.actionAdded(string);
            }
        }

        @Override
        public void actionUpdated(String string, Action action) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ActionClassListener actionClassListener = (ActionClassListener)iterator.next();
                actionClassListener.actionUpdated(string, action);
            }
        }

        @Override
        public void actionRemoved(String string, Action action) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ActionClassListener actionClassListener = (ActionClassListener)iterator.next();
                actionClassListener.actionRemoved(string, action);
            }
        }
    }

    private static class ActionListenerList
    extends ListenerList<ActionListener>
    implements ActionListener {
        private ActionListenerList() {
        }

        @Override
        public void enabledChanged(Action action) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ActionListener actionListener = (ActionListener)iterator.next();
                actionListener.enabledChanged(action);
            }
        }
    }

    public static final class NamedActionDictionary
    implements Dictionary<String, Action>,
    Iterable<String> {
        private NamedActionDictionary() {
        }

        public Action get(String string) {
            return (Action)namedActions.get((Object)string);
        }

        public Action put(String string, Action action) {
            if (action == null) {
                throw new IllegalArgumentException("action is null.");
            }
            boolean bl = this.containsKey(string);
            Action action2 = (Action)namedActions.put((Object)string, (Object)action);
            if (bl) {
                actionClassListeners.actionUpdated(string, action2);
            } else {
                actionClassListeners.actionAdded(string);
            }
            return action2;
        }

        public Action remove(String string) {
            Action action = null;
            if (this.containsKey(string)) {
                action = (Action)namedActions.remove((Object)string);
                actionClassListeners.actionRemoved(string, action);
            }
            return action;
        }

        public boolean containsKey(String string) {
            return namedActions.containsKey((Object)string);
        }

        @Override
        public Iterator<String> iterator() {
            return new ImmutableIterator(namedActions.iterator());
        }
    }
}

